/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.upgrade;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.highlimit.HighLimit;
import org.neo4j.kernel.impl.store.format.highlimit.v300.HighLimitV3_0_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class RecordFormatsMigrationIT {
    private static final Label LABEL = Label.label((String)"Centipede");
    private static final String PROPERTY = "legs";
    private static final int VALUE = 42;
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory((FileSystemAbstraction)this.fs);

    @Test
    public void migrateLatestStandardToLatestHighLimit() throws IOException {
        RecordFormatsMigrationIT.executeAndStopDb(this.startStandardFormatDb(), this::createNode);
        this.assertLatestStandardStore();
        RecordFormatsMigrationIT.executeAndStopDb(this.startHighLimitFormatDb(), this::assertNodeExists);
        this.assertLatestHighLimitStore();
    }

    @Test
    public void migrateHighLimitV3_0ToLatestHighLimit() throws IOException {
        RecordFormatsMigrationIT.executeAndStopDb(this.startDb("high_limitV3_0_0"), this::createNode);
        this.assertStoreFormat(HighLimitV3_0_0.RECORD_FORMATS);
        RecordFormatsMigrationIT.executeAndStopDb(this.startHighLimitFormatDb(), this::assertNodeExists);
        this.assertLatestHighLimitStore();
    }

    @Test
    public void migrateHighLimitToStandard() throws IOException {
        RecordFormatsMigrationIT.executeAndStopDb(this.startHighLimitFormatDb(), this::createNode);
        this.assertLatestHighLimitStore();
        try {
            this.startStandardFormatDb();
            Assert.fail((String)"Should not be possible to downgrade");
        }
        catch (Exception e) {
            Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)Matchers.instanceOf(StoreUpgrader.UnexpectedUpgradingStoreFormatException.class));
        }
        this.assertLatestHighLimitStore();
    }

    private void createNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node start = db.createNode(new Label[]{LABEL});
            start.setProperty(PROPERTY, (Object)42);
            tx.success();
        }
    }

    private void assertNodeExists(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Assert.assertNotNull((Object)db.findNode(LABEL, PROPERTY, (Object)42));
            tx.success();
        }
    }

    private GraphDatabaseService startStandardFormatDb() {
        return this.startDb("standard");
    }

    private GraphDatabaseService startHighLimitFormatDb() {
        return this.startDb("high_limit");
    }

    private GraphDatabaseService startDb(String recordFormatName) {
        return new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.testDir.graphDbDir()).setConfig(GraphDatabaseSettings.allow_store_upgrade, "true").setConfig(GraphDatabaseSettings.record_format, recordFormatName).newGraphDatabase();
    }

    private void assertLatestStandardStore() throws IOException {
        this.assertStoreFormat(StandardV3_0.RECORD_FORMATS);
    }

    private void assertLatestHighLimitStore() throws IOException {
        this.assertStoreFormat(HighLimit.RECORD_FORMATS);
    }

    private void assertStoreFormat(RecordFormats expected) throws IOException {
        Config config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.pagecache_memory.name(), "8m"}));
        try (PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)this.fs, (Config)config);){
            RecordFormats actual = RecordFormatSelector.selectForStoreOrConfig((Config)config, (File)this.testDir.graphDbDir(), (FileSystemAbstraction)this.fs, (PageCache)pageCache, (LogProvider)NullLogProvider.getInstance());
            Assert.assertNotNull((Object)actual);
            Assert.assertEquals((Object)expected.storeVersion(), (Object)actual.storeVersion());
        }
    }

    private static void executeAndStopDb(GraphDatabaseService db, Consumer<GraphDatabaseService> action) {
        try {
            action.accept(db);
        }
        finally {
            db.shutdown();
        }
    }
}

