/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.rule.TargetDirectory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class BatchInsertEnterpriseTest {
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldInsertDifferentTypesOfThings() throws Exception {
        long relationshipId;
        long node2Id;
        long node1Id;
        BatchInserter inserter = BatchInserters.inserter((File)this.directory.directory(), (Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.log_queries.name(), "true", GraphDatabaseSettings.record_format.name(), "standard", GraphDatabaseSettings.log_queries_filename.name(), this.directory.file("query.log").getAbsolutePath()}));
        try {
            node1Id = inserter.createNode(this.someProperties(1), (Label[])Labels.values());
            node2Id = node1Id + 10L;
            inserter.createNode(node2Id, this.someProperties(2), (Label[])Labels.values());
            relationshipId = inserter.createRelationship(node1Id, node2Id, (RelationshipType)MyRelTypes.TEST, this.someProperties(3));
            inserter.createDeferredSchemaIndex((Label)Labels.One).on("key").create();
            inserter.createDeferredConstraint((Label)Labels.Two).assertPropertyIsUnique("key").create();
        }
        finally {
            inserter.shutdown();
        }
        GraphDatabaseService db = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabase(this.directory.directory());
        try (Transaction tx = db.beginTx();){
            Node node1 = db.getNodeById(node1Id);
            Node node2 = db.getNodeById(node2Id);
            Assert.assertEquals(this.someProperties(1), (Object)node1.getAllProperties());
            Assert.assertEquals(this.someProperties(2), (Object)node2.getAllProperties());
            Assert.assertEquals((long)relationshipId, (long)((Relationship)Iterables.single((Iterable)node1.getRelationships())).getId());
            Assert.assertEquals((long)relationshipId, (long)((Relationship)Iterables.single((Iterable)node2.getRelationships())).getId());
            Assert.assertEquals(this.someProperties(3), (Object)((Relationship)Iterables.single((Iterable)node1.getRelationships())).getAllProperties());
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    private Map<String, Object> someProperties(int id) {
        return MapUtil.map((Object[])new Object[]{"key", "value" + id, "number", 10 + id});
    }

    private static enum Labels implements Label
    {
        One,
        Two;

    }
}

