/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.TargetDirectory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

@RunWith(value=Parameterized.class)
public class BatchInsertEnterpriseTest {
    @Rule
    public final TargetDirectory.TestDirectory directory = TargetDirectory.testDirForTest(this.getClass());
    @Parameterized.Parameter
    public String recordFormat;

    @Parameterized.Parameters(name="{0}")
    public static List<String> recordFormats() {
        return Arrays.asList("standard", "high_limit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldInsertDifferentTypesOfThings() throws Exception {
        long relationshipId;
        long node2Id;
        long node1Id;
        BatchInserter inserter = BatchInserters.inserter((File)this.directory.directory(), (Map)MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.log_queries.name(), "true", GraphDatabaseSettings.record_format.name(), this.recordFormat, GraphDatabaseSettings.log_queries_filename.name(), this.directory.file("query.log").getAbsolutePath()}));
        try {
            node1Id = inserter.createNode(BatchInsertEnterpriseTest.someProperties(1), (Label[])Labels.values());
            node2Id = node1Id + 10L;
            inserter.createNode(node2Id, BatchInsertEnterpriseTest.someProperties(2), (Label[])Labels.values());
            relationshipId = inserter.createRelationship(node1Id, node2Id, (RelationshipType)MyRelTypes.TEST, BatchInsertEnterpriseTest.someProperties(3));
            inserter.createDeferredSchemaIndex((Label)Labels.One).on("key").create();
            inserter.createDeferredConstraint((Label)Labels.Two).assertPropertyIsUnique("key").create();
        }
        finally {
            inserter.shutdown();
        }
        GraphDatabaseService db = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabase(this.directory.directory());
        try (Transaction tx = db.beginTx();){
            Node node1 = db.getNodeById(node1Id);
            Node node2 = db.getNodeById(node2Id);
            Assert.assertEquals(BatchInsertEnterpriseTest.someProperties(1), (Object)node1.getAllProperties());
            Assert.assertEquals(BatchInsertEnterpriseTest.someProperties(2), (Object)node2.getAllProperties());
            Assert.assertEquals((long)relationshipId, (long)((Relationship)Iterables.single((Iterable)node1.getRelationships())).getId());
            Assert.assertEquals((long)relationshipId, (long)((Relationship)Iterables.single((Iterable)node2.getRelationships())).getId());
            Assert.assertEquals(BatchInsertEnterpriseTest.someProperties(3), (Object)((Relationship)Iterables.single((Iterable)node1.getRelationships())).getAllProperties());
            tx.success();
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void insertIntoExistingDatabase() throws IOException {
        File storeDir = this.directory.directory();
        GraphDatabaseService db = this.newDb(storeDir, this.recordFormat);
        try {
            BatchInsertEnterpriseTest.createThreeNodes(db);
        }
        finally {
            db.shutdown();
        }
        BatchInserter inserter = BatchInserters.inserter((File)storeDir);
        try {
            long start = inserter.createNode(BatchInsertEnterpriseTest.someProperties(5), new Label[]{Labels.One});
            long end = inserter.createNode(BatchInsertEnterpriseTest.someProperties(5), new Label[]{Labels.One});
            inserter.createRelationship(start, end, (RelationshipType)MyRelTypes.TEST, BatchInsertEnterpriseTest.someProperties(5));
        }
        finally {
            inserter.shutdown();
        }
        db = this.newDb(storeDir, this.recordFormat);
        try {
            BatchInsertEnterpriseTest.verifyNodeCount(db, 4);
        }
        finally {
            db.shutdown();
        }
    }

    private static void verifyNodeCount(GraphDatabaseService db, int expectedNodeCount) {
        try (Transaction tx = db.beginTx();){
            Assert.assertEquals((long)expectedNodeCount, (long)Iterables.count((Iterable)db.getAllNodes()));
            tx.success();
        }
    }

    private static void createThreeNodes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node start = db.createNode(new Label[]{Labels.One});
            BatchInsertEnterpriseTest.someProperties(5).forEach((arg_0, arg_1) -> ((Node)start).setProperty(arg_0, arg_1));
            Node end = db.createNode(new Label[]{Labels.Two});
            BatchInsertEnterpriseTest.someProperties(5).forEach((arg_0, arg_1) -> ((Node)end).setProperty(arg_0, arg_1));
            Relationship rel = start.createRelationshipTo(end, (RelationshipType)MyRelTypes.TEST);
            BatchInsertEnterpriseTest.someProperties(5).forEach((arg_0, arg_1) -> ((Relationship)rel).setProperty(arg_0, arg_1));
            tx.success();
        }
    }

    private static Map<String, Object> someProperties(int id) {
        return MapUtil.map((Object[])new Object[]{"key", "value" + id, "number", 10 + id});
    }

    private GraphDatabaseService newDb(File storeDir, String recordFormat) {
        return new EnterpriseGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.record_format, recordFormat).newGraphDatabase();
    }

    private static enum Labels implements Label
    {
        One,
        Two;

    }
}

