/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.impl.store.format.highlimit.HighLimit;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_0;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_1;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_2;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;

public class RecordFormatsGenerationTest {
    @Test
    public void correctGenerations() {
        List<Integer> expectedGenerations = Arrays.asList(StandardV2_0.RECORD_FORMATS.generation(), StandardV2_1.RECORD_FORMATS.generation(), StandardV2_2.RECORD_FORMATS.generation(), StandardV2_3.RECORD_FORMATS.generation(), StandardV3_0.RECORD_FORMATS.generation(), HighLimit.RECORD_FORMATS.generation());
        Assert.assertEquals(expectedGenerations, RecordFormatsGenerationTest.distinct(RecordFormatsGenerationTest.allGenerations()));
    }

    @Test
    public void uniqueGenerations() {
        Assert.assertEquals(RecordFormatsGenerationTest.allGenerations(), RecordFormatsGenerationTest.distinct(RecordFormatsGenerationTest.allGenerations()));
    }

    private static List<Integer> allGenerations() {
        return Arrays.stream(StoreVersion.values()).map(StoreVersion::versionString).map(RecordFormatSelector::selectForVersion).map(RecordFormats::generation).sorted().collect(Collectors.toList());
    }

    private static List<Integer> distinct(List<Integer> integers) {
        return integers.stream().distinct().collect(Collectors.toList());
    }
}

