/*
 * Decompiled with CFR 0.152.
 */
package upgrade;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.EnterpriseGraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.api.scan.InMemoryLabelScanStore;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.SchemaIndexMigrator;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import upgrade.DatabaseContentVerifier;
import upgrade.ListAccumulatorMigrationProgressMonitor;
import upgrade.StoreMigratorTestUtil;

@RunWith(value=Parameterized.class)
public class StoreMigratorFrom20IT {
    @Rule
    public final TargetDirectory.TestDirectory storeDir = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private Config config;
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    private final ListAccumulatorMigrationProgressMonitor monitor = new ListAccumulatorMigrationProgressMonitor();
    private StoreFactory storeFactory;
    private PageCache pageCache;
    private final LifeSupport life = new LifeSupport();
    private UpgradableDatabase upgradableDatabase;
    private SchemaIndexProvider schemaIndexProvider;
    private LabelScanStoreProvider labelScanStoreProvider;
    @Parameterized.Parameter(value=0)
    public String formatName;
    private RecordFormats format;

    @Parameterized.Parameters
    public static Collection<String> formats() {
        return Arrays.asList("standard", "high_limit");
    }

    @Before
    public void setUp() {
        this.config = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.record_format.name(), this.formatName}));
        this.pageCache = this.pageCacheRule.getPageCache(this.fs);
        this.schemaIndexProvider = new LuceneSchemaIndexProvider(this.fs, DirectoryFactory.PERSISTENT, this.storeDir.directory());
        this.labelScanStoreProvider = new LabelScanStoreProvider((LabelScanStore)new InMemoryLabelScanStore(), 1);
        this.format = RecordFormatSelector.select((Config)this.config, (LogService)NullLogService.getInstance());
        this.storeFactory = new StoreFactory(this.storeDir.directory(), this.config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), this.pageCache, this.fs, this.format, (LogProvider)NullLogProvider.getInstance());
        this.upgradableDatabase = new UpgradableDatabase(this.fs, new StoreVersionCheck(this.pageCache), new LegacyStoreVersionCheck(this.fs), this.format);
    }

    @After
    public void tearDown() {
        this.life.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldMigrate() throws IOException, ConsistencyCheckIncompleteException {
        StoreMigrator storeMigrator = new StoreMigrator(this.fs, this.pageCache, this.config, (LogService)NullLogService.getInstance(), this.schemaIndexProvider);
        SchemaIndexMigrator indexMigrator = new SchemaIndexMigrator(this.fs, this.schemaIndexProvider, this.labelScanStoreProvider);
        this.upgrader(indexMigrator, storeMigrator).migrateIfNeeded(MigrationTestUtils.find20FormatStoreDirectory((File)this.storeDir.directory()));
        Assert.assertEquals((long)2L, (long)this.monitor.progresses().size());
        Assert.assertTrue((boolean)this.monitor.isStarted());
        Assert.assertTrue((boolean)this.monitor.isFinished());
        GraphDatabaseService database = new EnterpriseGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.storeDir.absolutePath()).setConfig(GraphDatabaseSettings.record_format, this.formatName).newGraphDatabase();
        try {
            StoreMigratorFrom20IT.verifyDatabaseContents(database);
        }
        finally {
            database.shutdown();
        }
        try (NeoStores neoStores = this.storeFactory.openAllNeoStores(true);){
            this.verifyNeoStore(neoStores);
        }
        StoreAssertions.assertConsistentStore((File)this.storeDir.directory(), (Config)this.config);
    }

    @Test
    public void shouldMigrateCluster() throws Throwable {
        File legacyStoreDir = MigrationTestUtils.find20FormatStoreDirectory((File)this.storeDir.directory());
        StoreMigrator storeMigrator = new StoreMigrator(this.fs, this.pageCache, this.config, (LogService)NullLogService.getInstance(), this.schemaIndexProvider);
        SchemaIndexMigrator indexMigrator = new SchemaIndexMigrator(this.fs, this.schemaIndexProvider, this.labelScanStoreProvider);
        this.upgrader(indexMigrator, storeMigrator).migrateIfNeeded(legacyStoreDir);
        ClusterManager.ManagedCluster cluster = StoreMigratorTestUtil.buildClusterWithMasterDirIn(this.fs, legacyStoreDir, this.life, this.config.getParams());
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        StoreMigratorFrom20IT.verifySlaveContents(slave1);
        StoreMigratorFrom20IT.verifySlaveContents(cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{slave1}));
        StoreMigratorFrom20IT.verifyDatabaseContents((GraphDatabaseService)cluster.getMaster());
    }

    private static void verifyDatabaseContents(GraphDatabaseService database) {
        DatabaseContentVerifier verifier = new DatabaseContentVerifier(database, 2);
        StoreMigratorFrom20IT.verifyNumberOfNodesAndRelationships(verifier);
        StoreMigratorFrom20IT.createNewNode(database);
        StoreMigratorFrom20IT.createNewRelationship(database);
        verifier.verifyLegacyIndex();
        verifier.verifyIndex();
        verifier.verifyJohnnyLabels();
    }

    private static void createNewNode(GraphDatabaseService database) {
        try (Transaction tx = database.beginTx();){
            database.createNode();
            tx.success();
        }
    }

    private static void createNewRelationship(GraphDatabaseService database) {
        try (Transaction tx = database.beginTx();){
            database.createNode().createRelationshipTo(database.createNode(), (RelationshipType)MyRelTypes.TEST);
            tx.success();
        }
    }

    private static void verifySlaveContents(HighlyAvailableGraphDatabase haDb) {
        DatabaseContentVerifier verifier = new DatabaseContentVerifier((GraphDatabaseService)haDb, 2);
        StoreMigratorFrom20IT.verifyNumberOfNodesAndRelationships(verifier);
    }

    private static void verifyNumberOfNodesAndRelationships(DatabaseContentVerifier verifier) {
        verifier.verifyNodes(502);
        verifier.verifyRelationships(500);
    }

    public void verifyNeoStore(NeoStores neoStores) {
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        Assert.assertEquals((long)1317392957120L, (long)metaDataStore.getCreationTime());
        Assert.assertEquals((long)-472309512128245482L, (long)metaDataStore.getRandomNumber());
        Assert.assertEquals((long)5L, (long)metaDataStore.getCurrentLogVersion());
        Assert.assertEquals((Object)this.format.storeVersion(), (Object)MetaDataStore.versionLongToString((long)metaDataStore.getStoreVersion()));
        Assert.assertEquals((long)1042L, (long)metaDataStore.getLastCommittedTransactionId());
    }

    private StoreUpgrader upgrader(SchemaIndexMigrator indexMigrator, StoreMigrator storeMigrator) {
        Map params = this.config.getParams();
        params.put(GraphDatabaseSettings.allow_store_upgrade.name(), "true");
        Config config = new Config(params);
        StoreUpgrader upgrader = new StoreUpgrader(this.upgradableDatabase, (MigrationProgressMonitor)this.monitor, config, this.fs, (LogProvider)NullLogProvider.getInstance());
        upgrader.addParticipant((StoreMigrationParticipant)indexMigrator);
        upgrader.addParticipant((StoreMigrationParticipant)storeMigrator);
        return upgrader;
    }
}

