/*
 * Decompiled with CFR 0.152.
 */
package upgrade;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;

public class StoreMigratorTestUtil {
    StoreMigratorTestUtil() {
    }

    public static ClusterManager.ManagedCluster buildClusterWithMasterDirIn(FileSystemAbstraction fs, final File legacyStoreDir, LifeSupport life, Map<String, String> sharedConfig) throws Throwable {
        File haRootDir = new File(legacyStoreDir.getParentFile(), "ha-migration");
        fs.deleteRecursively(haRootDir);
        ClusterManager clusterManager = new ClusterManager.Builder(haRootDir).withStoreDirInitializer(new ClusterManager.StoreDirInitializer(){

            public void initializeStoreDir(int serverId, File storeDir) throws IOException {
                if (serverId == 1) {
                    FileUtils.copyRecursively((File)legacyStoreDir, (File)storeDir);
                }
            }
        }).withCluster(ClusterManager.clusterOfSize((int)3)).withSharedConfig(sharedConfig).build();
        life.add((Lifecycle)clusterManager);
        life.start();
        return clusterManager.getCluster();
    }
}

