/*
 * Decompiled with CFR 0.152.
 */
package upgrade;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TargetDirectory;

public class StoreMigratorFrom21IT {
    @Rule
    public final TargetDirectory.TestDirectory storeDir = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void mustMendDuplicatePropertiesWhenUpgradingFromVersion21() throws Exception {
        File dir = MigrationTestUtils.find21FormatStoreDirectoryWithDuplicateProperties((File)this.storeDir.directory());
        GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dir).setConfig(GraphDatabaseSettings.allow_store_upgrade, "true").setConfig(GraphDatabaseSettings.record_format, "standard");
        GraphDatabaseService database = builder.newGraphDatabase();
        database.shutdown();
        ConsistencyCheckService service = new ConsistencyCheckService();
        ConsistencyCheckService.Result result = service.runFullConsistencyCheck(dir.getAbsoluteFile(), Config.defaults().with(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.record_format.name(), "standard"}), new Class[0]), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
        Assert.assertTrue((boolean)result.isSuccessful());
        database = builder.newGraphDatabase();
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)database).getDependencyResolver();
        try (Transaction ignore = database.beginTx();){
            this.verifyProperties((PropertyContainer)database.getNodeById(0L), Pair.of((Object)"keyA", (Object)new Object[]{"actual", "phony!", "phony!"}));
            this.verifyProperties((PropertyContainer)database.getNodeById(1L), Pair.of((Object)"keyA", (Object)new Object[]{"actual", "actual", "actual"}));
            this.verifyProperties((PropertyContainer)database.getNodeById(2L), Pair.of((Object)"keyA", (Object)new Object[]{"real1", "phony", "phony"}), Pair.of((Object)"keyD", (Object)new Object[]{"real2", "phony", "phony"}));
            this.verifyProperties((PropertyContainer)database.getNodeById(3L), Pair.of((Object)"keyA", (Object)new Object[]{"real1", "real1", "real1"}), Pair.of((Object)"keyD", (Object)new Object[]{"real2", "real2", "real2"}));
            this.verifyProperties((PropertyContainer)database.getNodeById(4L), Pair.of((Object)"keyA", (Object)new Object[]{"actual"}), Pair.of((Object)"keyB", (Object)new Object[]{"actual"}), Pair.of((Object)"keyC", (Object)new Object[]{"actual"}));
            this.verifyProperties((PropertyContainer)database.getRelationshipById(0L), Pair.of((Object)"keyA", (Object)new Object[]{"actual", "actual", "actual"}));
            this.verifyProperties((PropertyContainer)database.getRelationshipById(1L), Pair.of((Object)"keyA", (Object)new Object[]{"real1", "real1", "real1"}), Pair.of((Object)"keyD", (Object)new Object[]{"real2", "real2", "real2"}));
            this.verifyProperties((PropertyContainer)database.getRelationshipById(2L), Pair.of((Object)"keyA", (Object)new Object[]{"actual"}), Pair.of((Object)"keyB", (Object)new Object[]{"actual"}), Pair.of((Object)"keyC", (Object)new Object[]{"actual"}));
        }
        KernelAPI kernel = (KernelAPI)dependencyResolver.resolveDependency(KernelAPI.class);
        try (KernelTransaction tx = kernel.newTransaction(KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.READ);
             Statement statement = tx.acquireStatement();){
            Iterators.asUniqueSet((Object[])new PrimitiveIntIterator[]{statement.readOperations().nodeGetPropertyKeys(0L)});
            Iterators.asUniqueSet((Object[])new PrimitiveIntIterator[]{statement.readOperations().nodeGetPropertyKeys(1L)});
            Iterators.asUniqueSet((Object[])new PrimitiveIntIterator[]{statement.readOperations().nodeGetPropertyKeys(2L)});
            Iterators.asUniqueSet((Object[])new PrimitiveIntIterator[]{statement.readOperations().relationshipGetPropertyKeys(0L)});
            Iterators.asUniqueSet((Object[])new PrimitiveIntIterator[]{statement.readOperations().relationshipGetPropertyKeys(1L)});
        }
        database.shutdown();
    }

    private void verifyProperties(PropertyContainer entity, Pair<String, Object[]> ... expectedPropertyGroups) {
        for (Pair<String, Object[]> group : expectedPropertyGroups) {
            Predicate<Map.Entry> filter = entry -> ((String)entry.getKey()).equals(group.first()) || ((String)entry.getKey()).contains("__DUPLICATE_" + (String)group.first() + "_");
            Map<String, Object> relevantProperties = entity.getAllProperties().entrySet().stream().filter(filter).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> entry.getValue()));
            Assert.assertEquals((long)((Object[])group.other()).length, (long)relevantProperties.size());
            ArrayList<Object> relevantValues = new ArrayList<Object>(relevantProperties.values());
            for (Object expectedValue : (Object[])group.other()) {
                Assert.assertTrue((boolean)relevantValues.remove(expectedValue));
            }
            Assert.assertTrue((relevantValues.size() == 0 ? 1 : 0) != 0);
        }
    }
}

