/*
 * Decompiled with CFR 0.152.
 */
package upgrade;

import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.impl.index.storage.DirectoryFactory;
import org.neo4j.kernel.api.impl.schema.LuceneSchemaIndexProvider;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.api.scan.InMemoryLabelScanStore;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.format.InternalRecordFormatSelector;
import org.neo4j.kernel.impl.store.id.DefaultIdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.SchemaIndexMigrator;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import upgrade.DatabaseContentVerifier;
import upgrade.ListAccumulatorMigrationProgressMonitor;
import upgrade.StoreMigratorTestUtil;

public class StoreMigratorFrom20IT {
    @Rule
    public final TargetDirectory.TestDirectory storeDir = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private final Config config = new Config(MapUtil.stringMap((String[])new String[0]), new Class[]{GraphDatabaseSettings.class});
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    private final ListAccumulatorMigrationProgressMonitor monitor = new ListAccumulatorMigrationProgressMonitor();
    private StoreFactory storeFactory;
    private PageCache pageCache;
    private final LifeSupport life = new LifeSupport();
    private UpgradableDatabase upgradableDatabase;
    private SchemaIndexProvider schemaIndexProvider;
    private LabelScanStoreProvider labelScanStoreProvider;

    @Before
    public void setUp() {
        this.pageCache = this.pageCacheRule.getPageCache(this.fs);
        this.schemaIndexProvider = new LuceneSchemaIndexProvider(this.fs, DirectoryFactory.PERSISTENT, this.storeDir.directory());
        this.labelScanStoreProvider = new LabelScanStoreProvider((LabelScanStore)new InMemoryLabelScanStore(), 1);
        this.storeFactory = new StoreFactory(this.storeDir.directory(), this.config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), this.pageCache, this.fs, (LogProvider)NullLogProvider.getInstance());
        this.upgradableDatabase = new UpgradableDatabase(this.fs, new StoreVersionCheck(this.pageCache), new LegacyStoreVersionCheck(this.fs), InternalRecordFormatSelector.select());
    }

    @After
    public void tearDown() {
        this.life.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldMigrate() throws IOException, ConsistencyCheckIncompleteException {
        StoreMigrator storeMigrator = new StoreMigrator(this.fs, this.pageCache, this.config, (LogService)NullLogService.getInstance(), this.schemaIndexProvider);
        SchemaIndexMigrator indexMigrator = new SchemaIndexMigrator(this.fs, this.schemaIndexProvider, this.labelScanStoreProvider);
        this.upgrader(indexMigrator, storeMigrator).migrateIfNeeded(MigrationTestUtils.find20FormatStoreDirectory((File)this.storeDir.directory()));
        Assert.assertEquals((long)2L, (long)this.monitor.progresses().size());
        Assert.assertTrue((boolean)this.monitor.isStarted());
        Assert.assertTrue((boolean)this.monitor.isFinished());
        GraphDatabaseService database = new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir.absolutePath());
        try {
            StoreMigratorFrom20IT.verifyDatabaseContents(database);
        }
        finally {
            database.shutdown();
        }
        try (NeoStores neoStores = this.storeFactory.openAllNeoStores(true);){
            StoreMigratorFrom20IT.verifyNeoStore(neoStores);
        }
        StoreAssertions.assertConsistentStore((File)this.storeDir.directory());
    }

    @Test
    public void shouldMigrateCluster() throws Throwable {
        File legacyStoreDir = MigrationTestUtils.find20FormatStoreDirectory((File)this.storeDir.directory());
        StoreMigrator storeMigrator = new StoreMigrator(this.fs, this.pageCache, this.config, (LogService)NullLogService.getInstance(), this.schemaIndexProvider);
        SchemaIndexMigrator indexMigrator = new SchemaIndexMigrator(this.fs, this.schemaIndexProvider, this.labelScanStoreProvider);
        this.upgrader(indexMigrator, storeMigrator).migrateIfNeeded(legacyStoreDir);
        ClusterManager.ManagedCluster cluster = StoreMigratorTestUtil.buildClusterWithMasterDirIn(this.fs, legacyStoreDir, this.life);
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        StoreMigratorFrom20IT.verifySlaveContents(slave1);
        StoreMigratorFrom20IT.verifySlaveContents(cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{slave1}));
        StoreMigratorFrom20IT.verifyDatabaseContents((GraphDatabaseService)cluster.getMaster());
    }

    private static void verifyDatabaseContents(GraphDatabaseService database) {
        DatabaseContentVerifier verifier = new DatabaseContentVerifier(database, 2);
        StoreMigratorFrom20IT.verifyNumberOfNodesAndRelationships(verifier);
        verifier.verifyNodeIdsReused();
        verifier.verifyRelationshipIdsReused();
        verifier.verifyLegacyIndex();
        verifier.verifyIndex();
        verifier.verifyJohnnyLabels();
    }

    private static void verifySlaveContents(HighlyAvailableGraphDatabase haDb) {
        DatabaseContentVerifier verifier = new DatabaseContentVerifier((GraphDatabaseService)haDb, 2);
        StoreMigratorFrom20IT.verifyNumberOfNodesAndRelationships(verifier);
    }

    private static void verifyNumberOfNodesAndRelationships(DatabaseContentVerifier verifier) {
        verifier.verifyNodes(502);
        verifier.verifyRelationships(500);
    }

    public static void verifyNeoStore(NeoStores neoStores) {
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        Assert.assertEquals((long)1317392957120L, (long)metaDataStore.getCreationTime());
        Assert.assertEquals((long)-472309512128245482L, (long)metaDataStore.getRandomNumber());
        Assert.assertEquals((long)5L, (long)metaDataStore.getCurrentLogVersion());
        Assert.assertEquals((Object)InternalRecordFormatSelector.select().storeVersion(), (Object)MetaDataStore.versionLongToString((long)metaDataStore.getStoreVersion()));
        Assert.assertEquals((long)1042L, (long)metaDataStore.getLastCommittedTransactionId());
    }

    private StoreUpgrader upgrader(SchemaIndexMigrator indexMigrator, StoreMigrator storeMigrator) {
        Config allowUpgrade = new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.allow_store_upgrade.name(), "true"}));
        StoreUpgrader upgrader = new StoreUpgrader(this.upgradableDatabase, (MigrationProgressMonitor)this.monitor, allowUpgrade, this.fs, (LogProvider)NullLogProvider.getInstance());
        upgrader.addParticipant((StoreMigrationParticipant)indexMigrator);
        upgrader.addParticipant((StoreMigrationParticipant)storeMigrator);
        return upgrader;
    }
}

