/*
 * Decompiled with CFR 0.152.
 */
package upgrade;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.consistency.ConsistencyCheckService;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.helpers.progress.ProgressMonitorFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TargetDirectory;

public class StoreMigratorFrom21IT {
    @Rule
    public final TargetDirectory.TestDirectory storeDir = TargetDirectory.testDirForTest(this.getClass());

    @Test
    public void mustMendDuplicatePropertiesWhenUpgradingFromVersion21() throws Exception {
        File dir = MigrationTestUtils.find21FormatStoreDirectoryWithDuplicateProperties((File)this.storeDir.directory());
        GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(dir.getAbsolutePath()).setConfig(GraphDatabaseSettings.allow_store_upgrade, "true");
        GraphDatabaseService database = builder.newGraphDatabase();
        database.shutdown();
        ConsistencyCheckService service = new ConsistencyCheckService();
        ConsistencyCheckService.Result result = service.runFullConsistencyCheck(dir.getAbsoluteFile(), new Config(), ProgressMonitorFactory.NONE, (LogProvider)NullLogProvider.getInstance(), false);
        Assert.assertTrue((boolean)result.isSuccessful());
        database = builder.newGraphDatabase();
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)database).getDependencyResolver();
        try (Transaction ignore = database.beginTx();){
            this.verifyPropertiesEqual((PropertyContainer)database.getNodeById(0L), Pair.of((Object)"keyA", (Object)"actual"), Pair.of((Object)"__DUPLICATE_keyA_1", (Object)"phony!"), Pair.of((Object)"__DUPLICATE_keyA_2", (Object)"phony!"));
            this.verifyPropertiesEqual((PropertyContainer)database.getNodeById(1L), Pair.of((Object)"keyA", (Object)"actual"), Pair.of((Object)"__DUPLICATE_keyA_1", (Object)"actual"), Pair.of((Object)"__DUPLICATE_keyA_2", (Object)"actual"));
            this.verifyPropertiesEqual((PropertyContainer)database.getNodeById(2L), Pair.of((Object)"keyA", (Object)"real1"), Pair.of((Object)"keyD", (Object)"real2"), Pair.of((Object)"__DUPLICATE_keyD_2", (Object)"phony"), Pair.of((Object)"__DUPLICATE_keyD_1", (Object)"phony"), Pair.of((Object)"__DUPLICATE_keyA_1", (Object)"phony"), Pair.of((Object)"__DUPLICATE_keyA_2", (Object)"phony"));
            this.verifyPropertiesEqual((PropertyContainer)database.getNodeById(3L), Pair.of((Object)"keyA", (Object)"real1"), Pair.of((Object)"__DUPLICATE_keyA_1", (Object)"real1"), Pair.of((Object)"__DUPLICATE_keyA_2", (Object)"real1"), Pair.of((Object)"keyD", (Object)"real2"), Pair.of((Object)"__DUPLICATE_keyD_1", (Object)"real2"), Pair.of((Object)"__DUPLICATE_keyD_2", (Object)"real2"));
            this.verifyPropertiesEqual((PropertyContainer)database.getNodeById(4L), Pair.of((Object)"keyA", (Object)"actual"), Pair.of((Object)"keyB", (Object)"actual"), Pair.of((Object)"keyC", (Object)"actual"));
            this.verifyPropertiesEqual((PropertyContainer)database.getRelationshipById(0L), Pair.of((Object)"keyA", (Object)"actual"), Pair.of((Object)"__DUPLICATE_keyA_1", (Object)"actual"), Pair.of((Object)"__DUPLICATE_keyA_2", (Object)"actual"));
            this.verifyPropertiesEqual((PropertyContainer)database.getRelationshipById(1L), Pair.of((Object)"keyA", (Object)"real1"), Pair.of((Object)"__DUPLICATE_keyA_1", (Object)"real1"), Pair.of((Object)"__DUPLICATE_keyA_2", (Object)"real1"), Pair.of((Object)"keyD", (Object)"real2"), Pair.of((Object)"__DUPLICATE_keyD_1", (Object)"real2"), Pair.of((Object)"__DUPLICATE_keyD_2", (Object)"real2"));
            this.verifyPropertiesEqual((PropertyContainer)database.getRelationshipById(2L), Pair.of((Object)"keyA", (Object)"actual"), Pair.of((Object)"keyB", (Object)"actual"), Pair.of((Object)"keyC", (Object)"actual"));
        }
        KernelAPI kernel = (KernelAPI)dependencyResolver.resolveDependency(KernelAPI.class);
        try (KernelTransaction tx = kernel.newTransaction();
             Statement statement = tx.acquireStatement();){
            IteratorUtil.asUniqueSet((Object[])new PrimitiveIntIterator[]{statement.readOperations().nodeGetPropertyKeys(0L)});
            IteratorUtil.asUniqueSet((Object[])new PrimitiveIntIterator[]{statement.readOperations().nodeGetPropertyKeys(1L)});
            IteratorUtil.asUniqueSet((Object[])new PrimitiveIntIterator[]{statement.readOperations().nodeGetPropertyKeys(2L)});
            IteratorUtil.asUniqueSet((Object[])new PrimitiveIntIterator[]{statement.readOperations().relationshipGetPropertyKeys(0L)});
            IteratorUtil.asUniqueSet((Object[])new PrimitiveIntIterator[]{statement.readOperations().relationshipGetPropertyKeys(1L)});
        }
        database.shutdown();
    }

    private void verifyPropertiesEqual(PropertyContainer entity, Pair<String, String> ... expectedProperties) {
        Map properties = entity.getAllProperties();
        Assert.assertThat((Object)properties, (Matcher)Matchers.is((Object)IteratorUtil.asMap(Arrays.asList(expectedProperties))));
    }
}

