/*
 * Decompiled with CFR 0.152.
 */
package upgrade;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.api.index.SchemaIndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.ha.HighlyAvailableGraphDatabase;
import org.neo4j.kernel.impl.api.index.inmemory.InMemoryIndexProvider;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyKeyTokenStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.PageCacheRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.tooling.GlobalGraphOperations;
import upgrade.DatabaseContentVerifier;
import upgrade.ListAccumulatorMigrationProgressMonitor;
import upgrade.StoreMigratorTestUtil;

public class StoreMigratorFrom19IT {
    @Rule
    public final TargetDirectory.TestDirectory storeDir = TargetDirectory.testDirForTest(this.getClass());
    @Rule
    public final PageCacheRule pageCacheRule = new PageCacheRule();
    private final Config config = MigrationTestUtils.defaultConfig();
    private final SchemaIndexProvider schemaIndexProvider = new InMemoryIndexProvider();
    private final FileSystemAbstraction fs = new DefaultFileSystemAbstraction();
    private final ListAccumulatorMigrationProgressMonitor monitor = new ListAccumulatorMigrationProgressMonitor();
    private PageCache pageCache;
    private StoreFactory storeFactory;
    private UpgradableDatabase upgradableDatabase;
    private final LifeSupport life = new LifeSupport();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldMigrate() throws IOException, ConsistencyCheckIncompleteException {
        File legacyStoreDir = MigrationTestUtils.find19FormatHugeStoreDirectory((File)this.storeDir.directory());
        this.newStoreUpgrader().migrateIfNeeded(legacyStoreDir, this.upgradableDatabase, this.schemaIndexProvider);
        Assert.assertEquals((long)100L, (long)this.monitor.eventSize());
        Assert.assertTrue((boolean)this.monitor.isStarted());
        Assert.assertTrue((boolean)this.monitor.isFinished());
        GraphDatabaseService database = new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir.absolutePath());
        try {
            StoreMigratorFrom19IT.verifyDatabaseContents(database);
        }
        finally {
            database.shutdown();
        }
        try (NeoStores neoStores = this.storeFactory.openNeoStores(1);){
            StoreMigratorFrom19IT.verifyNeoStore(neoStores);
        }
        StoreAssertions.assertConsistentStore((File)this.storeDir.directory());
    }

    @Test
    public void shouldMigrateCluster() throws Throwable {
        File legacyStoreDir = MigrationTestUtils.find19FormatHugeStoreDirectory((File)this.storeDir.directory());
        this.newStoreUpgrader().migrateIfNeeded(legacyStoreDir, this.upgradableDatabase, this.schemaIndexProvider);
        ClusterManager.ManagedCluster cluster = StoreMigratorTestUtil.buildClusterWithMasterDirIn(this.fs, legacyStoreDir, this.life);
        cluster.await(ClusterManager.allSeesAllAsAvailable());
        cluster.sync(new HighlyAvailableGraphDatabase[0]);
        HighlyAvailableGraphDatabase slave1 = cluster.getAnySlave(new HighlyAvailableGraphDatabase[0]);
        StoreMigratorFrom19IT.verifySlaveContents((GraphDatabaseService)slave1);
        StoreMigratorFrom19IT.verifySlaveContents((GraphDatabaseService)cluster.getAnySlave(new HighlyAvailableGraphDatabase[]{slave1}));
        StoreMigratorFrom19IT.verifyDatabaseContents((GraphDatabaseService)cluster.getMaster());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDeduplicateUniquePropertyIndexKeys() throws Exception {
        File legacyStoreDir = MigrationTestUtils.find19FormatStoreDirectory((File)this.storeDir.directory());
        this.newStoreUpgrader().migrateIfNeeded(this.storeDir.directory(), this.upgradableDatabase, this.schemaIndexProvider);
        GraphDatabaseService db = new GraphDatabaseFactory().newEmbeddedDatabase(this.storeDir.absolutePath());
        try {
            Node nodeA = this.getNodeWithName(db, "A");
            Assert.assertThat((Object)nodeA, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)"A")));
            Node nodeB = this.getNodeWithName(db, "B");
            Assert.assertThat((Object)nodeB, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)"B")));
            Node nodeC = this.getNodeWithName(db, "C");
            Assert.assertThat((Object)nodeC, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"name").withValue((Object)"C")));
            Assert.assertThat((Object)nodeC, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"other").withValue((Object)"a value")));
            Assert.assertThat((Object)nodeC, (Matcher)Neo4jMatchers.inTx((GraphDatabaseService)db, (Matcher)Neo4jMatchers.hasProperty((String)"third").withValue((Object)"something")));
        }
        finally {
            db.shutdown();
        }
        try (NeoStores neoStores = this.storeFactory.openNeoStoresEagerly();){
            PropertyKeyTokenStore tokenStore = neoStores.getPropertyKeyTokenStore();
            List tokens = tokenStore.getTokens(Integer.MAX_VALUE);
            this.assertNoDuplicates(tokens);
        }
        StoreAssertions.assertConsistentStore((File)this.storeDir.directory());
    }

    private static void verifyDatabaseContents(GraphDatabaseService db) {
        DatabaseContentVerifier verifier = new DatabaseContentVerifier(db, 1);
        StoreMigratorFrom19IT.verifyNumberOfNodesAndRelationships(verifier);
        verifier.verifyNodeIdsReused();
        verifier.verifyRelationshipIdsReused();
        verifier.verifyLegacyIndex();
    }

    private static void verifySlaveContents(GraphDatabaseService haDb) {
        DatabaseContentVerifier verifier = new DatabaseContentVerifier(haDb, 1);
        StoreMigratorFrom19IT.verifyNumberOfNodesAndRelationships(verifier);
        verifier.verifyLegacyIndex();
    }

    private static void verifyNumberOfNodesAndRelationships(DatabaseContentVerifier verifier) {
        verifier.verifyNodes(1000);
        verifier.verifyRelationships(500);
    }

    private static void verifyNeoStore(NeoStores neoStores) {
        MetaDataStore metaDataStore = neoStores.getMetaDataStore();
        Assert.assertEquals((long)1409818980890L, (long)metaDataStore.getCreationTime());
        Assert.assertEquals((long)7528833218632030901L, (long)metaDataStore.getRandomNumber());
        Assert.assertEquals((long)1L, (long)metaDataStore.getCurrentLogVersion());
        Assert.assertEquals((Object)"v0.A.6", (Object)MetaDataStore.versionLongToString((long)metaDataStore.getStoreVersion()));
        Assert.assertEquals((long)11L, (long)metaDataStore.getLastCommittedTransactionId());
    }

    private void assertNoDuplicates(List<Token> tokens) {
        HashSet<String> visited = new HashSet<String>();
        for (Token token : tokens) {
            Assert.assertTrue((boolean)visited.add(token.name()));
        }
    }

    private Node getNodeWithName(GraphDatabaseService db, String name) {
        try (Transaction tx = db.beginTx();){
            for (Node node : GlobalGraphOperations.at((GraphDatabaseService)db).getAllNodes()) {
                if (!name.equals(node.getProperty("name", null))) continue;
                tx.success();
                Node node2 = node;
                return node2;
            }
        }
        throw new IllegalArgumentException(name + " not found");
    }

    private StoreUpgrader newStoreUpgrader() {
        StoreUpgrader upgrader = new StoreUpgrader(UpgradeConfiguration.ALLOW_UPGRADE, this.fs, StoreUpgrader.NO_MONITOR, (LogProvider)NullLogProvider.getInstance());
        upgrader.addParticipant((StoreMigrationParticipant)new StoreMigrator((MigrationProgressMonitor)this.monitor, this.fs, this.pageCache, this.config, (LogService)NullLogService.getInstance()));
        return upgrader;
    }

    @Before
    public void setUp() {
        this.pageCache = this.pageCacheRule.getPageCache(this.fs);
        this.storeFactory = new StoreFactory(this.storeDir.directory(), this.config, (IdGeneratorFactory)new DefaultIdGeneratorFactory(this.fs), this.pageCache, this.fs, (LogProvider)NullLogProvider.getInstance());
        this.upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.pageCache), new LegacyStoreVersionCheck(this.fs));
    }

    @After
    public void tearDown() {
        this.life.shutdown();
    }
}

