/*
 * Decompiled with CFR 0.152.
 */
package upgrade;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.ha.ClusterManager;
import org.neo4j.kernel.lifecycle.LifeSupport;

public class StoreMigratorTestUtil {
    StoreMigratorTestUtil() {
    }

    public static ClusterManager.ManagedCluster buildClusterWithMasterDirIn(FileSystemAbstraction fs, final File legacyStoreDir, LifeSupport life) throws Throwable {
        File haRootDir = new File(legacyStoreDir.getParentFile(), "ha-migration");
        fs.deleteRecursively(haRootDir);
        ClusterManager clusterManager = new ClusterManager.Builder(haRootDir).withStoreDirInitializer(new ClusterManager.StoreDirInitializer(){

            public void initializeStoreDir(int serverId, File storeDir) throws IOException {
                if (serverId == 1) {
                    FileUtils.copyRecursively((File)legacyStoreDir, (File)storeDir);
                }
            }
        }).withProvider(ClusterManager.clusterOfSize((int)3)).build();
        life.add((Object)clusterManager);
        life.start();
        return clusterManager.getDefaultCluster();
    }

    public static File[] findAllMatchingFiles(File baseDir, String regex) {
        final Pattern pattern = Pattern.compile(regex);
        Object[] files = baseDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return pattern.matcher(name).matches();
            }
        });
        Arrays.sort(files);
        return files;
    }
}

