/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.storageengine.api.lock.ResourceType;

public class LockUnit
implements Comparable<LockUnit>,
ActiveLock {
    private final ResourceType resourceType;
    private final long resourceId;
    private final boolean exclusive;

    public LockUnit(ResourceType resourceType, long resourceId, boolean exclusive) {
        this.resourceType = resourceType;
        this.resourceId = resourceId;
        this.exclusive = exclusive;
    }

    public String mode() {
        return this.exclusive ? "EXCLUSIVE" : "SHARED";
    }

    public ResourceType resourceType() {
        return this.resourceType;
    }

    public long resourceId() {
        return this.resourceId;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exclusive ? 1231 : 1237);
        result = 31 * result + (int)(this.resourceId ^ this.resourceId >>> 32);
        result = 31 * result + this.resourceType.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LockUnit other = (LockUnit)obj;
        if (this.exclusive != other.exclusive) {
            return false;
        }
        if (this.resourceId != other.resourceId) {
            return false;
        }
        return this.resourceType.typeId() == other.resourceType.typeId();
    }

    @Override
    public int compareTo(LockUnit o) {
        int exclusiveCompare = Boolean.compare(this.exclusive, o.exclusive);
        if (exclusiveCompare != 0) {
            return -exclusiveCompare;
        }
        return this.resourceType.typeId() == o.resourceType.typeId() ? Long.compare(this.resourceId, o.resourceId) : this.resourceType.typeId() - o.resourceType.typeId();
    }

    public String toString() {
        return "Resource [resourceType=" + this.resourceType + ", resourceId=" + this.resourceId + ", exclusive=" + this.exclusive + "]";
    }
}

