/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Objects;
import java.util.function.Function;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.Internal;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.Settings;
import org.neo4j.kernel.impl.locking.DeferringStatementLocks;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocksFactory;

public class DeferringStatementLocksFactory
implements StatementLocksFactory,
LoadableConfig {
    @Internal
    @Description(value="Enable deferring of locks to commit time. This feature weakens the isolation level. It can result in both domain and storage level inconsistencies.")
    public static final Setting<Boolean> deferred_locks_enabled = Settings.setting((String)"unsupported.dbms.deferred_locks.enabled", (Function)Settings.BOOLEAN, (String)"false");
    private Locks locks;
    private boolean deferredLocksEnabled;

    public void initialize(Locks locks, Config config) {
        this.locks = Objects.requireNonNull(locks);
        this.deferredLocksEnabled = (Boolean)config.get(deferred_locks_enabled);
    }

    public StatementLocks newInstance() {
        if (this.locks == null) {
            throw new IllegalStateException("Factory has not been initialized");
        }
        Locks.Client client = this.locks.newClient();
        return this.deferredLocksEnabled ? new DeferringStatementLocks(client) : new SimpleStatementLocks(client);
    }
}

