/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.stream.Stream;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.DeferringLockClient;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.StatementLocks;

public class DeferringStatementLocks
implements StatementLocks {
    private final Locks.Client explicit;
    private final DeferringLockClient implicit;

    public DeferringStatementLocks(Locks.Client explicit) {
        this.explicit = explicit;
        this.implicit = new DeferringLockClient(this.explicit);
    }

    public Locks.Client pessimistic() {
        return this.explicit;
    }

    public Locks.Client optimistic() {
        return this.implicit;
    }

    public void prepareForCommit(LockTracer lockTracer) {
        this.implicit.acquireDeferredLocks(lockTracer);
        this.explicit.prepare();
    }

    public void stop() {
        this.implicit.stop();
    }

    public void close() {
        this.implicit.close();
    }

    public Stream<? extends ActiveLock> activeLocks() {
        return Stream.concat(this.explicit.activeLocks(), this.implicit.activeLocks());
    }

    public long activeLockCount() {
        return this.explicit.activeLockCount() + this.implicit.activeLockCount();
    }
}

