/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockUnit;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;

public class DeferringLockClient
implements Locks.Client {
    private final Locks.Client clientDelegate;
    private final Map<LockUnit, MutableInt> locks = new TreeMap<LockUnit, MutableInt>();
    private volatile boolean stopped;

    public DeferringLockClient(Locks.Client clientDelegate) {
        this.clientDelegate = clientDelegate;
    }

    public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        this.assertNotStopped();
        for (long resourceId : resourceIds) {
            this.addLock(resourceType, resourceId, false);
        }
    }

    public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
        this.assertNotStopped();
        for (long resourceId : resourceIds) {
            this.addLock(resourceType, resourceId, true);
        }
    }

    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        throw new UnsupportedOperationException("Should not be needed");
    }

    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        throw new UnsupportedOperationException("Should not be needed");
    }

    public boolean reEnterShared(ResourceType resourceType, long resourceId) {
        throw new UnsupportedOperationException("Should not be needed");
    }

    public boolean reEnterExclusive(ResourceType resourceType, long resourceId) {
        throw new UnsupportedOperationException("Should not be needed");
    }

    public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        this.assertNotStopped();
        for (long resourceId : resourceIds) {
            this.removeLock(resourceType, resourceId, false);
        }
    }

    public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        this.assertNotStopped();
        for (long resourceId : resourceIds) {
            this.removeLock(resourceType, resourceId, true);
        }
    }

    void acquireDeferredLocks(LockTracer lockTracer) {
        this.assertNotStopped();
        long[] current = new long[10];
        int cursor = 0;
        ResourceType currentType = null;
        boolean currentExclusive = false;
        for (LockUnit lockUnit : this.locks.keySet()) {
            if (currentType == null || currentType.typeId() != lockUnit.resourceType().typeId() || currentExclusive != lockUnit.isExclusive()) {
                this.flushLocks(lockTracer, current, cursor, currentType, currentExclusive);
                cursor = 0;
                currentType = lockUnit.resourceType();
                currentExclusive = lockUnit.isExclusive();
            }
            if (cursor == current.length) {
                current = Arrays.copyOf(current, cursor * 2);
            }
            current[cursor++] = lockUnit.resourceId();
        }
        this.flushLocks(lockTracer, current, cursor, currentType, currentExclusive);
    }

    private void flushLocks(LockTracer lockTracer, long[] current, int cursor, ResourceType currentType, boolean exclusive) {
        if (cursor > 0) {
            long[] resourceIds = Arrays.copyOf(current, cursor);
            if (exclusive) {
                this.clientDelegate.acquireExclusive(lockTracer, currentType, resourceIds);
            } else {
                this.clientDelegate.acquireShared(lockTracer, currentType, resourceIds);
            }
        }
    }

    public void prepare() {
        this.clientDelegate.prepare();
    }

    public void stop() {
        this.stopped = true;
        this.clientDelegate.stop();
    }

    public void close() {
        this.stopped = true;
        this.clientDelegate.close();
    }

    public int getLockSessionId() {
        return this.clientDelegate.getLockSessionId();
    }

    public Stream<? extends ActiveLock> activeLocks() {
        return this.locks.keySet().stream();
    }

    public long activeLockCount() {
        return this.locks.size();
    }

    private void assertNotStopped() {
        if (this.stopped) {
            throw new LockClientStoppedException((Locks.Client)this);
        }
    }

    private void addLock(ResourceType resourceType, long resourceId, boolean exclusive) {
        LockUnit lockUnit = new LockUnit(resourceType, resourceId, exclusive);
        MutableInt lockCount = this.locks.computeIfAbsent(lockUnit, k -> new MutableInt());
        lockCount.increment();
    }

    private void removeLock(ResourceType resourceType, long resourceId, boolean exclusive) {
        LockUnit lockUnit = new LockUnit(resourceType, resourceId, exclusive);
        MutableInt lockCount = this.locks.get(lockUnit);
        if (lockCount == null) {
            throw new IllegalStateException("Cannot release " + (exclusive ? "exclusive" : "shared") + " lock that it does not hold: " + resourceType + "[" + resourceId + "].");
        }
        lockCount.decrement();
        if (lockCount.intValue() == 0) {
            this.locks.remove(lockUnit);
        }
    }
}

