/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.locking.LockUnit;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;

public class LockUnitTest {
    @Test
    public void exclusiveLocksAppearFirst() {
        LockUnit unit1 = new LockUnit((ResourceType)ResourceTypes.NODE, 1L, true);
        LockUnit unit2 = new LockUnit((ResourceType)ResourceTypes.NODE, 2L, false);
        LockUnit unit3 = new LockUnit((ResourceType)ResourceTypes.RELATIONSHIP, 1L, false);
        LockUnit unit4 = new LockUnit((ResourceType)ResourceTypes.RELATIONSHIP, 2L, true);
        LockUnit unit5 = new LockUnit((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, 1L, false);
        List<LockUnit> list = Arrays.asList(unit1, unit2, unit3, unit4, unit5);
        Collections.sort(list);
        Assert.assertEquals(Arrays.asList(unit1, unit4, unit2, unit3, unit5), list);
    }

    @Test
    public void exclusiveOrderedByResourceTypes() {
        LockUnit unit1 = new LockUnit((ResourceType)ResourceTypes.NODE, 1L, true);
        LockUnit unit2 = new LockUnit((ResourceType)ResourceTypes.RELATIONSHIP, 1L, true);
        LockUnit unit3 = new LockUnit((ResourceType)ResourceTypes.NODE, 2L, true);
        LockUnit unit4 = new LockUnit((ResourceType)ResourceTypes.RELATIONSHIP_TYPE, 1L, true);
        LockUnit unit5 = new LockUnit((ResourceType)ResourceTypes.RELATIONSHIP, 2L, true);
        List<LockUnit> list = Arrays.asList(unit1, unit2, unit3, unit4, unit5);
        Collections.sort(list);
        Assert.assertEquals(Arrays.asList(unit1, unit3, unit2, unit5, unit4), list);
    }
}

