/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.locking.DeferringLockClient;
import org.neo4j.kernel.impl.locking.DeferringStatementLocks;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.storageengine.api.lock.ResourceType;

public class DeferringStatementLocksTest {
    @Test
    public void shouldUseCorrectClientForImplicitAndExplicit() {
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringStatementLocks statementLocks = new DeferringStatementLocks(client);
        Assert.assertSame((Object)client, (Object)statementLocks.pessimistic());
        Assert.assertThat((Object)statementLocks.optimistic(), (Matcher)Matchers.instanceOf(DeferringLockClient.class));
    }

    @Test
    public void shouldDoNothingWithClientWhenPreparingForCommitWithNoLocksAcquired() {
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringStatementLocks statementLocks = new DeferringStatementLocks(client);
        statementLocks.prepareForCommit(LockTracer.NONE);
        ((Locks.Client)Mockito.verify((Object)client)).prepare();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{client});
    }

    @Test
    public void shouldPrepareExplicitForCommitWhenLocksAcquire() {
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringStatementLocks statementLocks = new DeferringStatementLocks(client);
        statementLocks.optimistic().acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        statementLocks.optimistic().acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{42L});
        ((Locks.Client)Mockito.verify((Object)client, (VerificationMode)Mockito.never())).acquireExclusive((LockTracer)ArgumentMatchers.eq((Object)LockTracer.NONE), (ResourceType)ArgumentMatchers.any(ResourceType.class), new long[]{ArgumentMatchers.anyLong()});
        statementLocks.prepareForCommit(LockTracer.NONE);
        ((Locks.Client)Mockito.verify((Object)client)).prepare();
        ((Locks.Client)Mockito.verify((Object)client)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        ((Locks.Client)Mockito.verify((Object)client)).acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{42L});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{client});
    }

    @Test
    public void shouldStopUnderlyingClient() {
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringStatementLocks statementLocks = new DeferringStatementLocks(client);
        statementLocks.stop();
        ((Locks.Client)Mockito.verify((Object)client)).stop();
    }

    @Test
    public void shouldCloseUnderlyingClient() {
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringStatementLocks statementLocks = new DeferringStatementLocks(client);
        statementLocks.close();
        ((Locks.Client)Mockito.verify((Object)client)).close();
    }
}

