/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.locking.DeferringLockClient;
import org.neo4j.kernel.impl.locking.DeferringStatementLocks;
import org.neo4j.kernel.impl.locking.DeferringStatementLocksFactory;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;

public class DeferringStatementLocksFactoryTest {
    @Test
    public void initializeThrowsForNullLocks() {
        DeferringStatementLocksFactory factory = new DeferringStatementLocksFactory();
        try {
            factory.initialize(null, Config.defaults());
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NullPointerException.class));
        }
    }

    @Test
    public void initializeThrowsForNullConfig() {
        DeferringStatementLocksFactory factory = new DeferringStatementLocksFactory();
        try {
            factory.initialize((Locks)Mockito.mock(Locks.class), null);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(NullPointerException.class));
        }
    }

    @Test
    public void newInstanceThrowsWhenNotInitialized() {
        DeferringStatementLocksFactory factory = new DeferringStatementLocksFactory();
        try {
            factory.newInstance();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void newInstanceCreatesSimpleLocksWhenConfigNotSet() {
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)client);
        Config config = Config.defaults((Setting)DeferringStatementLocksFactory.deferred_locks_enabled, (String)"false");
        DeferringStatementLocksFactory factory = new DeferringStatementLocksFactory();
        factory.initialize(locks, config);
        StatementLocks statementLocks = factory.newInstance();
        Assert.assertThat((Object)statementLocks, (Matcher)Matchers.instanceOf(SimpleStatementLocks.class));
        Assert.assertSame((Object)client, (Object)statementLocks.optimistic());
        Assert.assertSame((Object)client, (Object)statementLocks.pessimistic());
    }

    @Test
    public void newInstanceCreatesDeferredLocksWhenConfigSet() {
        Locks locks = (Locks)Mockito.mock(Locks.class);
        Locks.Client client = (Locks.Client)Mockito.mock(Locks.Client.class);
        Mockito.when((Object)locks.newClient()).thenReturn((Object)client);
        Config config = Config.defaults((Setting)DeferringStatementLocksFactory.deferred_locks_enabled, (String)"true");
        DeferringStatementLocksFactory factory = new DeferringStatementLocksFactory();
        factory.initialize(locks, config);
        StatementLocks statementLocks = factory.newInstance();
        Assert.assertThat((Object)statementLocks, (Matcher)Matchers.instanceOf(DeferringStatementLocks.class));
        Assert.assertThat((Object)statementLocks.optimistic(), (Matcher)Matchers.instanceOf(DeferringLockClient.class));
        Assert.assertSame((Object)client, (Object)statementLocks.pessimistic());
    }
}

