/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.locking.DeferringStatementLocksFactory;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.test.Barrier;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.rule.DatabaseRule;
import org.neo4j.test.rule.EnterpriseDatabaseRule;
import org.neo4j.test.rule.concurrent.OtherThreadRule;

public class DeferringLocksIT {
    private static final long TEST_TIMEOUT = 30000L;
    private static final Label LABEL = Label.label((String)"label");
    private static final String PROPERTY_KEY = "key";
    private static final String VALUE_1 = "value1";
    private static final String VALUE_2 = "value2";
    @Rule
    public final DatabaseRule dbRule = new EnterpriseDatabaseRule().startLazily();
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule();
    @Rule
    public final OtherThreadRule<Void> t3 = new OtherThreadRule();
    private GraphDatabaseService db;

    @Before
    public void initDb() {
        this.dbRule.setConfig(DeferringStatementLocksFactory.deferred_locks_enabled, "true");
        this.db = this.dbRule.getGraphDatabaseAPI();
    }

    @Test(timeout=30000L)
    public void shouldNotFreakOutIfTwoTransactionsDecideToEachAddTheSameProperty() throws Exception {
        Node node;
        Barrier.Control barrier = new Barrier.Control();
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            tx.success();
        }
        this.t2.execute(state -> {
            try (Transaction tx = this.db.beginTx();){
                node.setProperty(PROPERTY_KEY, (Object)VALUE_1);
                tx.success();
                barrier.reached();
            }
            return null;
        });
        tx = this.db.beginTx();
        var4_3 = null;
        try {
            barrier.await();
            node.setProperty(PROPERTY_KEY, (Object)VALUE_2);
            tx.success();
            barrier.release();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        tx = this.db.beginTx();
        var4_3 = null;
        try {
            Assert.assertEquals((long)1L, (long)Iterables.count((Iterable)node.getPropertyKeys()));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_3 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_3.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test(timeout=30000L)
    public void firstRemoveSecondChangeProperty() throws Exception {
        Node node;
        Barrier.Control barrier = new Barrier.Control();
        try (Transaction tx = this.db.beginTx();){
            node = this.db.createNode();
            node.setProperty(PROPERTY_KEY, (Object)VALUE_1);
            tx.success();
        }
        Future future = this.t2.execute(state -> {
            try (Transaction tx = this.db.beginTx();){
                node.removeProperty(PROPERTY_KEY);
                tx.success();
                barrier.reached();
            }
            return null;
        });
        try (Transaction tx = this.db.beginTx();){
            barrier.await();
            node.setProperty(PROPERTY_KEY, (Object)VALUE_2);
            tx.success();
            barrier.release();
        }
        future.get();
        tx = this.db.beginTx();
        var5_7 = null;
        try {
            Assert.assertEquals((Object)VALUE_2, (Object)node.getProperty(PROPERTY_KEY, (Object)VALUE_2));
            tx.success();
        }
        catch (Throwable throwable) {
            var5_7 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var5_7 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var5_7.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test(timeout=30000L)
    public void removeNodeChangeNodeProperty() throws Exception {
        Throwable throwable;
        Transaction tx;
        long nodeId;
        Barrier.Control barrier = new Barrier.Control();
        try (Transaction tx2 = this.db.beginTx();){
            Node node = this.db.createNode();
            nodeId = node.getId();
            node.setProperty(PROPERTY_KEY, (Object)VALUE_1);
            tx2.success();
        }
        Future future = this.t2.execute(state -> {
            try (Transaction tx = this.db.beginTx();){
                this.db.getNodeById(nodeId).delete();
                tx.success();
                barrier.reached();
            }
            return null;
        });
        try {
            tx = this.db.beginTx();
            throwable = null;
            try {
                barrier.await();
                this.db.getNodeById(nodeId).setProperty(PROPERTY_KEY, (Object)VALUE_2);
                tx.success();
                barrier.release();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (TransactionFailureException e) {
            Assert.assertThat((Object)e.getCause(), (Matcher)Matchers.instanceOf(InvalidRecordException.class));
        }
        future.get();
        tx = this.db.beginTx();
        throwable = null;
        try {
            try {
                this.db.getNodeById(nodeId);
                Assert.assertEquals((Object)VALUE_2, (Object)this.db.getNodeById(nodeId).getProperty(PROPERTY_KEY, (Object)VALUE_2));
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            tx.success();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    @Test(timeout=30000L)
    public void readOwnChangesFromRacingIndexNoBlock() throws Throwable {
        Future t2Future = this.t2.execute(state -> {
            try (Transaction tx = this.db.beginTx();){
                this.createNodeWithProperty(LABEL, PROPERTY_KEY, VALUE_1);
                this.assertNodeWith(LABEL, PROPERTY_KEY, VALUE_1);
                tx.success();
            }
            return null;
        });
        Future t3Future = this.t3.execute(state -> {
            try (Transaction tx = this.db.beginTx();){
                this.createAndAwaitIndex(LABEL, PROPERTY_KEY);
                tx.success();
            }
            return null;
        });
        t3Future.get();
        t2Future.get();
        this.assertInTxNodeWith(LABEL, PROPERTY_KEY, VALUE_1);
    }

    @Test(timeout=30000L)
    public void readOwnChangesWithoutIndex() {
        try (Transaction tx = this.db.beginTx();){
            Node node = this.db.createNode(new Label[]{LABEL});
            node.setProperty(PROPERTY_KEY, (Object)VALUE_1);
            this.assertNodeWith(LABEL, PROPERTY_KEY, VALUE_1);
            tx.success();
        }
        this.assertInTxNodeWith(LABEL, PROPERTY_KEY, VALUE_1);
    }

    private void assertInTxNodeWith(Label label, String key, Object value) {
        try (Transaction tx = this.db.beginTx();){
            this.assertNodeWith(label, key, value);
            tx.success();
        }
    }

    private void assertNodeWith(Label label, String key, Object value) {
        try (ResourceIterator nodes = this.db.findNodes(label, key, value);){
            Assert.assertTrue((boolean)nodes.hasNext());
            Node foundNode = (Node)nodes.next();
            Assert.assertTrue((boolean)foundNode.hasLabel(label));
            Assert.assertEquals((Object)value, (Object)foundNode.getProperty(key));
        }
    }

    private Node createNodeWithProperty(Label label, String key, Object value) {
        Node node = this.db.createNode(new Label[]{label});
        node.setProperty(key, value);
        return node;
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> createAndAwaitIndex(Label label, String key) {
        return state -> {
            try (Transaction tx = this.db.beginTx();){
                this.db.schema().indexFor(label).on(key).create();
                tx.success();
            }
            var5_5 = null;
            try (Transaction ignore = this.db.beginTx();){
                this.db.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            return null;
        };
    }
}

