/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.kernel.impl.locking.DeferringLockClient;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockUnit;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.storageengine.api.lock.AcquireLockTimeoutException;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.test.rule.RandomRule;

public class DeferringLockClientTest {
    @Rule
    public final RandomRule random = new RandomRule();

    @Test
    public void releaseOfNotHeldSharedLockThrows() {
        TestLocks actualLocks = new TestLocks();
        TestLocksClient actualClient = actualLocks.newClient();
        DeferringLockClient client = new DeferringLockClient((Locks.Client)actualClient);
        try {
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{42L});
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void releaseOfNotHeldExclusiveLockThrows() {
        TestLocks actualLocks = new TestLocks();
        TestLocksClient actualClient = actualLocks.newClient();
        DeferringLockClient client = new DeferringLockClient((Locks.Client)actualClient);
        try {
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{42L});
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void shouldDeferAllLocks() {
        TestLocks actualLocks = new TestLocks();
        TestLocksClient actualClient = actualLocks.newClient();
        DeferringLockClient client = new DeferringLockClient((Locks.Client)actualClient);
        HashSet<LockUnit> expected = new HashSet<LockUnit>();
        Object[] types = ResourceTypes.values();
        for (int i = 0; i < 10000; ++i) {
            boolean exclusive = this.random.nextBoolean();
            LockUnit lockUnit = new LockUnit((ResourceType)this.random.among(types), Math.abs(this.random.nextLong()), exclusive);
            if (exclusive) {
                client.acquireExclusive(LockTracer.NONE, lockUnit.resourceType(), new long[]{lockUnit.resourceId()});
            } else {
                client.acquireShared(LockTracer.NONE, lockUnit.resourceType(), new long[]{lockUnit.resourceId()});
            }
            expected.add(lockUnit);
        }
        actualClient.assertRegisteredLocks(Collections.emptySet());
        client.acquireDeferredLocks(LockTracer.NONE);
        actualClient.assertRegisteredLocks(expected);
    }

    @Test
    public void shouldStopUnderlyingClient() {
        Locks.Client actualClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringLockClient client = new DeferringLockClient(actualClient);
        client.stop();
        ((Locks.Client)Mockito.verify((Object)actualClient)).stop();
    }

    @Test
    public void shouldPrepareUnderlyingClient() {
        Locks.Client actualClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringLockClient client = new DeferringLockClient(actualClient);
        client.prepare();
        ((Locks.Client)Mockito.verify((Object)actualClient)).prepare();
    }

    @Test
    public void shouldCloseUnderlyingClient() {
        Locks.Client actualClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringLockClient client = new DeferringLockClient(actualClient);
        client.close();
        ((Locks.Client)Mockito.verify((Object)actualClient)).close();
    }

    @Test
    public void shouldThrowOnAcquireWhenStopped() {
        Locks.Client actualClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringLockClient client = new DeferringLockClient(actualClient);
        client.stop();
        try {
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            Assert.fail((String)"Expected exception");
        }
        catch (LockClientStoppedException lockClientStoppedException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowOnAcquireWhenClosed() {
        Locks.Client actualClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringLockClient client = new DeferringLockClient(actualClient);
        client.close();
        try {
            client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
            Assert.fail((String)"Expected exception");
        }
        catch (LockClientStoppedException lockClientStoppedException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowWhenReleaseNotYetAcquiredExclusive() {
        Locks.Client actualClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringLockClient client = new DeferringLockClient(actualClient);
        try {
            client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowWhenReleaseNotYetAcquiredShared() {
        Locks.Client actualClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringLockClient client = new DeferringLockClient(actualClient);
        try {
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowWhenReleaseNotMatchingAcquired() {
        Locks.Client actualClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringLockClient client = new DeferringLockClient(actualClient);
        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        try {
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void shouldThrowWhenReleasingLockMultipleTimes() {
        Locks.Client actualClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        DeferringLockClient client = new DeferringLockClient(actualClient);
        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        try {
            client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void exclusiveLockAcquiredMultipleTimesCanNotBeReleasedAtOnce() {
        TestLocks actualLocks = new TestLocks();
        TestLocksClient actualClient = actualLocks.newClient();
        DeferringLockClient client = new DeferringLockClient((Locks.Client)actualClient);
        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.acquireDeferredLocks(LockTracer.NONE);
        actualClient.assertRegisteredLocks(Collections.singleton(new LockUnit((ResourceType)ResourceTypes.NODE, 1L, true)));
    }

    @Test
    public void sharedLockAcquiredMultipleTimesCanNotBeReleasedAtOnce() {
        TestLocks actualLocks = new TestLocks();
        TestLocksClient actualClient = actualLocks.newClient();
        DeferringLockClient client = new DeferringLockClient((Locks.Client)actualClient);
        client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.acquireDeferredLocks(LockTracer.NONE);
        actualClient.assertRegisteredLocks(Collections.singleton(new LockUnit((ResourceType)ResourceTypes.NODE, 1L, false)));
    }

    @Test
    public void acquireBothSharedAndExclusiveLockThenReleaseShared() {
        TestLocks actualLocks = new TestLocks();
        TestLocksClient actualClient = actualLocks.newClient();
        DeferringLockClient client = new DeferringLockClient((Locks.Client)actualClient);
        client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.releaseShared((ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.acquireDeferredLocks(LockTracer.NONE);
        actualClient.assertRegisteredLocks(Collections.singleton(new LockUnit((ResourceType)ResourceTypes.NODE, 1L, true)));
    }

    @Test
    public void exclusiveLocksAcquiredFirst() {
        TestLocks actualLocks = new TestLocks();
        TestLocksClient actualClient = actualLocks.newClient();
        DeferringLockClient client = new DeferringLockClient((Locks.Client)actualClient);
        client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{2L});
        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{3L});
        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{1L});
        client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.RELATIONSHIP, new long[]{2L});
        client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.LABEL, new long[]{1L});
        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{42L});
        client.acquireDeferredLocks(LockTracer.NONE);
        LinkedHashSet<LockUnit> expectedLocks = new LinkedHashSet<LockUnit>(Arrays.asList(new LockUnit((ResourceType)ResourceTypes.NODE, 2L, true), new LockUnit((ResourceType)ResourceTypes.NODE, 3L, true), new LockUnit((ResourceType)ResourceTypes.NODE, 42L, true), new LockUnit((ResourceType)ResourceTypes.RELATIONSHIP, 1L, true), new LockUnit((ResourceType)ResourceTypes.NODE, 1L, false), new LockUnit((ResourceType)ResourceTypes.RELATIONSHIP, 2L, false), new LockUnit((ResourceType)ResourceTypes.LABEL, 1L, false)));
        actualClient.assertRegisteredLocks(expectedLocks);
    }

    @Test
    public void acquireBothSharedAndExclusiveLockThenReleaseExclusive() {
        TestLocks actualLocks = new TestLocks();
        TestLocksClient actualClient = actualLocks.newClient();
        DeferringLockClient client = new DeferringLockClient((Locks.Client)actualClient);
        client.acquireShared(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.acquireExclusive(LockTracer.NONE, (ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.releaseExclusive((ResourceType)ResourceTypes.NODE, new long[]{1L});
        client.acquireDeferredLocks(LockTracer.NONE);
        actualClient.assertRegisteredLocks(Collections.singleton(new LockUnit((ResourceType)ResourceTypes.NODE, 1L, false)));
    }

    private static class TestLocksClient
    implements Locks.Client {
        private final Set<LockUnit> actualLockUnits = new LinkedHashSet<LockUnit>();

        private TestLocksClient() {
        }

        public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
            this.register(resourceType, false, resourceIds);
        }

        void assertRegisteredLocks(Set<LockUnit> expectedLocks) {
            Assert.assertEquals(expectedLocks, this.actualLockUnits);
        }

        private boolean register(ResourceType resourceType, boolean exclusive, long ... resourceIds) {
            for (long resourceId : resourceIds) {
                this.actualLockUnits.add(new LockUnit(resourceType, resourceId, exclusive));
            }
            return true;
        }

        public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) throws AcquireLockTimeoutException {
            this.register(resourceType, true, resourceIds);
        }

        public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
            return this.register(resourceType, true, resourceId);
        }

        public boolean trySharedLock(ResourceType resourceType, long resourceId) {
            return this.register(resourceType, false, resourceId);
        }

        public boolean reEnterShared(ResourceType resourceType, long resourceId) {
            throw new UnsupportedOperationException();
        }

        public boolean reEnterExclusive(ResourceType resourceType, long resourceId) {
            throw new UnsupportedOperationException();
        }

        public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        }

        public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        }

        public void prepare() {
        }

        public void stop() {
        }

        public void close() {
        }

        public int getLockSessionId() {
            return 0;
        }

        public Stream<? extends ActiveLock> activeLocks() {
            return this.actualLockUnits.stream();
        }

        public long activeLockCount() {
            return this.actualLockUnits.size();
        }
    }

    private static class TestLocks
    extends LifecycleAdapter
    implements Locks {
        private TestLocks() {
        }

        public TestLocksClient newClient() {
            return new TestLocksClient();
        }

        public void accept(Locks.Visitor visitor) {
        }

        public void close() {
        }
    }
}

