/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.dbms.archive.IncorrectFormat;
import org.neo4j.dbms.archive.Loader;
import org.neo4j.dbms.archive.TestUtils;
import org.neo4j.test.rule.TestDirectory;

public class LoaderTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void shouldGiveAClearErrorMessageIfTheArchiveDoesntExist() throws IOException, IncorrectFormat {
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        Path destination = this.testDirectory.file("the-destination").toPath();
        try {
            new Loader().load(archive, destination, destination);
            Assert.fail((String)"Expected an exception");
        }
        catch (NoSuchFileException e) {
            Assert.assertEquals((Object)archive.toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheArchiveIsNotInGzipFormat() throws IOException {
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        Files.write(archive, Arrays.asList("some incorrectly formatted data"), new OpenOption[0]);
        Path destination = this.testDirectory.file("the-destination").toPath();
        try {
            new Loader().load(archive, destination, destination);
            Assert.fail((String)"Expected an exception");
        }
        catch (IncorrectFormat e) {
            Assert.assertEquals((Object)archive.toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheArchiveIsNotInTarFormat() throws IOException {
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        try (GzipCompressorOutputStream compressor = new GzipCompressorOutputStream(Files.newOutputStream(archive, new OpenOption[0]));){
            byte[] bytes = new byte[1000];
            new Random().nextBytes(bytes);
            compressor.write(bytes);
        }
        Path destination = this.testDirectory.file("the-destination").toPath();
        try {
            new Loader().load(archive, destination, destination);
            Assert.fail((String)"Expected an exception");
        }
        catch (IncorrectFormat e) {
            Assert.assertEquals((Object)archive.toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorIfTheDestinationAlreadyExists() throws IOException, IncorrectFormat {
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        Path destination = this.testDirectory.directory("the-destination").toPath();
        try {
            new Loader().load(archive, destination, destination);
            Assert.fail((String)"Expected an exception");
        }
        catch (FileAlreadyExistsException e) {
            Assert.assertEquals((Object)destination.toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorIfTheDestinationTxLogAlreadyExists() throws IOException, IncorrectFormat {
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        Path destination = this.testDirectory.file("the-destination").toPath();
        Path txLogsDestination = this.testDirectory.directory("txLogsDestination").toPath();
        try {
            new Loader().load(archive, destination, txLogsDestination);
            Assert.fail((String)"Expected an exception");
        }
        catch (FileAlreadyExistsException e) {
            Assert.assertEquals((Object)txLogsDestination.toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheDestinationsParentDirectoryDoesntExist() throws IOException, IncorrectFormat {
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        Path destination = this.testDirectory.directory("subdir/the-destination").toPath();
        try {
            new Loader().load(archive, destination, destination);
            Assert.fail((String)"Expected an exception");
        }
        catch (NoSuchFileException e) {
            Assert.assertEquals((Object)destination.getParent().toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheTxLogsParentDirectoryDoesntExist() throws IOException, IncorrectFormat {
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        Path destination = this.testDirectory.file("destination").toPath();
        Path txLogsDestination = this.testDirectory.directory("subdir/txLogs").toPath();
        try {
            new Loader().load(archive, destination, txLogsDestination);
            Assert.fail((String)"Expected an exception");
        }
        catch (NoSuchFileException e) {
            Assert.assertEquals((Object)txLogsDestination.getParent().toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheDestinationsParentDirectoryIsAFile() throws IOException, IncorrectFormat {
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        Path destination = this.testDirectory.directory("subdir/the-destination").toPath();
        Files.write(destination.getParent(), new byte[0], new OpenOption[0]);
        try {
            new Loader().load(archive, destination, destination);
            Assert.fail((String)"Expected an exception");
        }
        catch (FileSystemException e) {
            Assert.assertEquals((Object)(destination.getParent().toString() + ": Not a directory"), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheDestinationsParentDirectoryIsNotWritable() throws IOException, IncorrectFormat {
        Assume.assumeFalse((String)"We haven't found a way to reliably tests permissions on Windows", (boolean)SystemUtils.IS_OS_WINDOWS);
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        Path destination = this.testDirectory.directory("subdir/the-destination").toPath();
        Files.createDirectories(destination.getParent(), new FileAttribute[0]);
        try (Closeable ignored = TestUtils.withPermissions(destination.getParent(), Collections.emptySet());){
            new Loader().load(archive, destination, destination);
            Assert.fail((String)"Expected an exception");
        }
        catch (AccessDeniedException e) {
            Assert.assertEquals((Object)destination.getParent().toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheTxLogsParentDirectoryIsNotWritable() throws IOException, IncorrectFormat {
        Assume.assumeFalse((String)"We haven't found a way to reliably tests permissions on Windows", (boolean)SystemUtils.IS_OS_WINDOWS);
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        Path destination = this.testDirectory.file("destination").toPath();
        Path txLogsDirectory = this.testDirectory.directory("subdir/txLogs").toPath();
        Files.createDirectories(txLogsDirectory.getParent(), new FileAttribute[0]);
        try (Closeable ignored = TestUtils.withPermissions(txLogsDirectory.getParent(), Collections.emptySet());){
            new Loader().load(archive, destination, txLogsDirectory);
            Assert.fail((String)"Expected an exception");
        }
        catch (AccessDeniedException e) {
            Assert.assertEquals((Object)txLogsDirectory.getParent().toString(), (Object)e.getMessage());
        }
    }
}

