/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.apache.commons.lang3.SystemUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.dbms.archive.Dumper;
import org.neo4j.dbms.archive.TestUtils;
import org.neo4j.function.Predicates;
import org.neo4j.test.rule.TestDirectory;

public class DumperTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void shouldGiveAClearErrorIfTheArchiveAlreadyExists() throws IOException {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        Files.write(archive, new byte[0], new OpenOption[0]);
        try {
            new Dumper().dump(directory, directory, archive, Predicates.alwaysFalse());
            Assert.fail((String)"Expected an exception");
        }
        catch (FileAlreadyExistsException e) {
            Assert.assertEquals((Object)archive.toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheDirectoryDoesntExist() throws IOException {
        Path directory = this.testDirectory.file("a-directory").toPath();
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        try {
            new Dumper().dump(directory, directory, archive, Predicates.alwaysFalse());
            Assert.fail((String)"Expected an exception");
        }
        catch (NoSuchFileException e) {
            Assert.assertEquals((Object)directory.toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheArchivesParentDirectoryDoesntExist() throws IOException {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Path archive = this.testDirectory.file("subdir/the-archive.dump").toPath();
        try {
            new Dumper().dump(directory, directory, archive, Predicates.alwaysFalse());
            Assert.fail((String)"Expected an exception");
        }
        catch (NoSuchFileException e) {
            Assert.assertEquals((Object)archive.getParent().toString(), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheArchivesParentDirectoryIsAFile() throws IOException {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Path archive = this.testDirectory.file("subdir/the-archive.dump").toPath();
        Files.write(archive.getParent(), new byte[0], new OpenOption[0]);
        try {
            new Dumper().dump(directory, directory, archive, Predicates.alwaysFalse());
            Assert.fail((String)"Expected an exception");
        }
        catch (FileSystemException e) {
            Assert.assertEquals((Object)(archive.getParent().toString() + ": Not a directory"), (Object)e.getMessage());
        }
    }

    @Test
    public void shouldGiveAClearErrorMessageIfTheArchivesParentDirectoryIsNotWritable() throws IOException {
        Assume.assumeFalse((String)"We haven't found a way to reliably tests permissions on Windows", (boolean)SystemUtils.IS_OS_WINDOWS);
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Path archive = this.testDirectory.file("subdir/the-archive.dump").toPath();
        Files.createDirectories(archive.getParent(), new FileAttribute[0]);
        try (Closeable ignored = TestUtils.withPermissions(archive.getParent(), Collections.emptySet());){
            new Dumper().dump(directory, directory, archive, Predicates.alwaysFalse());
            Assert.fail((String)"Expected an exception");
        }
        catch (AccessDeniedException e) {
            Assert.assertEquals((Object)archive.getParent().toString(), (Object)e.getMessage());
        }
    }
}

