/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.archive;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.dbms.archive.Dumper;
import org.neo4j.dbms.archive.IncorrectFormat;
import org.neo4j.dbms.archive.Loader;
import org.neo4j.function.Predicates;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.test.rule.TestDirectory;

public class ArchiveTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void shouldRoundTripAnEmptyDirectory() throws IOException, IncorrectFormat {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Files.createDirectories(directory, new FileAttribute[0]);
        this.assertRoundTrips(directory);
    }

    @Test
    public void shouldRoundTripASingleFile() throws IOException, IncorrectFormat {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Files.createDirectories(directory, new FileAttribute[0]);
        Files.write(directory.resolve("a-file"), "text".getBytes(), new OpenOption[0]);
        this.assertRoundTrips(directory);
    }

    @Test
    public void shouldRoundTripAnEmptyFile() throws IOException, IncorrectFormat {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Files.createDirectories(directory, new FileAttribute[0]);
        Files.write(directory.resolve("a-file"), new byte[0], new OpenOption[0]);
        this.assertRoundTrips(directory);
    }

    @Test
    public void shouldRoundTripFilesWithDifferentContent() throws IOException, IncorrectFormat {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Files.createDirectories(directory, new FileAttribute[0]);
        Files.write(directory.resolve("a-file"), "text".getBytes(), new OpenOption[0]);
        Files.write(directory.resolve("another-file"), "some-different-text".getBytes(), new OpenOption[0]);
        this.assertRoundTrips(directory);
    }

    @Test
    public void shouldRoundTripEmptyDirectories() throws IOException, IncorrectFormat {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Path subdir = directory.resolve("a-subdirectory");
        Files.createDirectories(subdir, new FileAttribute[0]);
        this.assertRoundTrips(directory);
    }

    @Test
    public void shouldRoundTripFilesInDirectories() throws IOException, IncorrectFormat {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Path subdir = directory.resolve("a-subdirectory");
        Files.createDirectories(subdir, new FileAttribute[0]);
        Files.write(subdir.resolve("a-file"), "text".getBytes(), new OpenOption[0]);
        this.assertRoundTrips(directory);
    }

    @Test
    public void shouldCopeWithLongPaths() throws IOException, IncorrectFormat {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Path subdir = directory.resolve("a/very/long/path/which/is/not/realistic/for/a/database/today/but/which/ensures/that/we/dont/get/caught/out/at/in/the/future/the/point/being/that/there/are/multiple/tar/formats/some/of/which/do/not/cope/with/long/paths");
        Files.createDirectories(subdir, new FileAttribute[0]);
        Files.write(subdir.resolve("a-file"), "text".getBytes(), new OpenOption[0]);
        this.assertRoundTrips(directory);
    }

    @Test
    public void shouldExcludeFilesMatchedByTheExclusionPredicate() throws IOException, IncorrectFormat {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Files.createDirectories(directory, new FileAttribute[0]);
        Files.write(directory.resolve("a-file"), new byte[0], new OpenOption[0]);
        Files.write(directory.resolve("another-file"), new byte[0], new OpenOption[0]);
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        new Dumper().dump(directory, directory, archive, path -> path.getFileName().toString().equals("another-file"));
        Path newDirectory = this.testDirectory.file("the-new-directory").toPath();
        new Loader().load(archive, newDirectory, newDirectory);
        Path expectedOutput = this.testDirectory.directory("expected-output").toPath();
        Files.createDirectories(expectedOutput, new FileAttribute[0]);
        Files.write(expectedOutput.resolve("a-file"), new byte[0], new OpenOption[0]);
        Assert.assertEquals(this.describeRecursively(expectedOutput), this.describeRecursively(newDirectory));
    }

    @Test
    public void shouldExcludeWholeDirectoriesMatchedByTheExclusionPredicate() throws IOException, IncorrectFormat {
        Path directory = this.testDirectory.directory("a-directory").toPath();
        Path subdir = directory.resolve("subdir");
        Files.createDirectories(subdir, new FileAttribute[0]);
        Files.write(subdir.resolve("a-file"), new byte[0], new OpenOption[0]);
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        new Dumper().dump(directory, directory, archive, path -> path.getFileName().toString().equals("subdir"));
        Path newDirectory = this.testDirectory.file("the-new-directory").toPath();
        new Loader().load(archive, newDirectory, newDirectory);
        Path expectedOutput = this.testDirectory.directory("expected-output").toPath();
        Files.createDirectories(expectedOutput, new FileAttribute[0]);
        Assert.assertEquals(this.describeRecursively(expectedOutput), this.describeRecursively(newDirectory));
    }

    @Test
    public void dumpAndLoadTransactionLogsFromCustomLocations() throws IOException, IncorrectFormat {
        Path directory = this.testDirectory.directory("dbDirectory").toPath();
        Path txLogsDirectory = this.testDirectory.directory("txLogsDirectory").toPath();
        Files.write(directory.resolve("dbfile"), new byte[0], new OpenOption[0]);
        Files.write(txLogsDirectory.resolve("neostore.transaction.db.0"), new byte[0], new OpenOption[0]);
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        new Dumper().dump(directory, txLogsDirectory, archive, Predicates.alwaysFalse());
        Path newDirectory = this.testDirectory.file("the-new-directory").toPath();
        Path newTxLogsDirectory = this.testDirectory.file("newTxLogsDirectory").toPath();
        new Loader().load(archive, newDirectory, newTxLogsDirectory);
        Path expectedOutput = this.testDirectory.directory("expected-output").toPath();
        Files.createDirectories(expectedOutput, new FileAttribute[0]);
        Files.write(expectedOutput.resolve("dbfile"), new byte[0], new OpenOption[0]);
        Path expectedTxLogs = this.testDirectory.directory("expectedTxLogs").toPath();
        Files.createDirectories(expectedTxLogs, new FileAttribute[0]);
        Files.write(expectedTxLogs.resolve("neostore.transaction.db.0"), new byte[0], new OpenOption[0]);
        Assert.assertEquals(this.describeRecursively(expectedOutput), this.describeRecursively(newDirectory));
        Assert.assertEquals(this.describeRecursively(expectedTxLogs), this.describeRecursively(newTxLogsDirectory));
    }

    private void assertRoundTrips(Path oldDirectory) throws IOException, IncorrectFormat {
        Path archive = this.testDirectory.file("the-archive.dump").toPath();
        new Dumper().dump(oldDirectory, oldDirectory, archive, Predicates.alwaysFalse());
        Path newDirectory = this.testDirectory.file("the-new-directory").toPath();
        new Loader().load(archive, newDirectory, newDirectory);
        Assert.assertEquals(this.describeRecursively(oldDirectory), this.describeRecursively(newDirectory));
    }

    private Map<Path, Description> describeRecursively(Path directory) throws IOException {
        return Files.walk(directory, new FileVisitOption[0]).map(path -> Pair.pair((Object)directory.relativize((Path)path), (Object)this.describe((Path)path))).collect(HashMap::new, (pathDescriptionHashMap, pathDescriptionPair) -> {
            Description cfr_ignored_0 = (Description)pathDescriptionHashMap.put(pathDescriptionPair.first(), pathDescriptionPair.other());
        }, HashMap::putAll);
    }

    private Description describe(Path file) {
        try {
            return Files.isDirectory(file, new LinkOption[0]) ? new DirectoryDescription() : new FileDescription(Files.readAllBytes(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class FileDescription
    implements Description {
        private final byte[] bytes;

        FileDescription(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileDescription that = (FileDescription)o;
            return Arrays.equals(this.bytes, that.bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }

    private class DirectoryDescription
    implements Description {
        private DirectoryDescription() {
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }
    }

    private static interface Description {
    }
}

