/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms.config;

import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.commandline.dbms.config.WrappedCsvInputConfigurationForNeo4jAdmin;
import org.neo4j.csv.reader.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;

public class WrappedCsvInputConfigurationForNeo4jAdminTest {
    @Test
    public void shouldDelegateArrayDelimiter() {
        this.shouldDelegate(expected -> new Configuration.Overridden(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, (Character)expected){
            final /* synthetic */ Character val$expected;
            {
                this.val$expected = c;
                super(x0);
            }

            public char arrayDelimiter() {
                return this.val$expected.charValue();
            }
        }, org.neo4j.unsafe.impl.batchimport.input.csv.Configuration::arrayDelimiter, Character.valueOf('a'), Character.valueOf('b'));
    }

    @Test
    public void shouldDelegateDelimiter() {
        this.shouldDelegate(expected -> new Configuration.Overridden(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, (Character)expected){
            final /* synthetic */ Character val$expected;
            {
                this.val$expected = c;
                super(x0);
            }

            public char delimiter() {
                return this.val$expected.charValue();
            }
        }, org.neo4j.unsafe.impl.batchimport.input.csv.Configuration::delimiter, Character.valueOf('a'), Character.valueOf('b'));
    }

    @Test
    public void shouldDelegateQuoteCharacter() {
        this.shouldDelegate(expected -> new Configuration.Overridden(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, (Character)expected){
            final /* synthetic */ Character val$expected;
            {
                this.val$expected = c;
                super(x0);
            }

            public char quotationCharacter() {
                return this.val$expected.charValue();
            }
        }, Configuration::quotationCharacter, Character.valueOf('a'), Character.valueOf('b'));
    }

    @Test
    public void shouldOverrideTrimStrings() {
        this.shouldOverride(expected -> new Configuration.Overridden(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, (Boolean)expected){
            final /* synthetic */ Boolean val$expected;
            {
                this.val$expected = bl;
                super(x0);
            }

            public boolean trimStrings() {
                return this.val$expected;
            }
        }, Configuration::trimStrings, true, false);
    }

    @Test
    public void shouldOverrideBufferSize() {
        this.shouldOverride(expected -> new Configuration.Overridden(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, (Integer)expected){
            final /* synthetic */ Integer val$expected;
            {
                this.val$expected = n;
                super(x0);
            }

            public int bufferSize() {
                return this.val$expected;
            }
        }, Configuration::bufferSize, 100, 200);
    }

    @Test
    public void shouldDelegateMultiLineFields() {
        this.shouldDelegate(expected -> new Configuration.Overridden(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, (Boolean)expected){
            final /* synthetic */ Boolean val$expected;
            {
                this.val$expected = bl;
                super(x0);
            }

            public boolean multilineFields() {
                return this.val$expected;
            }
        }, Configuration::multilineFields, true, false);
    }

    @Test
    public void shouldOverrideEmptyQuotedStringsAsNull() {
        this.shouldOverride(expected -> new Configuration.Overridden(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, (Boolean)expected){
            final /* synthetic */ Boolean val$expected;
            {
                this.val$expected = bl;
                super(x0);
            }

            public boolean emptyQuotedStringsAsNull() {
                return this.val$expected;
            }
        }, Configuration::emptyQuotedStringsAsNull, true, false);
    }

    @Test
    public void shouldOverrideLegacyStyleQuoting() {
        this.shouldOverride(expected -> new Configuration.Overridden(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS, (Boolean)expected){
            final /* synthetic */ Boolean val$expected;
            {
                this.val$expected = bl;
                super(x0);
            }

            public boolean legacyStyleQuoting() {
                return this.val$expected;
            }
        }, Configuration::legacyStyleQuoting, true, false);
    }

    @SafeVarargs
    private final <T> void shouldDelegate(Function<T, org.neo4j.unsafe.impl.batchimport.input.csv.Configuration> configFactory, Function<org.neo4j.unsafe.impl.batchimport.input.csv.Configuration, T> getter, T ... expectedValues) {
        for (T expectedValue : expectedValues) {
            org.neo4j.unsafe.impl.batchimport.input.csv.Configuration configuration = configFactory.apply(expectedValue);
            WrappedCsvInputConfigurationForNeo4jAdmin wrapped = new WrappedCsvInputConfigurationForNeo4jAdmin(configuration);
            Assert.assertEquals(expectedValue, getter.apply((org.neo4j.unsafe.impl.batchimport.input.csv.Configuration)wrapped));
        }
        Assert.assertEquals(getter.apply(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS), getter.apply((org.neo4j.unsafe.impl.batchimport.input.csv.Configuration)new WrappedCsvInputConfigurationForNeo4jAdmin(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS)));
    }

    @SafeVarargs
    private final <T> void shouldOverride(Function<T, org.neo4j.unsafe.impl.batchimport.input.csv.Configuration> configFactory, Function<org.neo4j.unsafe.impl.batchimport.input.csv.Configuration, T> getter, T ... values) {
        for (T value : values) {
            org.neo4j.unsafe.impl.batchimport.input.csv.Configuration configuration = configFactory.apply(value);
            WrappedCsvInputConfigurationForNeo4jAdmin vanilla = new WrappedCsvInputConfigurationForNeo4jAdmin(org.neo4j.unsafe.impl.batchimport.input.csv.Configuration.COMMAS);
            WrappedCsvInputConfigurationForNeo4jAdmin wrapped = new WrappedCsvInputConfigurationForNeo4jAdmin(configuration);
            Assert.assertEquals(getter.apply((org.neo4j.unsafe.impl.batchimport.input.csv.Configuration)vanilla), getter.apply((org.neo4j.unsafe.impl.batchimport.input.csv.Configuration)wrapped));
        }
    }
}

