/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms.config;

import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.commandline.dbms.config.WrappedBatchImporterConfigurationForNeo4jAdmin;
import org.neo4j.io.ByteUnit;
import org.neo4j.unsafe.impl.batchimport.Configuration;

public class WrappedBatchImporterConfigurationForNeo4jAdminTest {
    @Test
    public void shouldDelegateDenseNodeThreshold() {
        this.shouldDelegate(expected -> new Configuration((Integer)expected){
            final /* synthetic */ Integer val$expected;
            {
                this.val$expected = n;
            }

            public int denseNodeThreshold() {
                return this.val$expected;
            }
        }, Configuration::denseNodeThreshold, 1, 20);
    }

    @Test
    public void shouldDelegateMovingAverageSize() {
        this.shouldDelegate(expected -> new Configuration((Integer)expected){
            final /* synthetic */ Integer val$expected;
            {
                this.val$expected = n;
            }

            public int movingAverageSize() {
                return this.val$expected;
            }
        }, Configuration::movingAverageSize, 100, 200);
    }

    @Test
    public void shouldDelegateSequentialBackgroundFlushing() {
        this.shouldDelegate(expected -> new Configuration((Boolean)expected){
            final /* synthetic */ Boolean val$expected;
            {
                this.val$expected = bl;
            }

            public boolean sequentialBackgroundFlushing() {
                return this.val$expected;
            }
        }, Configuration::sequentialBackgroundFlushing, true, false);
    }

    @Test
    public void shouldDelegateBatchSize() {
        this.shouldDelegate(expected -> new Configuration((Integer)expected){
            final /* synthetic */ Integer val$expected;
            {
                this.val$expected = n;
            }

            public int batchSize() {
                return this.val$expected;
            }
        }, Configuration::batchSize, 100, 200);
    }

    @Test
    public void shouldOverrideMaxNumberOfProcessors() {
        this.shouldOverride(expected -> new Configuration((Integer)expected){
            final /* synthetic */ Integer val$expected;
            {
                this.val$expected = n;
            }

            public int batchSize() {
                return this.val$expected;
            }
        }, Configuration::maxNumberOfProcessors, Configuration.DEFAULT.maxNumberOfProcessors() + 1, Configuration.DEFAULT.maxNumberOfProcessors() + 10);
    }

    @Test
    public void shouldDelegateParallelRecordWrites() {
        this.shouldDelegate(expected -> new Configuration((Boolean)expected){
            final /* synthetic */ Boolean val$expected;
            {
                this.val$expected = bl;
            }

            public boolean parallelRecordWrites() {
                return this.val$expected;
            }
        }, Configuration::parallelRecordWrites, true, false);
    }

    @Test
    public void shouldDelegateParallelRecordReads() {
        this.shouldDelegate(expected -> new Configuration((Boolean)expected){
            final /* synthetic */ Boolean val$expected;
            {
                this.val$expected = bl;
            }

            public boolean parallelRecordReads() {
                return this.val$expected;
            }
        }, Configuration::parallelRecordReads, true, false);
    }

    @Test
    public void shouldDelegateHighIO() {
        this.shouldDelegate(expected -> new Configuration((Boolean)expected){
            final /* synthetic */ Boolean val$expected;
            {
                this.val$expected = bl;
            }

            public boolean highIO() {
                return this.val$expected;
            }
        }, Configuration::highIO, true, false);
    }

    @Test
    public void shouldDelegateMaxMemoryUsage() {
        this.shouldDelegate(expected -> new Configuration((Long)expected){
            final /* synthetic */ Long val$expected;
            {
                this.val$expected = l;
            }

            public long maxMemoryUsage() {
                return this.val$expected;
            }
        }, Configuration::maxMemoryUsage, ByteUnit.kibiBytes((long)10L), ByteUnit.kibiBytes((long)20L));
    }

    @Test
    public void shouldDelegateAllowCacheAllocationOnHeap() {
        this.shouldDelegate(expected -> new Configuration((Boolean)expected){
            final /* synthetic */ Boolean val$expected;
            {
                this.val$expected = bl;
            }

            public boolean allowCacheAllocationOnHeap() {
                return this.val$expected;
            }
        }, Configuration::allowCacheAllocationOnHeap, true, false);
    }

    @SafeVarargs
    private final <T> void shouldDelegate(Function<T, Configuration> configFactory, Function<Configuration, T> getter, T ... expectedValues) {
        for (T expectedValue : expectedValues) {
            Configuration configuration = configFactory.apply(expectedValue);
            WrappedBatchImporterConfigurationForNeo4jAdmin wrapped = new WrappedBatchImporterConfigurationForNeo4jAdmin(configuration);
            Assert.assertEquals(expectedValue, getter.apply((Configuration)wrapped));
        }
        Assert.assertEquals(getter.apply(Configuration.DEFAULT), getter.apply((Configuration)new WrappedBatchImporterConfigurationForNeo4jAdmin(Configuration.DEFAULT)));
    }

    @SafeVarargs
    private final <T> void shouldOverride(Function<T, Configuration> configFactory, Function<Configuration, T> getter, T ... values) {
        for (T value : values) {
            Configuration configuration = configFactory.apply(value);
            WrappedBatchImporterConfigurationForNeo4jAdmin vanilla = new WrappedBatchImporterConfigurationForNeo4jAdmin(Configuration.DEFAULT);
            WrappedBatchImporterConfigurationForNeo4jAdmin wrapped = new WrappedBatchImporterConfigurationForNeo4jAdmin(configuration);
            Assert.assertEquals(getter.apply((Configuration)vanilla), getter.apply((Configuration)wrapped));
        }
    }
}

