/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.nio.file.Path;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.commandline.Util;
import org.neo4j.test.rule.TestDirectory;

public class UtilTest {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();

    @Test
    public void canonicalPath() {
        Assert.assertNotNull((Object)Util.canonicalPath((String)"foo").getParent());
    }

    @Test
    public void returnsAVersion() {
        Assert.assertNotNull((String)"A version should be returned", (Object)Util.neo4jVersion());
    }

    @Test
    public void correctlyIdentifySameOrChildFile() {
        Assert.assertTrue((boolean)Util.isSameOrChildFile((File)this.directory.directory(), (File)this.directory.directory("a")));
        Assert.assertTrue((boolean)Util.isSameOrChildFile((File)this.directory.directory(), (File)this.directory.directory()));
        Assert.assertTrue((boolean)Util.isSameOrChildFile((File)this.directory.directory("/a/./b"), (File)this.directory.directory("a/b")));
        Assert.assertTrue((boolean)Util.isSameOrChildFile((File)this.directory.directory("a/b"), (File)this.directory.directory("/a/./b")));
        Assert.assertFalse((boolean)Util.isSameOrChildFile((File)this.directory.directory("a"), (File)this.directory.directory("b")));
    }

    @Test
    public void correctlyIdentifySameOrChildPath() {
        Assert.assertTrue((boolean)Util.isSameOrChildPath((Path)this.directory.directory().toPath(), (Path)this.directory.directory("a").toPath()));
        Assert.assertTrue((boolean)Util.isSameOrChildPath((Path)this.directory.directory().toPath(), (Path)this.directory.directory().toPath()));
        Assert.assertTrue((boolean)Util.isSameOrChildPath((Path)this.directory.directory("/a/./b").toPath(), (Path)this.directory.directory("a/b").toPath()));
        Assert.assertTrue((boolean)Util.isSameOrChildPath((Path)this.directory.directory("a/b").toPath(), (Path)this.directory.directory("/a/./b").toPath()));
        Assert.assertFalse((boolean)Util.isSameOrChildPath((Path)this.directory.directory("a").toPath(), (Path)this.directory.directory("b").toPath()));
    }
}

