/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.condition.JRE;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.neo4j.commandline.admin.CommandFailed;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.RealOutsideWorld;
import org.neo4j.commandline.dbms.DiagnosticsReportCommand;
import org.neo4j.diagnostics.DiagnosticsOfflineReportProvider;
import org.neo4j.diagnostics.DiagnosticsReportSource;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class DiagnosticsReportCommandTest {
    @Rule
    public SuppressOutput suppressOutput = SuppressOutput.suppressAll();
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    private Path homeDir;
    private Path configDir;
    private Path configFile;
    private String originalUserDir;

    @Before
    public void setUp() throws Exception {
        this.homeDir = this.testDirectory.directory("home-dir").toPath();
        this.configDir = this.testDirectory.directory("config-dir").toPath();
        this.configFile = this.configDir.resolve("neo4j.conf");
        Files.createFile(this.configFile, new FileAttribute[0]);
        this.originalUserDir = System.setProperty("user.dir", this.testDirectory.absolutePath().getAbsolutePath());
    }

    @After
    public void tearDown() {
        System.setProperty("user.dir", this.originalUserDir);
    }

    @Test
    public void exitIfConfigFileIsMissing() throws IOException, CommandFailed, IncorrectUsage {
        Files.delete(this.configFile);
        String[] args = new String[]{"--list"};
        try (RealOutsideWorld outsideWorld = new RealOutsideWorld();){
            DiagnosticsReportCommand diagnosticsReportCommand = new DiagnosticsReportCommand(this.homeDir, this.configDir, (OutsideWorld)outsideWorld);
            this.expected.expect(CommandFailed.class);
            this.expected.expectMessage(CoreMatchers.containsString((String)"Unable to find config file, tried: "));
            diagnosticsReportCommand.execute(args);
        }
    }

    @Test
    public void allHasToBeOnlyClassifier() throws Exception {
        String[] args = new String[]{"all", "logs", "tx"};
        try (RealOutsideWorld outsideWorld = new RealOutsideWorld();){
            DiagnosticsReportCommand diagnosticsReportCommand = new DiagnosticsReportCommand(this.homeDir, this.configDir, (OutsideWorld)outsideWorld);
            this.expected.expect(IncorrectUsage.class);
            this.expected.expectMessage("If you specify 'all' this has to be the only classifier. Found ['logs','tx'] as well.");
            diagnosticsReportCommand.execute(args);
        }
    }

    @Test
    public void printUnrecognizedClassifiers() throws Exception {
        String[] args = new String[]{"logs", "tx", "invalid"};
        try (RealOutsideWorld outsideWorld = new RealOutsideWorld();){
            DiagnosticsReportCommand diagnosticsReportCommand = new DiagnosticsReportCommand(this.homeDir, this.configDir, (OutsideWorld)outsideWorld);
            this.expected.expect(IncorrectUsage.class);
            this.expected.expectMessage("Unknown classifier: invalid");
            diagnosticsReportCommand.execute(args);
        }
    }

    @Test
    public void defaultValuesShouldBeValidClassifiers() {
        for (String classifier : DiagnosticsReportCommand.DEFAULT_CLASSIFIERS) {
            DiagnosticsReportCommand.describeClassifier((String)classifier);
        }
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Unknown classifier: invalid");
        DiagnosticsReportCommand.describeClassifier((String)"invalid");
    }

    @Test
    public void listShouldDisplayAllClassifiers() throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            String[] args = new String[]{"--list"};
            OutsideWorld outsideWorld = (OutsideWorld)Mockito.mock(OutsideWorld.class);
            Mockito.when((Object)outsideWorld.fileSystem()).thenReturn((Object)this.fsRule.get());
            Mockito.when((Object)outsideWorld.outStream()).thenReturn((Object)ps);
            DiagnosticsReportCommand diagnosticsReportCommand = new DiagnosticsReportCommand(this.homeDir, this.configDir, outsideWorld);
            diagnosticsReportCommand.execute(args);
            Assert.assertThat((Object)baos.toString(), (Matcher)CoreMatchers.is((Object)String.format("Finding running instance of neo4j%nNo running instance of neo4j was found. Online reports will be omitted.%nAll available classifiers:%n  config     include configuration file%n  logs       include log files%n  plugins    include a view of the plugin directory%n  ps         include a list of running processes%n  tree       include a view of the tree structure of the data directory%n  tx         include transaction logs%n", new Object[0])));
        }
    }

    @Test
    public void overrideDestination() throws Exception {
        String toArgument = JRE.JAVA_11.isCurrentVersion() ? "--to=" + System.getProperty("user.dir") + "/other/" : "--to=other/";
        String[] args = new String[]{toArgument, "all"};
        try (RealOutsideWorld outsideWorld = new RealOutsideWorld();){
            DiagnosticsReportCommand diagnosticsReportCommand = new DiagnosticsReportCommand(this.homeDir, this.configDir, (OutsideWorld)outsideWorld);
            diagnosticsReportCommand.execute(args);
            File other = this.testDirectory.directory("other");
            FileSystemAbstraction fs = outsideWorld.fileSystem();
            Assert.assertThat((Object)fs.fileExists(other), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)fs.listFiles(other).length, (Matcher)CoreMatchers.is((Object)1));
            File reports = new File(this.testDirectory.directory(), "reports");
            Assert.assertThat((Object)fs.fileExists(reports), (Matcher)CoreMatchers.is((Object)false));
        }
    }

    public static class MyDiagnosticsOfflineReportProvider
    extends DiagnosticsOfflineReportProvider {
        public MyDiagnosticsOfflineReportProvider() {
            super("my-provider", "logs", new String[]{"tx"});
        }

        public void init(FileSystemAbstraction fs, Config config, File storeDirectory) {
        }

        @Nonnull
        protected List<DiagnosticsReportSource> provideSources(Set<String> classifiers) {
            return Collections.emptyList();
        }
    }
}

