/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.nio.file.Path;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.AdminCommandSection;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.arguments.Arguments;
import org.neo4j.commandline.dbms.LoadCommand;
import org.neo4j.commandline.dbms.OffineBackupCommandSection;
import org.neo4j.dbms.archive.Loader;

public class LoadCommandProvider
extends AdminCommand.Provider {
    public LoadCommandProvider() {
        super("load", new String[0]);
    }

    public Arguments allArguments() {
        return LoadCommand.arguments();
    }

    public String description() {
        return "Load a database from an archive. <archive-path> must be an archive created with the dump command. <database> is the name of the database to create. Existing databases can be replaced by specifying --force. It is not possible to replace a database that is mounted in a running Neo4j server.";
    }

    public String summary() {
        return "Load a database from an archive created with the dump command.";
    }

    public AdminCommandSection commandSection() {
        return OffineBackupCommandSection.instance();
    }

    public AdminCommand create(Path homeDir, Path configDir, OutsideWorld outsideWorld) {
        return new LoadCommand(homeDir, configDir, new Loader());
    }
}

