/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.commandline.dbms.VersionCommand;
import org.neo4j.commandline.dbms.VersionCommandProvider;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_2;
import org.neo4j.kernel.internal.Version;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

public class VersionCommandTest {
    @Rule
    public TestDirectory testDirectory = TestDirectory.testDirectory();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    @Rule
    public DefaultFileSystemRule fsRule = new DefaultFileSystemRule();
    @Rule
    public PageCacheRule pageCacheRule = new PageCacheRule();
    private Path databaseDirectory;
    private ArgumentCaptor<String> outCaptor;
    private VersionCommand command;
    private Consumer<String> out;

    @Before
    public void setUp() throws Exception {
        Path homeDir = this.testDirectory.directory("home-dir").toPath();
        this.databaseDirectory = homeDir.resolve("data/databases/foo.db");
        Files.createDirectories(this.databaseDirectory, new FileAttribute[0]);
        this.outCaptor = ArgumentCaptor.forClass(String.class);
        this.out = (Consumer)Mockito.mock(Consumer.class);
        this.command = new VersionCommand(this.out);
    }

    @Test
    public void shouldPrintNiceHelp() throws Exception {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new VersionCommandProvider(), ps::println);
            Assert.assertEquals((Object)String.format("usage: neo4j-admin version --store=<path-to-dir>%n%nChecks the version of a Neo4j database store. Note that this command expects a%npath to a store directory, for example --store=data/databases/graph.db.%n%noptions:%n  --store=<path-to-dir>   Path to database store to check version of.%n", new Object[0]), (Object)baos.toString());
        }
    }

    @Test
    public void noArgFails() throws Exception {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Missing argument 'store'");
        this.command.execute(new String[0]);
    }

    @Test
    public void emptyArgFails() throws Exception {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Missing argument 'store'");
        this.command.execute(new String[]{"--store="});
    }

    @Test
    public void nonExistingDatabaseShouldThrow() throws Exception {
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("does not contain a database");
        this.execute(Paths.get("yaba", "daba", "doo").toString());
    }

    @Test
    public void readsLatestStoreVersionCorrectly() throws Exception {
        RecordFormats currentFormat = RecordFormatSelector.defaultFormat();
        this.prepareNeoStoreFile(currentFormat.storeVersion());
        this.execute(this.databaseDirectory.toString());
        ((Consumer)Mockito.verify(this.out, (VerificationMode)Mockito.times((int)3))).accept(this.outCaptor.capture());
        Assert.assertEquals(Arrays.asList(String.format("Store format version:    %s", currentFormat.storeVersion()), String.format("Introduced in version:   %s", currentFormat.introductionVersion()), String.format("Current version:         %s", Version.getNeo4jVersion())), (Object)this.outCaptor.getAllValues());
    }

    @Test
    public void readsOlderStoreVersionCorrectly() throws Exception {
        this.prepareNeoStoreFile(StandardV2_2.RECORD_FORMATS.storeVersion());
        this.execute(this.databaseDirectory.toString());
        ((Consumer)Mockito.verify(this.out, (VerificationMode)Mockito.times((int)4))).accept(this.outCaptor.capture());
        Assert.assertEquals(Arrays.asList("Store format version:    v0.A.5", "Introduced in version:   2.2.0", "Superseded in version:   2.3.0", String.format("Current version:         %s", Version.getNeo4jVersion())), (Object)this.outCaptor.getAllValues());
    }

    @Test
    public void throwsOnUnknownVersion() throws Exception {
        this.prepareNeoStoreFile("v9.9.9");
        this.expected.expect(IllegalArgumentException.class);
        this.expected.expectMessage("Unknown store version 'v9.9.9'");
        this.execute(this.databaseDirectory.toString());
    }

    private void execute(String storePath) throws Exception {
        this.command.execute(new String[]{"--store=" + storePath});
    }

    private void prepareNeoStoreFile(String storeVersion) throws IOException {
        File neoStoreFile = this.createNeoStoreFile();
        long value = MetaDataStore.versionStringToLong((String)storeVersion);
        MetaDataStore.setRecord((PageCache)this.pageCacheRule.getPageCache(this.fsRule.get()), (File)neoStoreFile, (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)value);
    }

    private File createNeoStoreFile() throws IOException {
        ((DefaultFileSystemAbstraction)this.fsRule.get()).mkdir(this.databaseDirectory.toFile());
        File neoStoreFile = new File(this.databaseDirectory.toFile(), "neostore");
        ((DefaultFileSystemAbstraction)this.fsRule.get()).create(neoStoreFile).close();
        return neoStoreFile;
    }
}

