/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.commandline.admin.AdminCommand;
import org.neo4j.commandline.admin.CommandLocator;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.NullOutsideWorld;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.RealOutsideWorld;
import org.neo4j.commandline.admin.Usage;
import org.neo4j.commandline.dbms.ImportCommand;
import org.neo4j.commandline.dbms.ImportCommandProvider;
import org.neo4j.commandline.dbms.Importer;
import org.neo4j.commandline.dbms.ImporterFactory;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.test.rule.TestDirectory;

public class ImportCommandTest {
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory();

    @Test
    public void defaultsToCsvWhenModeNotSpecified() throws Exception {
        File homeDir = this.testDir.directory("home");
        ImporterFactory mockImporterFactory = (ImporterFactory)Mockito.mock(ImporterFactory.class);
        Mockito.when((Object)mockImporterFactory.getImporterForMode((String)org.mockito.Matchers.eq((Object)"csv"), (Args)org.mockito.Matchers.any(Args.class), (Config)org.mockito.Matchers.any(Config.class), (OutsideWorld)org.mockito.Matchers.any(OutsideWorld.class))).thenReturn(Mockito.mock(Importer.class));
        try (RealOutsideWorld outsideWorld = new RealOutsideWorld();){
            ImportCommand importCommand = new ImportCommand(homeDir.toPath(), this.testDir.directory("conf").toPath(), (OutsideWorld)outsideWorld, mockImporterFactory);
            String[] arguments = new String[]{"--database=foo", "--from=bar"};
            importCommand.execute(arguments);
            ((ImporterFactory)Mockito.verify((Object)mockImporterFactory)).getImporterForMode((String)org.mockito.Matchers.eq((Object)"csv"), (Args)org.mockito.Matchers.any(Args.class), (Config)org.mockito.Matchers.any(Config.class), (OutsideWorld)org.mockito.Matchers.any(OutsideWorld.class));
        }
    }

    @Test
    public void acceptsNodeMetadata() throws Exception {
        File homeDir = this.testDir.directory("home");
        ImporterFactory mockImporterFactory = (ImporterFactory)Mockito.mock(ImporterFactory.class);
        Mockito.when((Object)mockImporterFactory.getImporterForMode((String)org.mockito.Matchers.eq((Object)"csv"), (Args)org.mockito.Matchers.any(Args.class), (Config)org.mockito.Matchers.any(Config.class), (OutsideWorld)org.mockito.Matchers.any(OutsideWorld.class))).thenReturn(Mockito.mock(Importer.class));
        ImportCommand importCommand = new ImportCommand(homeDir.toPath(), this.testDir.directory("conf").toPath(), (OutsideWorld)new RealOutsideWorld(), mockImporterFactory);
        String[] arguments = new String[]{"--database=foo", "--from=bar", "--nodes:PERSON:FRIEND=mock.csv"};
        importCommand.execute(arguments);
        ((ImporterFactory)Mockito.verify((Object)mockImporterFactory)).getImporterForMode((String)org.mockito.Matchers.eq((Object)"csv"), (Args)org.mockito.Matchers.any(Args.class), (Config)org.mockito.Matchers.any(Config.class), (OutsideWorld)org.mockito.Matchers.any(OutsideWorld.class));
    }

    @Test
    public void acceptsRelationshipsMetadata() throws Exception {
        File homeDir = this.testDir.directory("home");
        ImporterFactory mockImporterFactory = (ImporterFactory)Mockito.mock(ImporterFactory.class);
        Mockito.when((Object)mockImporterFactory.getImporterForMode((String)org.mockito.Matchers.eq((Object)"csv"), (Args)org.mockito.Matchers.any(Args.class), (Config)org.mockito.Matchers.any(Config.class), (OutsideWorld)org.mockito.Matchers.any(OutsideWorld.class))).thenReturn(Mockito.mock(Importer.class));
        ImportCommand importCommand = new ImportCommand(homeDir.toPath(), this.testDir.directory("conf").toPath(), (OutsideWorld)new RealOutsideWorld(), mockImporterFactory);
        String[] arguments = new String[]{"--database=foo", "--from=bar", "--relationships:LIKES:HATES=mock.csv"};
        importCommand.execute(arguments);
        ((ImporterFactory)Mockito.verify((Object)mockImporterFactory)).getImporterForMode((String)org.mockito.Matchers.eq((Object)"csv"), (Args)org.mockito.Matchers.any(Args.class), (Config)org.mockito.Matchers.any(Config.class), (OutsideWorld)org.mockito.Matchers.any(OutsideWorld.class));
    }

    @Test
    public void requiresDatabaseArgument() throws Exception {
        try (NullOutsideWorld outsideWorld = new NullOutsideWorld();){
            ImportCommand importCommand = new ImportCommand(this.testDir.directory("home").toPath(), this.testDir.directory("conf").toPath(), (OutsideWorld)outsideWorld);
            String[] arguments = new String[]{"--mode=database", "--from=bar"};
            try {
                importCommand.execute(arguments);
                Assert.fail((String)"Should have thrown an exception.");
            }
            catch (IncorrectUsage e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"database"));
            }
        }
    }

    @Test
    public void failIfInvalidModeSpecified() throws Exception {
        try (NullOutsideWorld outsideWorld = new NullOutsideWorld();){
            ImportCommand importCommand = new ImportCommand(this.testDir.directory("home").toPath(), this.testDir.directory("conf").toPath(), (OutsideWorld)outsideWorld);
            String[] arguments = new String[]{"--mode=foo", "--database=bar", "--from=baz"};
            try {
                importCommand.execute(arguments);
                Assert.fail((String)"Should have thrown an exception.");
            }
            catch (IncorrectUsage e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"foo"));
            }
        }
    }

    @Test
    public void failIfDestinationDatabaseAlreadyExists() throws Exception {
        try (NullOutsideWorld outsideWorld = new NullOutsideWorld();){
            Path homeDir = this.testDir.directory("home").toPath();
            ImportCommand importCommand = new ImportCommand(homeDir, this.testDir.directory("conf").toPath(), (OutsideWorld)outsideWorld);
            this.putStoreInDirectory(homeDir.resolve("data").resolve("databases").resolve("existing.db"));
            String[] arguments = new String[]{"--mode=csv", "--database=existing.db"};
            try {
                importCommand.execute(arguments);
                Assert.fail((String)"Should have thrown an exception.");
            }
            catch (Exception e) {
                Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"already contains a database"));
            }
        }
    }

    @Test
    public void shouldPrintNiceHelp() throws Throwable {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            PrintStream ps = new PrintStream(baos);
            Usage usage = new Usage("neo4j-admin", (CommandLocator)Mockito.mock(CommandLocator.class));
            usage.printUsageForCommand((AdminCommand.Provider)new ImportCommandProvider(), ps::println);
            Assert.assertEquals((Object)String.format("usage: neo4j-admin import [--mode=csv] [--database=<name>]%n                          [--additional-config=<config-file-path>]%n                          [--report-file=<filename>]%n                          [--nodes[:Label1:Label2]=<\"file1,file2,...\">]%n                          [--relationships[:RELATIONSHIP_TYPE]=<\"file1,file2,...\">]%n                          [--id-type=<STRING|INTEGER|ACTUAL>]%n                          [--input-encoding=<character-set>]%n                          [--ignore-extra-columns[=<true|false>]]%n                          [--ignore-duplicate-nodes[=<true|false>]]%n                          [--ignore-missing-nodes[=<true|false>]]%nusage: neo4j-admin import --mode=database [--database=<name>]%n                          [--additional-config=<config-file-path>]%n                          [--from=<source-directory>]%n%nImport a collection of CSV files with --mode=csv (default), or a database from a%npre-3.0 installation with --mode=database.%n%noptions:%n  --database=<name>%n      Name of database. [default:graph.db]%n  --additional-config=<config-file-path>%n      Configuration file to supply additional configuration in. [default:]%n  --mode=<database|csv>%n      Import a collection of CSV files or a pre-3.0 installation. [default:csv]%n  --from=<source-directory>%n      The location of the pre-3.0 database (e.g. <neo4j-root>/data/graph.db).%n      [default:]%n  --report-file=<filename>%n      File in which to store the report of the csv-import.%n      [default:import.report]%n  --nodes[:Label1:Label2]=<\"file1,file2,...\">%n      Node CSV header and data. Multiple files will be logically seen as one big%n      file from the perspective of the importer. The first line must contain the%n      header. Multiple data sources like these can be specified in one import,%n      where each data source has its own header. Note that file groups must be%n      enclosed in quotation marks. [default:]%n  --relationships[:RELATIONSHIP_TYPE]=<\"file1,file2,...\">%n      Relationship CSV header and data. Multiple files will be logically seen as%n      one big file from the perspective of the importer. The first line must%n      contain the header. Multiple data sources like these can be specified in%n      one import, where each data source has its own header. Note that file%n      groups must be enclosed in quotation marks. [default:]%n  --id-type=<STRING|INTEGER|ACTUAL>%n      Each node must provide a unique id. This is used to find the correct nodes%n      when creating relationships. Possible values are:%n        STRING: arbitrary strings for identifying nodes,%n        INTEGER: arbitrary integer values for identifying nodes,%n        ACTUAL: (advanced) actual node ids.%n      For more information on id handling, please see the Neo4j Manual:%n      https://neo4j.com/docs/operations-manual/current/tools/import/%n      [default:STRING]%n  --input-encoding=<character-set>%n      Character set that input data is encoded in. [default:UTF-8]%n  --ignore-extra-columns=<true|false>%n      If un-specified columns should be ignored during the import.%n      [default:false]%n  --ignore-duplicate-nodes=<true|false>%n      If duplicate nodes should be ignored during the import. [default:false]%n  --ignore-missing-nodes=<true|false>%n      If relationships referring to missing nodes should be ignored during the%n      import. [default:false]%n", new Object[0]), (Object)baos.toString());
        }
    }

    private void putStoreInDirectory(Path storeDir) throws IOException {
        Files.createDirectories(storeDir, new FileAttribute[0]);
        Path storeFile = storeDir.resolve(StoreFileType.STORE.augment("neostore"));
        Files.createFile(storeFile, new FileAttribute[0]);
    }
}

