/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.util.HashMap;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.commandline.admin.IncorrectUsage;
import org.neo4j.commandline.admin.NullOutsideWorld;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.dbms.DatabaseImporter;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class DatabaseImporterTest {
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory();

    @Test
    public void requiresFromArgument() throws Exception {
        String[] arguments = new String[]{"--mode=database", "--database=bar"};
        try {
            new DatabaseImporter(Args.parse((String[])arguments), Config.defaults(), (OutsideWorld)new NullOutsideWorld());
            Assert.fail((String)"Should have thrown an exception.");
        }
        catch (IncorrectUsage e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"from"));
        }
    }

    @Test
    public void failIfSourceIsNotAStore() throws Exception {
        File from = this.testDir.directory("empty");
        String[] arguments = new String[]{"--mode=database", "--database=bar", "--from=" + from.getAbsolutePath()};
        try {
            new DatabaseImporter(Args.parse((String[])arguments), Config.defaults(), (OutsideWorld)new NullOutsideWorld());
            Assert.fail((String)"Should have thrown an exception.");
        }
        catch (IncorrectUsage e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"does not contain a database"));
        }
    }

    @Test
    public void copiesDatabaseFromOldLocationToNewLocation() throws Exception {
        File home = this.testDir.directory("home");
        File from = this.provideStoreDirectory();
        File destination = new File(new File(new File(home, "data"), "databases"), "bar");
        String[] arguments = new String[]{"--mode=database", "--database=bar", "--from=" + from.getAbsolutePath()};
        DatabaseImporter importer = new DatabaseImporter(Args.parse((String[])arguments), this.getConfigWith(home, "bar"), (OutsideWorld)new NullOutsideWorld());
        Assert.assertThat((Object)destination, (Matcher)IsNot.not(this.isExistingDatabase()));
        importer.doImport();
        Assert.assertThat((Object)destination, this.isExistingDatabase());
    }

    @Test
    public void removesOldMessagesLog() throws Exception {
        File home = this.testDir.directory("home");
        File from = this.provideStoreDirectory();
        File oldMessagesLog = new File(from, "messages.log");
        Assert.assertTrue((boolean)oldMessagesLog.createNewFile());
        File destination = new File(new File(new File(home, "data"), "databases"), "bar");
        String[] arguments = new String[]{"--mode=database", "--database=bar", "--from=" + from.getAbsolutePath()};
        DatabaseImporter importer = new DatabaseImporter(Args.parse((String[])arguments), this.getConfigWith(home, "bar"), (OutsideWorld)new NullOutsideWorld());
        File messagesLog = new File(destination, "messages.log");
        importer.doImport();
        Assert.assertFalse((boolean)messagesLog.exists());
    }

    private Config getConfigWith(File homeDir, String databaseName) {
        HashMap<String, String> additionalConfig = new HashMap<String, String>();
        additionalConfig.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.toString());
        additionalConfig.put(DatabaseManagementSystemSettings.active_database.name(), databaseName);
        return Config.defaults().with(additionalConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File provideStoreDirectory() {
        File storeDir = this.testDir.graphDbDir();
        GraphDatabaseService db = null;
        try {
            db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
            try (Transaction transaction = db.beginTx();){
                db.createNode();
                transaction.success();
            }
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
        return storeDir;
    }

    private Matcher<File> isExistingDatabase() {
        return new BaseMatcher<File>(){

            public boolean matches(Object item) {
                File store = (File)item;
                try {
                    Validators.CONTAINS_EXISTING_DATABASE.validate((Object)store);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("an existing database.");
            }

            public void describeMismatch(Object item, Description description) {
                description.appendValue(item).appendText(" is not an existing database.");
            }
        };
    }
}

