/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.commandline.dbms;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.commandline.admin.OutsideWorld;
import org.neo4j.commandline.admin.RealOutsideWorld;
import org.neo4j.commandline.dbms.CsvImporter;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Args;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.test.rule.SuppressOutput;
import org.neo4j.test.rule.TestDirectory;

public class CsvImporterTest {
    @Rule
    public final TestDirectory testDir = TestDirectory.testDirectory();
    @Rule
    public final SuppressOutput suppressOutput = SuppressOutput.suppressAll();

    @Test
    public void writesReportToSpecifiedReportFile() throws Exception {
        File dbDir = this.testDir.directory("db");
        File logDir = this.testDir.directory("logs");
        File reportLocation = this.testDir.file("the_report");
        File inputFile = this.testDir.file("foobar.csv");
        List<String> lines = Arrays.asList("foo,bar,baz");
        Files.write(inputFile.toPath(), lines, Charset.defaultCharset(), new OpenOption[0]);
        try (RealOutsideWorld outsideWorld = new RealOutsideWorld();){
            Config config = Config.defaults().with(this.additionalConfig()).with(MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.database_path.name(), dbDir.getAbsolutePath(), GraphDatabaseSettings.logs_directory.name(), logDir.getAbsolutePath()}));
            CsvImporter csvImporter = new CsvImporter(Args.parse((String[])new String[]{String.format("--report-file=%s", reportLocation.getAbsolutePath()), String.format("--nodes=%s", inputFile.getAbsolutePath())}), config, (OutsideWorld)outsideWorld);
            csvImporter.doImport();
        }
        Assert.assertTrue((boolean)reportLocation.exists());
    }

    private Map<String, String> additionalConfig() {
        return MapUtil.stringMap((String[])new String[]{DatabaseManagementSystemSettings.database_path.name(), this.getDatabasePath(), GraphDatabaseSettings.logs_directory.name(), this.getLogsDirectory()});
    }

    private String getDatabasePath() {
        return this.testDir.graphDbDir().getAbsolutePath();
    }

    private String getLogsDirectory() {
        return this.testDir.directory("logs").getAbsolutePath();
    }
}

