/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted.helpers;

import org.neo4j.cypher.internal.compatibility.v3_5.runtime.Slot;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.SlotConfiguration;
import org.neo4j.cypher.internal.compatibility.v3_5.runtime.SlotConfiguration$;
import org.neo4j.cypher.internal.runtime.slotted.SlottedExecutionContext;
import org.neo4j.cypher.internal.runtime.slotted.helpers.SlottedPipeBuilderUtils$;
import org.neo4j.cypher.internal.runtime.slotted.helpers.SlottedPipeBuilderUtils$$$$148ee865eff084d392b1f635f3ed9$$$;
import org.neo4j.cypher.internal.runtime.slotted.helpers.SlottedPipeBuilderUtils$$$$74f7d28a8dbbcb4fa496cc5dbb21c4c$$$;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;
import org.opencypher.v9_0.util.AssertionUtils$;
import org.opencypher.v9_0.util.ParameterWrongTypeException;
import org.opencypher.v9_0.util.symbols.CypherType;
import org.opencypher.v9_0.util.symbols.package$;
import org.opencypher.v9_0.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0001\u0003\u0001E\u00111d\u00157piR,G\rU5qK\n+\u0018\u000e\u001c3feV#\u0018\u000e\\:UKN$(BA\u0002\u0005\u0003\u001dAW\r\u001c9feNT!!\u0002\u0004\u0002\u000fMdw\u000e\u001e;fI*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000f\u000e\u0003QQ!!\u0006\f\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005]A\u0012\u0001B;uS2T!!\u0007\u000e\u0002\tYLt\f\r\u0006\u000379\t!b\u001c9f]\u000eL\b\u000f[3s\u0013\tiBC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000b}\u0001A\u0011\u0001\u0011\u0002\rqJg.\u001b;?)\u0005\t\u0003C\u0001\u0012\u0001\u001b\u0005\u0011\u0001b\u0002\u0013\u0001\u0005\u0004%I!J\u0001\u0006g2|Go]\u000b\u0002MA\u0011q%L\u0007\u0002Q)\u0011q!\u000b\u0006\u0003U-\nAA^\u001a`k)\u0011A\u0006C\u0001\u000eG>l\u0007/\u0019;jE&d\u0017\u000e^=\n\u00059B#!E*m_R\u001cuN\u001c4jOV\u0014\u0018\r^5p]\"1\u0001\u0007\u0001Q\u0001\n\u0019\naa\u001d7piN\u0004\u0003\"\u0002\u001a\u0001\t\u0013\u0019\u0014!D1tg\u0016\u0014HoR3u\u0019>tw\r\u0006\u00035u}\"\u0005CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$\u0001B+oSRDQaO\u0019A\u0002q\nAa\u001d7piB\u0011q%P\u0005\u0003}!\u0012Aa\u00157pi\")\u0001)\ra\u0001\u0003\u0006IAn\u001c8h-\u0006dW/\u001a\t\u0003k\tK!a\u0011\u001c\u0003\t1{gn\u001a\u0005\u0006\u000bF\u0002\rAR\u0001\u000eKb\u0004Xm\u0019;fIZ\u000bG.^3\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%c\u0011A\u0002<bYV,7/\u0003\u0002L\u0011\nA\u0011I\\=WC2,X\rC\u0003N\u0001\u0011%a*A\u0007bgN,'\u000f^$fi:{G-\u001a\u000b\u0004i=\u0003\u0006\"B\u001eM\u0001\u0004a\u0004\"B)M\u0001\u0004\t\u0015AA5e\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0003U\t7o]3si\u001e+GOU3mCRLwN\\:iSB$2\u0001N+W\u0011\u0015Y$\u000b1\u0001=\u0011\u0015\t&\u000b1\u0001B\u0011\u0015A\u0006\u0001\"\u0003Z\u00035\t7o]3siN+G\u000fT8oOR!AGW.^\u0011\u0015Yt\u000b1\u0001=\u0011\u0015av\u000b1\u0001G\u0003\u00151\u0018\r\\;f\u0011\u0015qv\u000b1\u0001B\u0003!)\u0007\u0010]3di\u0016$\u0007\"\u00021\u0001\t\u0013\t\u0017!D1tg\u0016\u0014HoU3u\u001d>$W\rF\u00025E\u000eDQaO0A\u0002qBQ!U0A\u0002\u0005CQ!\u001a\u0001\u0005\n\u0019\fQ#Y:tKJ$8+\u001a;SK2\fG/[8og\"L\u0007\u000fF\u00025O\"DQa\u000f3A\u0002qBQ!\u00153A\u0002\u0005CQA\u001b\u0001\u0005\n-\fa\"Y:tKJ$8+\u001a;GC&d7\u000fF\u00025Y6DQaO5A\u0002qBQ\u0001X5A\u0002\u0019CQa\u001c\u0001\u0005\nA\f!$Y:tKJ$\bK]5nSRLg/\u001a(pI\u0016\u001cV\r\u001e'p]\u001e$2\u0001N9s\u0011\u0015Yd\u000e1\u0001=\u0011\u0015\tf\u000e1\u0001B\u0011\u0015!\b\u0001\"\u0003v\u0003\t\n7o]3siB\u0013\u0018.\\5uSZ,'+\u001a7bi&|gn\u001d5jaN+G\u000fT8oOR\u0019AG^<\t\u000bm\u001a\b\u0019\u0001\u001f\t\u000bE\u001b\b\u0019A!\t\u000be\u0004A\u0011\u0002>\u00023\u0005\u001c8/\u001a:u!JLW.\u001b;jm\u0016tu\u000eZ3TKR\u0014VM\u001a\u000b\u0005imdX\u0010C\u0003<q\u0002\u0007A\bC\u0003Rq\u0002\u0007\u0011\tC\u0003_q\u0002\u0007a\t\u0003\u0004\u0000\u0001\u0011%\u0011\u0011A\u0001\"CN\u001cXM\u001d;Qe&l\u0017\u000e^5wKJ+G.\u0019;j_:\u001c\b.\u001b9TKR\u0014VM\u001a\u000b\bi\u0005\r\u0011QAA\u0004\u0011\u0015Yd\u00101\u0001=\u0011\u0015\tf\u00101\u0001B\u0011\u0015qf\u00101\u0001G\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001b\t1$Y:tKJ$\bK]5nSRLg/\u001a(pI\u0016\u001cV\r\u001e$bS2\u001cH#\u0002\u001b\u0002\u0010\u0005E\u0001BB\u001e\u0002\n\u0001\u0007A\b\u0003\u0004R\u0003\u0013\u0001\r!\u0011\u0005\b\u0003+\u0001A\u0011BA\f\u0003\r\n7o]3siB\u0013\u0018.\\5uSZ,'+\u001a7bi&|gn\u001d5jaN+GOR1jYN$R\u0001NA\r\u00037AaaOA\n\u0001\u0004a\u0004BB)\u0002\u0014\u0001\u0007\u0011\t")
public class SlottedPipeBuilderUtilsTest
extends CypherFunSuite {
    private final SlotConfiguration org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots = SlotConfiguration$.MODULE$.empty().newLong("n1", false, (CypherType)package$.MODULE$.CTNode()).newLong("n2", true, (CypherType)package$.MODULE$.CTNode()).newLong("r1", false, (CypherType)package$.MODULE$.CTRelationship()).newLong("r2", true, (CypherType)package$.MODULE$.CTRelationship()).newReference("x", true, (CypherType)package$.MODULE$.CTAny()).newReference("y", false, (CypherType)package$.MODULE$.CTAny());

    public SlotConfiguration org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots() {
        return this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots;
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(Slot slot, long longValue, AnyValue expectedValue) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function1 getter = SlottedPipeBuilderUtils$.MODULE$.makeGetValueFromSlotFunctionFor(slot);
        context.setLongAt(slot.offset(), longValue);
        AnyValue value = (AnyValue)getter.apply((Object)context);
        this.convertToAnyShouldWrapper(value).should(this.equal(expectedValue), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(slot, id, (AnyValue)VirtualValues.node((long)id));
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(slot, id, (AnyValue)VirtualValues.relationship((long)id));
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(Slot slot, AnyValue value, long expected) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
        setter.apply((Object)context, (Object)value);
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)context.getLongAt(slot.offset()))).should(this.equal(BoxesRunTime.boxToLong((long)expected)), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(slot, (AnyValue)VirtualValues.node((long)id), id);
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(slot, (AnyValue)VirtualValues.relationship((long)id), id);
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(Slot slot, AnyValue value) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
        this.a(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)).should(this.be()).thrownBy((Function0)new Serializable(this, value, context, setter){
            public static final long serialVersionUID = 0L;
            private final AnyValue value$1;
            private final SlottedExecutionContext context$1;
            private final Function2 setter$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.setter$1.apply((Object)this.context$1, (Object)this.value$1);
            }
            {
                this.value$1 = value$1;
                this.context$1 = context$1;
                this.setter$1 = setter$1;
            }
        });
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetLong(Slot slot, long id) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 primitiveNodeSetter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveNodeInSlotFunctionFor(slot);
        primitiveNodeSetter.apply((Object)context, (Object)BoxesRunTime.boxToLong((long)id));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)context.getLongAt(slot.offset()))).should(this.equal(BoxesRunTime.boxToLong((long)id)), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetLong(Slot slot, long id) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 primitiveRelationshipSetter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveRelationshipInSlotFunctionFor(slot);
        primitiveRelationshipSetter.apply((Object)context, (Object)BoxesRunTime.boxToLong((long)id));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)context.getLongAt(slot.offset()))).should(this.equal(BoxesRunTime.boxToLong((long)id)), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetRef(Slot slot, long id, AnyValue expected) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 primitiveNodeSetter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveNodeInSlotFunctionFor(slot);
        primitiveNodeSetter.apply((Object)context, (Object)BoxesRunTime.boxToLong((long)id));
        this.convertToAnyShouldWrapper(context.getRefAt(slot.offset())).should(this.equal(expected), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetRef(Slot slot, long id, AnyValue expected) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 primitiveRelationshipSetter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveRelationshipInSlotFunctionFor(slot);
        primitiveRelationshipSetter.apply((Object)context, (Object)BoxesRunTime.boxToLong((long)id));
        this.convertToAnyShouldWrapper(context.getRefAt(slot.offset())).should(this.equal(expected), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetFails(Slot slot, long id) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveNodeInSlotFunctionFor(slot);
        AssertionUtils$.MODULE$.ifAssertionsEnabled((Function0)new Serializable(this, id, context, setter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;
            public final long id$1;
            public final SlottedExecutionContext context$2;
            public final Function2 setter$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SlottedPipeBuilderUtils$$$$74f7d28a8dbbcb4fa496cc5dbb21c4c$$$.PrimitiveNodeSetFails.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.setter$2.apply((Object)this.$outer.context$2, (Object)BoxesRunTime.boxToLong((long)this.$outer.id$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.id$1 = id$1;
                this.context$2 = context$2;
                this.setter$2 = setter$2;
            }
        });
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetFails(Slot slot, long id) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveRelationshipInSlotFunctionFor(slot);
        AssertionUtils$.MODULE$.ifAssertionsEnabled((Function0)new Serializable(this, id, context, setter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;
            public final long id$2;
            public final SlottedExecutionContext context$3;
            public final Function2 setter$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SlottedPipeBuilderUtils$$$$148ee865eff084d392b1f635f3ed9$$$.eRelationshipSetFails.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.setter$3.apply((Object)this.$outer.context$3, (Object)BoxesRunTime.boxToLong((long)this.$outer.id$2));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.id$2 = id$2;
                this.context$3 = context$3;
                this.setter$3 = setter$3;
            }
        });
    }

    public SlottedPipeBuilderUtilsTest() {
        this.test("getter for non-nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable node slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for non-nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable relationship slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Slot slot = this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x");
                SlottedExecutionContext context = new SlottedExecutionContext(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
                Function1 getter = SlottedPipeBuilderUtils$.MODULE$.makeGetValueFromSlotFunctionFor(slot);
                TextValue expectedValue = Values.stringValue((String)"the value");
                context.setRefAt(slot.offset(), (AnyValue)expectedValue);
                AnyValue value = (AnyValue)getter.apply((Object)context);
                this.$outer.convertToAnyShouldWrapper(value).should(this.$outer.equal(expectedValue), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), (AnyValue)Values.NO_VALUE, -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), (AnyValue)Values.NO_VALUE, -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable node slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable relationship slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Slot slot = this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x");
                SlottedExecutionContext context = new SlottedExecutionContext(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
                Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
                TextValue expectedValue = Values.stringValue((String)"the value");
                setter.apply((Object)context, (Object)expectedValue);
                AnyValue value = context.getRefAt(slot.offset());
                this.$outer.convertToAnyShouldWrapper(value).should(this.$outer.equal(expectedValue), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for non-nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for nullable node slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for non-nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for nullable relationship slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for non-nullable node slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for non-nullable relationship slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetRef(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x"), 42L, (AnyValue)VirtualValues.node((long)42L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for nullable ref slot with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetRef(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for non-nullable ref slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("y"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetRef(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x"), 42L, (AnyValue)VirtualValues.relationship((long)42L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for nullable ref slot with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetRef(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for non-nullable ref slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("y"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

