/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted.pipes;

import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cypher.internal.runtime.QueryContext;
import org.neo4j.cypher.internal.runtime.slotted.pipes.PrimitiveCachingExpandInto;
import org.neo4j.cypher.internal.runtime.slotted.pipes.PrimitiveCachingExpandInto$;
import org.neo4j.cypher.internal.runtime.slotted.pipes.PrimitiveRelationshipsCache;
import org.neo4j.cypher.internal.util.v3_4.InternalException;
import org.neo4j.cypher.internal.v3_4.expressions.SemanticDirection;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.store.RelationshipIterator;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class PrimitiveCachingExpandInto$class {
    public static PrimitiveLongIterator findRelationships(PrimitiveCachingExpandInto $this, QueryContext query, long fromNode, long toNode, PrimitiveRelationshipsCache relCache, SemanticDirection dir, Function0 relTypes) {
        PrimitiveLongIterator primitiveLongIterator;
        boolean fromNodeIsDense = query.nodeIsDense(fromNode);
        boolean toNodeIsDense = query.nodeIsDense(toNode);
        if (fromNodeIsDense && toNodeIsDense) {
            int fromDegree = PrimitiveCachingExpandInto$class.getDegree($this, fromNode, (Option)relTypes.apply(), dir, query);
            if (fromDegree == 0) {
                return RelationshipIterator.EMPTY;
            }
            int toDegree = PrimitiveCachingExpandInto$class.getDegree($this, toNode, (Option)relTypes.apply(), dir.reversed(), query);
            if (toDegree == 0) {
                return RelationshipIterator.EMPTY;
            }
            primitiveLongIterator = PrimitiveCachingExpandInto$class.relIterator($this, query, fromNode, toNode, fromDegree < toDegree, (Option)relTypes.apply(), relCache, dir);
        } else {
            primitiveLongIterator = toNodeIsDense ? PrimitiveCachingExpandInto$class.relIterator($this, query, fromNode, toNode, true, (Option)relTypes.apply(), relCache, dir) : (fromNodeIsDense ? PrimitiveCachingExpandInto$class.relIterator($this, query, fromNode, toNode, false, (Option)relTypes.apply(), relCache, dir) : PrimitiveCachingExpandInto$class.relIterator($this, query, fromNode, toNode, PrimitiveCachingExpandInto$class.alternate($this), (Option)relTypes.apply(), relCache, dir));
        }
        return primitiveLongIterator;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean alternate(PrimitiveCachingExpandInto $this) {
        void var1_1;
        boolean result = !$this.org$neo4j$cypher$internal$runtime$slotted$pipes$PrimitiveCachingExpandInto$$alternateState();
        $this.org$neo4j$cypher$internal$runtime$slotted$pipes$PrimitiveCachingExpandInto$$alternateState_$eq(result);
        return (boolean)var1_1;
    }

    private static PrimitiveLongIterator relIterator(PrimitiveCachingExpandInto $this, QueryContext query, long fromNode, long toNode, boolean preserveDirection, Option relTypes, PrimitiveRelationshipsCache relCache, SemanticDirection dir) {
        Tuple3 tuple3;
        Tuple3 tuple32 = tuple3 = preserveDirection ? new Tuple3((Object)BoxesRunTime.boxToLong((long)fromNode), (Object)dir, (Object)BoxesRunTime.boxToLong((long)toNode)) : new Tuple3((Object)BoxesRunTime.boxToLong((long)toNode), (Object)dir.reversed(), (Object)BoxesRunTime.boxToLong((long)fromNode));
        if (tuple3 != null) {
            Tuple3 tuple33;
            long start = BoxesRunTime.unboxToLong((Object)tuple3._1());
            SemanticDirection localDirection = (SemanticDirection)tuple3._2();
            long end = BoxesRunTime.unboxToLong((Object)tuple3._3());
            Tuple3 tuple34 = tuple33 = new Tuple3((Object)BoxesRunTime.boxToLong((long)start), (Object)localDirection, (Object)BoxesRunTime.boxToLong((long)end));
            long start2 = BoxesRunTime.unboxToLong((Object)tuple34._1());
            SemanticDirection localDirection2 = (SemanticDirection)tuple34._2();
            long end2 = BoxesRunTime.unboxToLong((Object)tuple34._3());
            RelationshipIterator relationships = query.getRelationshipsForIdsPrimitive(start2, localDirection2, relTypes);
            ArrayBuilder connectedRelationships = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Long());
            BooleanRef connected = BooleanRef.create((boolean)false);
            RelationshipVisitor<InternalException> relVisitor = new RelationshipVisitor<InternalException>($this, start2, end2, connectedRelationships, connected){
                private final long start$1;
                private final long end$1;
                private final ArrayBuilder connectedRelationships$1;
                private final BooleanRef connected$1;

                public void visit(long relationshipId, int typeId, long startNodeId, long endNodeId) {
                    if (this.end$1 == startNodeId && this.start$1 == endNodeId || this.start$1 == startNodeId && this.end$1 == endNodeId) {
                        this.connectedRelationships$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)relationshipId));
                        this.connected$1.elem = true;
                    }
                }
                {
                    this.start$1 = start$1;
                    this.end$1 = end$1;
                    this.connectedRelationships$1 = connectedRelationships$1;
                    this.connected$1 = connected$1;
                }
            };
            return new PrimitiveLongIterator($this, fromNode, toNode, relCache, dir, relationships, connectedRelationships, connected, (RelationshipVisitor)relVisitor){
                private long nextRelId;
                private boolean consumed;
                private final long fromNode$1;
                private final long toNode$1;
                private final PrimitiveRelationshipsCache relCache$1;
                private final SemanticDirection dir$1;
                private final RelationshipIterator relationships$1;
                private final ArrayBuilder connectedRelationships$1;
                private final BooleanRef connected$1;
                private final RelationshipVisitor relVisitor$1;

                private long nextRelId() {
                    return this.nextRelId;
                }

                private void nextRelId_$eq(long x$1) {
                    this.nextRelId = x$1;
                }

                private boolean consumed() {
                    return this.consumed;
                }

                private void consumed_$eq(boolean x$1) {
                    this.consumed = x$1;
                }

                public long next() {
                    this.consumed_$eq(true);
                    return this.nextRelId();
                }

                public boolean hasNext() {
                    return !this.consumed() || this.computeNext();
                }

                private boolean computeNext() {
                    this.connected$1.elem = false;
                    while (this.relationships$1.hasNext() && !this.connected$1.elem) {
                        this.nextRelId_$eq(this.relationships$1.next());
                        this.relationships$1.relationshipVisit(this.nextRelId(), this.relVisitor$1);
                    }
                    Object object = this.relationships$1.hasNext() ? BoxedUnit.UNIT : this.relCache$1.put(this.fromNode$1, this.toNode$1, (long[])this.connectedRelationships$1.result(), this.dir$1);
                    this.consumed_$eq(!this.connected$1.elem);
                    return this.connected$1.elem;
                }
                {
                    this.fromNode$1 = fromNode$1;
                    this.toNode$1 = toNode$1;
                    this.relCache$1 = relCache$1;
                    this.dir$1 = dir$1;
                    this.relationships$1 = relationships$1;
                    this.connectedRelationships$1 = connectedRelationships$1;
                    this.connected$1 = connected$1;
                    this.relVisitor$1 = relVisitor$1;
                    this.nextRelId = -1L;
                    this.consumed = true;
                }
            };
        }
        throw new MatchError((Object)tuple3);
    }

    private static int getDegree(PrimitiveCachingExpandInto $this, long node, Option relTypes, SemanticDirection direction, QueryContext query) {
        return BoxesRunTime.unboxToInt((Object)relTypes.map((Function1)new Serializable($this, node, direction, query){
            public static final long serialVersionUID = 0L;
            public final long node$1;
            public final SemanticDirection direction$1;
            public final QueryContext query$1;

            public final int apply(int[] x0$1) {
                int[] nArray = x0$1;
                int n = Predef$.MODULE$.intArrayOps(nArray).isEmpty() ? this.query$1.nodeGetDegree(this.node$1, this.direction$1) : (nArray.length == 1 ? this.query$1.nodeGetDegree(this.node$1, this.direction$1, BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(nArray).head())) : BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(nArray).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ PrimitiveCachingExpandInto$.anonfun.getDegree.2 $outer;

                    public final int apply(int acc, int rel) {
                        return this.apply$mcIII$sp(acc, rel);
                    }

                    public int apply$mcIII$sp(int acc, int rel) {
                        return acc + this.$outer.query$1.nodeGetDegree(this.$outer.node$1, this.$outer.direction$1, rel);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })));
                return n;
            }
            {
                this.node$1 = node$1;
                this.direction$1 = direction$1;
                this.query$1 = query$1;
            }
        }).getOrElse((Function0)new Serializable($this, node, direction, query){
            public static final long serialVersionUID = 0L;
            private final long node$1;
            private final SemanticDirection direction$1;
            private final QueryContext query$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.query$1.nodeGetDegree(this.node$1, this.direction$1);
            }
            {
                this.node$1 = node$1;
                this.direction$1 = direction$1;
                this.query$1 = query$1;
            }
        }));
    }

    public static void $init$(PrimitiveCachingExpandInto $this) {
        $this.org$neo4j$cypher$internal$runtime$slotted$pipes$PrimitiveCachingExpandInto$$alternateState_$eq(false);
    }
}

