/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted.helpers;

import org.neo4j.cypher.internal.compatibility.v3_4.runtime.Slot;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.SlotConfiguration;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.SlotConfiguration$;
import org.neo4j.cypher.internal.runtime.slotted.SlottedExecutionContext;
import org.neo4j.cypher.internal.runtime.slotted.helpers.SlottedPipeBuilderUtils$;
import org.neo4j.cypher.internal.runtime.slotted.helpers.SlottedPipeBuilderUtils$$$$148ee865eff084d392b1f635f3ed9$$$;
import org.neo4j.cypher.internal.runtime.slotted.helpers.SlottedPipeBuilderUtils$$$$74f7d28a8dbbcb4fa496cc5dbb21c4c$$$;
import org.neo4j.cypher.internal.util.v3_4.AssertionUtils$;
import org.neo4j.cypher.internal.util.v3_4.ParameterWrongTypeException;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.package$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001E\u00111d\u00157piR,G\rU5qK\n+\u0018\u000e\u001c3feV#\u0018\u000e\\:UKN$(BA\u0002\u0005\u0003\u001dAW\r\u001c9feNT!!\u0002\u0004\u0002\u000fMdw\u000e\u001e;fI*\u0011q\u0001C\u0001\beVtG/[7f\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0003\u0001I\u0001\"a\u0005\u000e\u000e\u0003QQ!!\u0006\f\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005]A\u0012\u0001\u0002<4?RR!!\u0007\u0005\u0002\tU$\u0018\u000e\\\u0005\u00037Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0005!9!\u0005\u0001b\u0001\n\u0013\u0019\u0013!B:m_R\u001cX#\u0001\u0013\u0011\u0005\u0015RS\"\u0001\u0014\u000b\u0005\u001d9#BA\f)\u0015\tI\u0003\"A\u0007d_6\u0004\u0018\r^5cS2LG/_\u0005\u0003W\u0019\u0012\u0011c\u00157pi\u000e{gNZ5hkJ\fG/[8o\u0011\u0019i\u0003\u0001)A\u0005I\u000511\u000f\\8ug\u0002BQa\f\u0001\u0005\nA\nQ\"Y:tKJ$x)\u001a;M_:<G\u0003B\u00198y\u0005\u0003\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u0012A!\u00168ji\")\u0001H\fa\u0001s\u0005!1\u000f\\8u!\t)#(\u0003\u0002<M\t!1\u000b\\8u\u0011\u0015id\u00061\u0001?\u0003%awN\\4WC2,X\r\u0005\u00023\u007f%\u0011\u0001i\r\u0002\u0005\u0019>tw\rC\u0003C]\u0001\u00071)A\u0007fqB,7\r^3e-\u0006dW/\u001a\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r2\taA^1mk\u0016\u001c\u0018B\u0001%F\u0005!\te.\u001f,bYV,\u0007\"\u0002&\u0001\t\u0013Y\u0015!D1tg\u0016\u0014HoR3u\u001d>$W\rF\u00022\u00196CQ\u0001O%A\u0002eBQAT%A\u0002y\n!!\u001b3\t\u000bA\u0003A\u0011B)\u0002+\u0005\u001c8/\u001a:u\u000f\u0016$(+\u001a7bi&|gn\u001d5jaR\u0019\u0011GU*\t\u000baz\u0005\u0019A\u001d\t\u000b9{\u0005\u0019\u0001 \t\u000bU\u0003A\u0011\u0002,\u0002\u001b\u0005\u001c8/\u001a:u'\u0016$Hj\u001c8h)\u0011\tt\u000b\u0017.\t\u000ba\"\u0006\u0019A\u001d\t\u000be#\u0006\u0019A\"\u0002\u000bY\fG.^3\t\u000bm#\u0006\u0019\u0001 \u0002\u0011\u0015D\b/Z2uK\u0012DQ!\u0018\u0001\u0005\ny\u000bQ\"Y:tKJ$8+\u001a;O_\u0012,GcA\u0019`A\")\u0001\b\u0018a\u0001s!)a\n\u0018a\u0001}!)!\r\u0001C\u0005G\u0006)\u0012m]:feR\u001cV\r\u001e*fY\u0006$\u0018n\u001c8tQ&\u0004HcA\u0019eK\")\u0001(\u0019a\u0001s!)a*\u0019a\u0001}!)q\r\u0001C\u0005Q\u0006q\u0011m]:feR\u001cV\r\u001e$bS2\u001cHcA\u0019jU\")\u0001H\u001aa\u0001s!)\u0011L\u001aa\u0001\u0007\")A\u000e\u0001C\u0005[\u0006Q\u0012m]:feR\u0004&/[7ji&4XMT8eKN+G\u000fT8oOR\u0019\u0011G\\8\t\u000baZ\u0007\u0019A\u001d\t\u000b9[\u0007\u0019\u0001 \t\u000bE\u0004A\u0011\u0002:\u0002E\u0005\u001c8/\u001a:u!JLW.\u001b;jm\u0016\u0014V\r\\1uS>t7\u000f[5q'\u0016$Hj\u001c8h)\r\t4\u000f\u001e\u0005\u0006qA\u0004\r!\u000f\u0005\u0006\u001dB\u0004\rA\u0010\u0005\u0006m\u0002!Ia^\u0001\u001aCN\u001cXM\u001d;Qe&l\u0017\u000e^5wK:{G-Z*fiJ+g\r\u0006\u00032qfT\b\"\u0002\u001dv\u0001\u0004I\u0004\"\u0002(v\u0001\u0004q\u0004\"B.v\u0001\u0004\u0019\u0005\"\u0002?\u0001\t\u0013i\u0018!I1tg\u0016\u0014H\u000f\u0015:j[&$\u0018N^3SK2\fG/[8og\"L\u0007oU3u%\u00164G#B\u0019\u007f\u007f\u0006\u0005\u0001\"\u0002\u001d|\u0001\u0004I\u0004\"\u0002(|\u0001\u0004q\u0004\"B.|\u0001\u0004\u0019\u0005bBA\u0003\u0001\u0011%\u0011qA\u0001\u001cCN\u001cXM\u001d;Qe&l\u0017\u000e^5wK:{G-Z*fi\u001a\u000b\u0017\u000e\\:\u0015\u000bE\nI!a\u0003\t\ra\n\u0019\u00011\u0001:\u0011\u0019q\u00151\u0001a\u0001}!9\u0011q\u0002\u0001\u0005\n\u0005E\u0011aI1tg\u0016\u0014H\u000f\u0015:j[&$\u0018N^3SK2\fG/[8og\"L\u0007oU3u\r\u0006LGn\u001d\u000b\u0006c\u0005M\u0011Q\u0003\u0005\u0007q\u00055\u0001\u0019A\u001d\t\r9\u000bi\u00011\u0001?\u0001")
public class SlottedPipeBuilderUtilsTest
extends CypherFunSuite {
    private final SlotConfiguration org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots = SlotConfiguration$.MODULE$.empty().newLong("n1", false, (CypherType)package$.MODULE$.CTNode()).newLong("n2", true, (CypherType)package$.MODULE$.CTNode()).newLong("r1", false, (CypherType)package$.MODULE$.CTRelationship()).newLong("r2", true, (CypherType)package$.MODULE$.CTRelationship()).newReference("x", true, (CypherType)package$.MODULE$.CTAny()).newReference("y", false, (CypherType)package$.MODULE$.CTAny());

    public SlotConfiguration org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots() {
        return this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots;
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(Slot slot, long longValue, AnyValue expectedValue) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function1 getter = SlottedPipeBuilderUtils$.MODULE$.makeGetValueFromSlotFunctionFor(slot);
        context.setLongAt(slot.offset(), longValue);
        AnyValue value = (AnyValue)getter.apply((Object)context);
        this.convertToAnyShouldWrapper(value).should(this.equal(expectedValue), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(slot, id, (AnyValue)VirtualValues.node((long)id));
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(slot, id, (AnyValue)VirtualValues.relationship((long)id));
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(Slot slot, AnyValue value, long expected) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
        setter.apply((Object)context, (Object)value);
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)context.getLongAt(slot.offset()))).should(this.equal(BoxesRunTime.boxToLong((long)expected)), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(slot, (AnyValue)VirtualValues.node((long)id), id);
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(slot, (AnyValue)VirtualValues.relationship((long)id), id);
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(Slot slot, AnyValue value) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
        this.a(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)).should(this.be()).thrownBy((Function0)new Serializable(this, value, context, setter){
            public static final long serialVersionUID = 0L;
            private final AnyValue value$1;
            private final SlottedExecutionContext context$1;
            private final Function2 setter$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.setter$1.apply((Object)this.context$1, (Object)this.value$1);
            }
            {
                this.value$1 = value$1;
                this.context$1 = context$1;
                this.setter$1 = setter$1;
            }
        });
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetLong(Slot slot, long id) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 primitiveNodeSetter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveNodeInSlotFunctionFor(slot);
        primitiveNodeSetter.apply((Object)context, (Object)BoxesRunTime.boxToLong((long)id));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)context.getLongAt(slot.offset()))).should(this.equal(BoxesRunTime.boxToLong((long)id)), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetLong(Slot slot, long id) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 primitiveRelationshipSetter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveRelationshipInSlotFunctionFor(slot);
        primitiveRelationshipSetter.apply((Object)context, (Object)BoxesRunTime.boxToLong((long)id));
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)context.getLongAt(slot.offset()))).should(this.equal(BoxesRunTime.boxToLong((long)id)), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetRef(Slot slot, long id, AnyValue expected) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 primitiveNodeSetter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveNodeInSlotFunctionFor(slot);
        primitiveNodeSetter.apply((Object)context, (Object)BoxesRunTime.boxToLong((long)id));
        this.convertToAnyShouldWrapper(context.getRefAt(slot.offset())).should(this.equal(expected), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetRef(Slot slot, long id, AnyValue expected) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 primitiveRelationshipSetter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveRelationshipInSlotFunctionFor(slot);
        primitiveRelationshipSetter.apply((Object)context, (Object)BoxesRunTime.boxToLong((long)id));
        this.convertToAnyShouldWrapper(context.getRefAt(slot.offset())).should(this.equal(expected), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetFails(Slot slot, long id) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveNodeInSlotFunctionFor(slot);
        AssertionUtils$.MODULE$.ifAssertionsEnabled((Function0)new Serializable(this, id, context, setter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;
            public final long id$1;
            public final SlottedExecutionContext context$2;
            public final Function2 setter$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SlottedPipeBuilderUtils$$$$74f7d28a8dbbcb4fa496cc5dbb21c4c$$$.PrimitiveNodeSetFails.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.setter$2.apply((Object)this.$outer.context$2, (Object)BoxesRunTime.boxToLong((long)this.$outer.id$1));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.id$1 = id$1;
                this.context$2 = context$2;
                this.setter$2 = setter$2;
            }
        });
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetFails(Slot slot, long id) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetPrimitiveRelationshipInSlotFunctionFor(slot);
        AssertionUtils$.MODULE$.ifAssertionsEnabled((Function0)new Serializable(this, id, context, setter){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;
            public final long id$2;
            public final SlottedExecutionContext context$3;
            public final Function2 setter$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SlottedPipeBuilderUtils$$$$148ee865eff084d392b1f635f3ed9$$$.eRelationshipSetFails.1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.setter$3.apply((Object)this.$outer.context$3, (Object)BoxesRunTime.boxToLong((long)this.$outer.id$2));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.id$2 = id$2;
                this.context$3 = context$3;
                this.setter$3 = setter$3;
            }
        });
    }

    public SlottedPipeBuilderUtilsTest() {
        this.test("getter for non-nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable node slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for non-nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable relationship slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Slot slot = this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x");
                SlottedExecutionContext context = new SlottedExecutionContext(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
                Function1 getter = SlottedPipeBuilderUtils$.MODULE$.makeGetValueFromSlotFunctionFor(slot);
                TextValue expectedValue = Values.stringValue((String)"the value");
                context.setRefAt(slot.offset(), (AnyValue)expectedValue);
                AnyValue value = (AnyValue)getter.apply((Object)context);
                this.$outer.convertToAnyShouldWrapper(value).should(this.$outer.equal(expectedValue), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), (AnyValue)Values.NO_VALUE, -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), (AnyValue)Values.NO_VALUE, -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable node slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable relationship slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Slot slot = this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x");
                SlottedExecutionContext context = new SlottedExecutionContext(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
                Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
                TextValue expectedValue = Values.stringValue((String)"the value");
                setter.apply((Object)context, (Object)expectedValue);
                AnyValue value = context.getRefAt(slot.offset());
                this.$outer.convertToAnyShouldWrapper(value).should(this.$outer.equal(expectedValue), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for non-nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for nullable node slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for non-nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for nullable relationship slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for non-nullable node slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for non-nullable relationship slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetRef(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x"), 42L, (AnyValue)VirtualValues.node((long)42L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for nullable ref slot with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetRef(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive node setter for non-nullable ref slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveNodeSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("y"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetRef(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x"), 42L, (AnyValue)VirtualValues.relationship((long)42L));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for nullable ref slot with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetRef(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("primitive relationship setter for non-nullable ref slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertPrimitiveRelationshipSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("y"), -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

