/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted.pipes;

import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.SlotConfiguration;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.SlotConfiguration$;
import org.neo4j.cypher.internal.runtime.interpreted.ExecutionContext;
import org.neo4j.cypher.internal.runtime.interpreted.QueryStateHelper$;
import org.neo4j.cypher.internal.runtime.interpreted.commands.expressions.Expression;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.Pipe;
import org.neo4j.cypher.internal.runtime.interpreted.pipes.QueryState;
import org.neo4j.cypher.internal.runtime.slotted.expressions.ReferenceFromSlot;
import org.neo4j.cypher.internal.runtime.slotted.pipes.HashJoinSlottedPipeTestHelper;
import org.neo4j.cypher.internal.runtime.slotted.pipes.HashJoinSlottedPipeTestHelper$;
import org.neo4j.cypher.internal.runtime.slotted.pipes.ValueHashJoinSlottedPipe;
import org.neo4j.cypher.internal.runtime.slotted.pipes.ValueHashJoinSlottedPipe$;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.package$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00052A!\u0001\u0002\u0001#\tab+\u00197vK\"\u000b7\u000f\u001b&pS:\u001cFn\u001c;uK\u0012\u0004\u0016\u000e]3UKN$(BA\u0002\u0005\u0003\u0015\u0001\u0018\u000e]3t\u0015\t)a!A\u0004tY>$H/\u001a3\u000b\u0005\u001dA\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019\"$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u00181\u0005!aoM05\u0015\tI\u0002\"\u0001\u0003vi&d\u0017BA\u000e\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtD#A\u0010\u0011\u0005\u0001\u0002Q\"\u0001\u0002")
public class ValueHashJoinSlottedPipeTest
extends CypherFunSuite {
    public ValueHashJoinSlottedPipeTest() {
        this.test("should support simple hash join between two identifiers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValueHashJoinSlottedPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                SlotConfiguration slotInfoForInputs = SlotConfiguration$.MODULE$.empty().newReference("b", false, (CypherType)package$.MODULE$.CTInteger());
                SlotConfiguration slotInfoForJoin = SlotConfiguration$.MODULE$.empty().newReference("a", false, (CypherType)package$.MODULE$.CTInteger()).newReference("b", false, (CypherType)package$.MODULE$.CTInteger());
                Pipe left = HashJoinSlottedPipeTestHelper$.MODULE$.mockPipeFor(slotInfoForInputs, (Seq<HashJoinSlottedPipeTestHelper.Row>)Predef$.MODULE$.wrapRefArray((Object[])new HashJoinSlottedPipeTestHelper.Row[]{new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)1)})), new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)2)})), new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.NO_VALUE}))}));
                Pipe right = HashJoinSlottedPipeTestHelper$.MODULE$.mockPipeFor(slotInfoForInputs, (Seq<HashJoinSlottedPipeTestHelper.Row>)Predef$.MODULE$.wrapRefArray((Object[])new HashJoinSlottedPipeTestHelper.Row[]{new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)2)})), new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)3)})), new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.NO_VALUE}))}));
                ReferenceFromSlot x$1 = new ReferenceFromSlot(0);
                ReferenceFromSlot x$2 = new ReferenceFromSlot(0);
                Pipe x$3 = left;
                Pipe x$4 = right;
                SlotConfiguration x$5 = slotInfoForJoin;
                int x$6 = 0;
                int x$7 = 1;
                SlotConfiguration.Size x$8 = SlotConfiguration.Size$.MODULE$.zero();
                int x$9 = ValueHashJoinSlottedPipe$.MODULE$.apply$default$9((Expression)x$1, (Expression)x$2, x$3, x$4, x$5, x$6, x$7, x$8);
                ValueHashJoinSlottedPipe pipe = new ValueHashJoinSlottedPipe((Expression)x$1, (Expression)x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9);
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(HashJoinSlottedPipeTestHelper$.MODULE$.testableResult((Iterator<ExecutionContext>)result, slotInfoForJoin)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Values.intValue((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)Values.intValue((int)2))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle multiples from both sides", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValueHashJoinSlottedPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                SlotConfiguration slotInfoForInputs = SlotConfiguration$.MODULE$.empty().newReference("a", false, (CypherType)package$.MODULE$.CTInteger()).newReference("b", false, (CypherType)package$.MODULE$.CTInteger());
                SlotConfiguration slotInfoForJoin = SlotConfiguration$.MODULE$.empty().newReference("a", false, (CypherType)package$.MODULE$.CTInteger()).newReference("b", false, (CypherType)package$.MODULE$.CTInteger()).newReference("c", false, (CypherType)package$.MODULE$.CTInteger()).newReference("d", false, (CypherType)package$.MODULE$.CTInteger());
                Pipe left = HashJoinSlottedPipeTestHelper$.MODULE$.mockPipeFor(slotInfoForInputs, (Seq<HashJoinSlottedPipeTestHelper.Row>)Predef$.MODULE$.wrapRefArray((Object[])new HashJoinSlottedPipeTestHelper.Row[]{new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)1), Values.stringValue((String)"a")})), new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)1), Values.stringValue((String)"b")})), new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)2), Values.stringValue((String)"c")})), new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)3), Values.stringValue((String)"d")}))}));
                Pipe right = HashJoinSlottedPipeTestHelper$.MODULE$.mockPipeFor(slotInfoForInputs, (Seq<HashJoinSlottedPipeTestHelper.Row>)Predef$.MODULE$.wrapRefArray((Object[])new HashJoinSlottedPipeTestHelper.Row[]{new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)1), Values.stringValue((String)"e")})), new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)2), Values.stringValue((String)"f")})), new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)2), Values.stringValue((String)"g")})), new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)4), Values.stringValue((String)"h")}))}));
                ReferenceFromSlot x$10 = new ReferenceFromSlot(0);
                ReferenceFromSlot x$11 = new ReferenceFromSlot(0);
                Pipe x$12 = left;
                Pipe x$13 = right;
                SlotConfiguration x$14 = slotInfoForJoin;
                int x$15 = 0;
                int x$16 = 2;
                SlotConfiguration.Size x$17 = SlotConfiguration.Size$.MODULE$.zero();
                int x$18 = ValueHashJoinSlottedPipe$.MODULE$.apply$default$9((Expression)x$10, (Expression)x$11, x$12, x$13, x$14, x$15, x$16, x$17);
                ValueHashJoinSlottedPipe pipe = new ValueHashJoinSlottedPipe((Expression)x$10, (Expression)x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18);
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(HashJoinSlottedPipeTestHelper$.MODULE$.testableResult((Iterator<ExecutionContext>)result, slotInfoForJoin)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Values.intValue((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)Values.stringValue((String)"a")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Values.intValue((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)Values.stringValue((String)"e"))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Values.intValue((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)Values.stringValue((String)"b")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Values.intValue((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)Values.stringValue((String)"e"))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Values.intValue((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)Values.stringValue((String)"c")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Values.intValue((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)Values.stringValue((String)"f"))})), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Values.intValue((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)Values.stringValue((String)"c")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"c"), (Object)Values.intValue((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"d"), (Object)Values.stringValue((String)"g"))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not fetch results from RHS if LHS is empty", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValueHashJoinSlottedPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                SlotConfiguration slotInfo = SlotConfiguration$.MODULE$.empty();
                slotInfo.newLong("a", false, (CypherType)package$.MODULE$.CTNode());
                Pipe left = HashJoinSlottedPipeTestHelper$.MODULE$.mockPipeFor(slotInfo, (Seq<HashJoinSlottedPipeTestHelper.Row>)Predef$.MODULE$.wrapRefArray((Object[])new HashJoinSlottedPipeTestHelper.Row[0]));
                Pipe right = (Pipe)this.$outer.mock(ManifestFactory$.MODULE$.classType(Pipe.class));
                ReferenceFromSlot x$19 = new ReferenceFromSlot(0);
                ReferenceFromSlot x$20 = new ReferenceFromSlot(0);
                Pipe x$21 = left;
                Pipe x$22 = right;
                SlotConfiguration x$23 = slotInfo;
                int x$24 = 0;
                int x$25 = 1;
                SlotConfiguration.Size x$26 = SlotConfiguration.Size$.MODULE$.zero();
                int x$27 = ValueHashJoinSlottedPipe$.MODULE$.apply$default$9((Expression)x$19, (Expression)x$20, x$21, x$22, x$23, x$24, x$25, x$26);
                ValueHashJoinSlottedPipe pipe = new ValueHashJoinSlottedPipe((Expression)x$19, (Expression)x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27);
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.be().apply(this.$outer.empty()), (Object)Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                Mockito.verifyZeroInteractions((Object[])new Object[]{right});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not fetch results from RHS if LHS did not contain any nodes that can be hashed against", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValueHashJoinSlottedPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                SlotConfiguration slotInfo = SlotConfiguration$.MODULE$.empty();
                slotInfo.newReference("a", false, (CypherType)package$.MODULE$.CTNode());
                Pipe left = HashJoinSlottedPipeTestHelper$.MODULE$.mockPipeFor(slotInfo, (Seq<HashJoinSlottedPipeTestHelper.Row>)Predef$.MODULE$.wrapRefArray((Object[])new HashJoinSlottedPipeTestHelper.Row[]{new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.NO_VALUE}))}));
                Pipe right = HashJoinSlottedPipeTestHelper$.MODULE$.mockPipeFor(slotInfo, (Seq<HashJoinSlottedPipeTestHelper.Row>)Predef$.MODULE$.wrapRefArray((Object[])new HashJoinSlottedPipeTestHelper.Row[]{new HashJoinSlottedPipeTestHelper.RowR((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)42)}))}));
                ReferenceFromSlot x$28 = new ReferenceFromSlot(0);
                ReferenceFromSlot x$29 = new ReferenceFromSlot(0);
                Pipe x$30 = left;
                Pipe x$31 = right;
                SlotConfiguration x$32 = slotInfo;
                int x$33 = 0;
                int x$34 = 1;
                SlotConfiguration.Size x$35 = SlotConfiguration.Size$.MODULE$.zero();
                int x$36 = ValueHashJoinSlottedPipe$.MODULE$.apply$default$9((Expression)x$28, (Expression)x$29, x$30, x$31, x$32, x$33, x$34, x$35);
                ValueHashJoinSlottedPipe pipe = new ValueHashJoinSlottedPipe((Expression)x$28, (Expression)x$29, x$30, x$31, x$32, x$33, x$34, x$35, x$36);
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.be().apply(this.$outer.empty()), (Object)Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                ((Pipe)Mockito.verify((Object)right, (VerificationMode)Mockito.times((int)1))).createResults((QueryState)ArgumentMatchers.any());
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{right});
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should support hash join between two identifiers with shared arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ValueHashJoinSlottedPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                SlotConfiguration slotInfoForInputs = SlotConfiguration$.MODULE$.empty().newLong("arg1", false, (CypherType)package$.MODULE$.CTNode()).newReference("arg2", false, (CypherType)package$.MODULE$.CTInteger()).newReference("b", false, (CypherType)package$.MODULE$.CTInteger());
                SlotConfiguration slotInfoForJoin = SlotConfiguration$.MODULE$.empty().newLong("arg1", false, (CypherType)package$.MODULE$.CTNode()).newReference("arg2", false, (CypherType)package$.MODULE$.CTInteger()).newReference("a", false, (CypherType)package$.MODULE$.CTInteger()).newReference("b", false, (CypherType)package$.MODULE$.CTInteger());
                Pipe left = HashJoinSlottedPipeTestHelper$.MODULE$.mockPipeFor(slotInfoForInputs, (Seq<HashJoinSlottedPipeTestHelper.Row>)Predef$.MODULE$.wrapRefArray((Object[])new HashJoinSlottedPipeTestHelper.Row[]{new HashJoinSlottedPipeTestHelper.RowRL(new HashJoinSlottedPipeTestHelper.Longs((Seq<Object>)Predef$.MODULE$.wrapLongArray(new long[]{42L})), new HashJoinSlottedPipeTestHelper.Refs((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)666), Values.intValue((int)1)}))), new HashJoinSlottedPipeTestHelper.RowRL(new HashJoinSlottedPipeTestHelper.Longs((Seq<Object>)Predef$.MODULE$.wrapLongArray(new long[]{42L})), new HashJoinSlottedPipeTestHelper.Refs((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)666), Values.intValue((int)2)}))), new HashJoinSlottedPipeTestHelper.RowRL(new HashJoinSlottedPipeTestHelper.Longs((Seq<Object>)Predef$.MODULE$.wrapLongArray(new long[]{42L})), new HashJoinSlottedPipeTestHelper.Refs((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)666), Values.NO_VALUE})))}));
                Pipe right = HashJoinSlottedPipeTestHelper$.MODULE$.mockPipeFor(slotInfoForInputs, (Seq<HashJoinSlottedPipeTestHelper.Row>)Predef$.MODULE$.wrapRefArray((Object[])new HashJoinSlottedPipeTestHelper.Row[]{new HashJoinSlottedPipeTestHelper.RowRL(new HashJoinSlottedPipeTestHelper.Longs((Seq<Object>)Predef$.MODULE$.wrapLongArray(new long[]{42L})), new HashJoinSlottedPipeTestHelper.Refs((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)666), Values.intValue((int)2)}))), new HashJoinSlottedPipeTestHelper.RowRL(new HashJoinSlottedPipeTestHelper.Longs((Seq<Object>)Predef$.MODULE$.wrapLongArray(new long[]{42L})), new HashJoinSlottedPipeTestHelper.Refs((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)666), Values.intValue((int)3)}))), new HashJoinSlottedPipeTestHelper.RowRL(new HashJoinSlottedPipeTestHelper.Longs((Seq<Object>)Predef$.MODULE$.wrapLongArray(new long[]{42L})), new HashJoinSlottedPipeTestHelper.Refs((Seq<AnyValue>)Predef$.MODULE$.wrapRefArray((Object[])new AnyValue[]{Values.intValue((int)666), Values.NO_VALUE})))}));
                ReferenceFromSlot x$37 = new ReferenceFromSlot(1);
                ReferenceFromSlot x$38 = new ReferenceFromSlot(1);
                Pipe x$39 = left;
                Pipe x$40 = right;
                SlotConfiguration x$41 = slotInfoForJoin;
                int x$42 = 1;
                int x$43 = 2;
                SlotConfiguration.Size x$44 = new SlotConfiguration.Size(1, 1);
                int x$45 = ValueHashJoinSlottedPipe$.MODULE$.apply$default$9((Expression)x$37, (Expression)x$38, x$39, x$40, x$41, x$42, x$43, x$44);
                ValueHashJoinSlottedPipe pipe = new ValueHashJoinSlottedPipe((Expression)x$37, (Expression)x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45);
                Iterator result = pipe.createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(HashJoinSlottedPipeTestHelper$.MODULE$.testableResult((Iterator<ExecutionContext>)result, slotInfoForJoin)).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"arg1"), (Object)BoxesRunTime.boxToLong((long)42L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"arg2"), (Object)Values.intValue((int)666)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)Values.intValue((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)Values.intValue((int)2))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

