/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted.helpers;

import org.neo4j.cypher.internal.compatibility.v3_4.runtime.Slot;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.SlotConfiguration;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.SlotConfiguration$;
import org.neo4j.cypher.internal.runtime.slotted.SlottedExecutionContext;
import org.neo4j.cypher.internal.runtime.slotted.helpers.SlottedPipeBuilderUtils$;
import org.neo4j.cypher.internal.util.v3_4.ParameterWrongTypeException;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.package$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001#\tY2\u000b\\8ui\u0016$\u0007+\u001b9f\u0005VLG\u000eZ3s+RLGn\u001d+fgRT!a\u0001\u0003\u0002\u000f!,G\u000e]3sg*\u0011QAB\u0001\bg2|G\u000f^3e\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CG\u0007\u0002))\u0011QCF\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003/a\tAA^\u001a`i)\u0011\u0011\u0004C\u0001\u0005kRLG.\u0003\u0002\u001c)\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0003\u0011\u001d\u0011\u0003A1A\u0005\n\r\nQa\u001d7piN,\u0012\u0001\n\t\u0003K)j\u0011A\n\u0006\u0003\u000f\u001dR!a\u0006\u0015\u000b\u0005%B\u0011!D2p[B\fG/\u001b2jY&$\u00180\u0003\u0002,M\t\t2\u000b\\8u\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\r5\u0002\u0001\u0015!\u0003%\u0003\u0019\u0019Hn\u001c;tA!)q\u0006\u0001C\u0005a\u0005i\u0011m]:feR<U\r\u001e'p]\u001e$B!M\u001c=\u0003B\u0011!'N\u0007\u0002g)\tA'A\u0003tG\u0006d\u0017-\u0003\u00027g\t!QK\\5u\u0011\u0015Ad\u00061\u0001:\u0003\u0011\u0019Hn\u001c;\u0011\u0005\u0015R\u0014BA\u001e'\u0005\u0011\u0019Fn\u001c;\t\u000bur\u0003\u0019\u0001 \u0002\u00131|gn\u001a,bYV,\u0007C\u0001\u001a@\u0013\t\u00015G\u0001\u0003M_:<\u0007\"\u0002\"/\u0001\u0004\u0019\u0015!D3ya\u0016\u001cG/\u001a3WC2,X\r\u0005\u0002E\u000f6\tQI\u0003\u0002G\u0019\u00051a/\u00197vKNL!\u0001S#\u0003\u0011\u0005s\u0017PV1mk\u0016DQA\u0013\u0001\u0005\n-\u000bQ\"Y:tKJ$x)\u001a;O_\u0012,GcA\u0019M\u001b\")\u0001(\u0013a\u0001s!)a*\u0013a\u0001}\u0005\u0011\u0011\u000e\u001a\u0005\u0006!\u0002!I!U\u0001\u0016CN\u001cXM\u001d;HKR\u0014V\r\\1uS>t7\u000f[5q)\r\t$k\u0015\u0005\u0006q=\u0003\r!\u000f\u0005\u0006\u001d>\u0003\rA\u0010\u0005\u0006+\u0002!IAV\u0001\u000eCN\u001cXM\u001d;TKRduN\\4\u0015\tE:\u0006L\u0017\u0005\u0006qQ\u0003\r!\u000f\u0005\u00063R\u0003\raQ\u0001\u0006m\u0006dW/\u001a\u0005\u00067R\u0003\rAP\u0001\tKb\u0004Xm\u0019;fI\")Q\f\u0001C\u0005=\u0006i\u0011m]:feR\u001cV\r\u001e(pI\u0016$2!M0a\u0011\u0015AD\f1\u0001:\u0011\u0015qE\f1\u0001?\u0011\u0015\u0011\u0007\u0001\"\u0003d\u0003U\t7o]3siN+GOU3mCRLwN\\:iSB$2!\r3f\u0011\u0015A\u0014\r1\u0001:\u0011\u0015q\u0015\r1\u0001?\u0011\u00159\u0007\u0001\"\u0003i\u00039\t7o]3siN+GOR1jYN$2!M5k\u0011\u0015Ad\r1\u0001:\u0011\u0015If\r1\u0001D\u0001")
public class SlottedPipeBuilderUtilsTest
extends CypherFunSuite {
    private final SlotConfiguration org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots = SlotConfiguration$.MODULE$.empty().newLong("n1", false, (CypherType)package$.MODULE$.CTNode()).newLong("n2", true, (CypherType)package$.MODULE$.CTNode()).newLong("r1", false, (CypherType)package$.MODULE$.CTRelationship()).newLong("r2", true, (CypherType)package$.MODULE$.CTRelationship()).newReference("x", true, (CypherType)package$.MODULE$.CTAny());

    public SlotConfiguration org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots() {
        return this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots;
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(Slot slot, long longValue, AnyValue expectedValue) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function1 getter = SlottedPipeBuilderUtils$.MODULE$.makeGetValueFromSlotFunctionFor(slot);
        context.setLongAt(slot.offset(), longValue);
        AnyValue value = (AnyValue)getter.apply((Object)context);
        this.convertToAnyShouldWrapper(value).should(this.equal(expectedValue), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(slot, id, (AnyValue)VirtualValues.node((long)id));
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(slot, id, (AnyValue)VirtualValues.relationship((long)id));
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(Slot slot, AnyValue value, long expected) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
        setter.apply((Object)context, (Object)value);
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)context.getLongAt(slot.offset()))).should(this.equal(BoxesRunTime.boxToLong((long)expected)), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(slot, (AnyValue)VirtualValues.node((long)id), id);
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(Slot slot, long id) {
        this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(slot, (AnyValue)VirtualValues.relationship((long)id), id);
    }

    public void org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(Slot slot, AnyValue value) {
        SlottedExecutionContext context = new SlottedExecutionContext(this.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
        this.a(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)).should(this.be()).thrownBy((Function0)new Serializable(this, value, context, setter){
            public static final long serialVersionUID = 0L;
            private final AnyValue value$1;
            private final SlottedExecutionContext context$1;
            private final Function2 setter$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.setter$1.apply((Object)this.context$1, (Object)this.value$1);
            }
            {
                this.value$1 = value$1;
                this.context$1 = context$1;
                this.setter$1 = setter$1;
            }
        });
    }

    public SlottedPipeBuilderUtilsTest() {
        this.test("getter for non-nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable node slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for non-nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable relationship slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Slot slot = this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x");
                SlottedExecutionContext context = new SlottedExecutionContext(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
                Function1 getter = SlottedPipeBuilderUtils$.MODULE$.makeGetValueFromSlotFunctionFor(slot);
                TextValue expectedValue = Values.stringValue((String)"the value");
                context.setRefAt(slot.offset(), (AnyValue)expectedValue);
                AnyValue value = (AnyValue)getter.apply((Object)context);
                this.$outer.convertToAnyShouldWrapper(value).should(this.$outer.equal(expectedValue), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), (AnyValue)Values.NO_VALUE, -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), (AnyValue)Values.NO_VALUE, -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable node slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable relationship slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Slot slot = this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x");
                SlottedExecutionContext context = new SlottedExecutionContext(this.$outer.org$neo4j$cypher$internal$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
                Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
                TextValue expectedValue = Values.stringValue((String)"the value");
                setter.apply((Object)context, (Object)expectedValue);
                AnyValue value = context.getRefAt(slot.offset());
                this.$outer.convertToAnyShouldWrapper(value).should(this.$outer.equal(expectedValue), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

