/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_4.runtime.slotted;

import java.util.Comparator;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.slotted.DefaultComparatorTopTable;

public class DefaultComparatorTopTableTest {
    private static Long[] testValues = new Long[]{7L, 4L, 5L, 0L, 3L, 4L, 8L, 6L, 1L, 9L, 2L};
    private static long[] expectedValues = new long[]{0L, 1L, 2L, 3L, 4L, 4L, 5L, 6L, 7L, 8L, 9L};
    private static final Comparator<Long> comparator = Long::compare;
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldHandleAddingMoreValuesThanCapacity() {
        DefaultComparatorTopTable table = new DefaultComparatorTopTable(comparator, 7);
        for (Long i : testValues) {
            table.add((Object)i);
        }
        table.sort();
        Iterator iterator = table.iterator();
        for (int i = 0; i < 7; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            long value = (Long)iterator.next();
            Assert.assertEquals((long)expectedValues[i], (long)value);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldHandleWhenNotCompletelyFilledToCapacity() {
        DefaultComparatorTopTable table = new DefaultComparatorTopTable(comparator, 20);
        for (Long i : testValues) {
            table.add((Object)i);
        }
        table.sort();
        Iterator iterator = table.iterator();
        for (int i = 0; i < testValues.length; ++i) {
            Assert.assertTrue((boolean)iterator.hasNext());
            long value = (Long)iterator.next();
            Assert.assertEquals((long)expectedValues[i], (long)value);
        }
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldHandleWhenEmpty() {
        DefaultComparatorTopTable table = new DefaultComparatorTopTable(comparator, 10);
        table.sort();
        Iterator iterator = table.iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void shouldThrowOnInitializeToZeroCapacity() {
        this.exception.expect(IllegalArgumentException.class);
        new DefaultComparatorTopTable(comparator, 0);
    }

    @Test
    public void shouldThrowOnInitializeToNegativeCapacity() {
        this.exception.expect(IllegalArgumentException.class);
        new DefaultComparatorTopTable(comparator, -1);
    }

    @Test
    public void shouldThrowOnSortNotCalledBeforeIterator() {
        DefaultComparatorTopTable table = new DefaultComparatorTopTable(comparator, 5);
        for (Long i : testValues) {
            table.add((Object)i);
        }
        this.exception.expect(IllegalStateException.class);
        table.iterator();
    }
}

