/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compatibility.v3_4.runtime.slotted.helpers;

import org.neo4j.cypher.internal.compatibility.v3_4.runtime.Slot;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.SlotConfiguration;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.SlotConfiguration$;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.slotted.PrimitiveExecutionContext;
import org.neo4j.cypher.internal.compatibility.v3_4.runtime.slotted.helpers.SlottedPipeBuilderUtils$;
import org.neo4j.cypher.internal.util.v3_4.ParameterWrongTypeException;
import org.neo4j.cypher.internal.util.v3_4.symbols.CypherType;
import org.neo4j.cypher.internal.util.v3_4.symbols.package$;
import org.neo4j.cypher.internal.util.v3_4.test_helpers.CypherFunSuite;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.VirtualValues;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001+\tY2\u000b\\8ui\u0016$\u0007+\u001b9f\u0005VLG\u000eZ3s+RLGn\u001d+fgRT!a\u0001\u0003\u0002\u000f!,G\u000e]3sg*\u0011QAB\u0001\bg2|G\u000f^3e\u0015\t9\u0001\"A\u0004sk:$\u0018.\\3\u000b\u0005%Q\u0011\u0001\u0002<4?RR!a\u0003\u0007\u0002\u001b\r|W\u000e]1uS\nLG.\u001b;z\u0015\tia\"\u0001\u0005j]R,'O\\1m\u0015\ty\u0001#\u0001\u0004dsBDWM\u001d\u0006\u0003#I\tQA\\3pi)T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"aF\u000f\u000e\u0003aQ!!\u0007\u000e\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005%Y\"B\u0001\u000f\r\u0003\u0011)H/\u001b7\n\u0005yA\"AD\"za\",'OR;o'VLG/\u001a\u0005\u0006A\u0001!\t!I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\t\u0002\"a\t\u0001\u000e\u0003\tAq!\n\u0001C\u0002\u0013%a%A\u0003tY>$8/F\u0001(!\tA\u0013&D\u0001\u0007\u0013\tQcAA\tTY>$8i\u001c8gS\u001e,(/\u0019;j_:Da\u0001\f\u0001!\u0002\u00139\u0013AB:m_R\u001c\b\u0005C\u0003/\u0001\u0011%q&A\u0007bgN,'\u000f^$fi2{gn\u001a\u000b\u0005aYZ\u0004\t\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0003V]&$\b\"B\u001c.\u0001\u0004A\u0014\u0001B:m_R\u0004\"\u0001K\u001d\n\u0005i2!\u0001B*m_RDQ\u0001P\u0017A\u0002u\n\u0011\u0002\\8oOZ\u000bG.^3\u0011\u0005Er\u0014BA 3\u0005\u0011auN\\4\t\u000b\u0005k\u0003\u0019\u0001\"\u0002\u001b\u0015D\b/Z2uK\u00124\u0016\r\\;f!\t\u0019e)D\u0001E\u0015\t)\u0005#\u0001\u0004wC2,Xm]\u0005\u0003\u000f\u0012\u0013\u0001\"\u00118z-\u0006dW/\u001a\u0005\u0006\u0013\u0002!IAS\u0001\u000eCN\u001cXM\u001d;HKRtu\u000eZ3\u0015\u0007AZE\nC\u00038\u0011\u0002\u0007\u0001\bC\u0003N\u0011\u0002\u0007Q(\u0001\u0002jI\")q\n\u0001C\u0005!\u0006)\u0012m]:feR<U\r\u001e*fY\u0006$\u0018n\u001c8tQ&\u0004Hc\u0001\u0019R%\")qG\u0014a\u0001q!)QJ\u0014a\u0001{!)A\u000b\u0001C\u0005+\u0006i\u0011m]:feR\u001cV\r\u001e'p]\u001e$B\u0001\r,X3\")qg\u0015a\u0001q!)\u0001l\u0015a\u0001\u0005\u0006)a/\u00197vK\")!l\u0015a\u0001{\u0005AQ\r\u001f9fGR,G\rC\u0003]\u0001\u0011%Q,A\u0007bgN,'\u000f^*fi:{G-\u001a\u000b\u0004ay{\u0006\"B\u001c\\\u0001\u0004A\u0004\"B'\\\u0001\u0004i\u0004\"B1\u0001\t\u0013\u0011\u0017!F1tg\u0016\u0014HoU3u%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d\u000b\u0004a\r$\u0007\"B\u001ca\u0001\u0004A\u0004\"B'a\u0001\u0004i\u0004\"\u00024\u0001\t\u00139\u0017AD1tg\u0016\u0014HoU3u\r\u0006LGn\u001d\u000b\u0004a!L\u0007\"B\u001cf\u0001\u0004A\u0004\"\u0002-f\u0001\u0004\u0011\u0005")
public class SlottedPipeBuilderUtilsTest
extends CypherFunSuite {
    private final SlotConfiguration org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots = SlotConfiguration$.MODULE$.empty().newLong("n1", false, (CypherType)package$.MODULE$.CTNode()).newLong("n2", true, (CypherType)package$.MODULE$.CTNode()).newLong("r1", false, (CypherType)package$.MODULE$.CTRelationship()).newLong("r2", true, (CypherType)package$.MODULE$.CTRelationship()).newReference("x", true, (CypherType)package$.MODULE$.CTAny());

    public SlotConfiguration org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots() {
        return this.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots;
    }

    public void org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(Slot slot, long longValue, AnyValue expectedValue) {
        PrimitiveExecutionContext context = new PrimitiveExecutionContext(this.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function1 getter = SlottedPipeBuilderUtils$.MODULE$.makeGetValueFromSlotFunctionFor(slot);
        context.setLongAt(slot.offset(), longValue);
        AnyValue value = (AnyValue)getter.apply((Object)context);
        this.convertToAnyShouldWrapper(value).should(this.equal(expectedValue), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(Slot slot, long id) {
        this.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(slot, id, (AnyValue)VirtualValues.node((long)id));
    }

    public void org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(Slot slot, long id) {
        this.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(slot, id, (AnyValue)VirtualValues.edge((long)id));
    }

    public void org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(Slot slot, AnyValue value, long expected) {
        PrimitiveExecutionContext context = new PrimitiveExecutionContext(this.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
        setter.apply((Object)context, (Object)value);
        this.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)context.getLongAt(slot.offset()))).should(this.equal(BoxesRunTime.boxToLong((long)expected)), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(Slot slot, long id) {
        this.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(slot, (AnyValue)VirtualValues.node((long)id), id);
    }

    public void org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(Slot slot, long id) {
        this.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(slot, (AnyValue)VirtualValues.edge((long)id), id);
    }

    public void org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(Slot slot, AnyValue value) {
        PrimitiveExecutionContext context = new PrimitiveExecutionContext(this.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
        Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
        this.a(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)).should(this.be()).thrownBy((Function0)new Serializable(this, value, context, setter){
            public static final long serialVersionUID = 0L;
            private final AnyValue value$1;
            private final PrimitiveExecutionContext context$1;
            private final Function2 setter$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.setter$1.apply((Object)this.context$1, (Object)this.value$1);
            }
            {
                this.value$1 = value$1;
                this.context$1 = context$1;
                this.setter$1 = setter$1;
            }
        });
    }

    public SlottedPipeBuilderUtilsTest() {
        this.test("getter for non-nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable node slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetNode(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for non-nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable relationship slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetLong(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), -1L, (AnyValue)Values.NO_VALUE);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertGetRelationship(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("getter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Slot slot = this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x");
                PrimitiveExecutionContext context = new PrimitiveExecutionContext(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
                Function1 getter = SlottedPipeBuilderUtils$.MODULE$.makeGetValueFromSlotFunctionFor(slot);
                TextValue expectedValue = Values.stringValue((String)"the value");
                context.setRefAt(slot.offset(), (AnyValue)expectedValue);
                AnyValue value = (AnyValue)getter.apply((Object)context);
                this.$outer.convertToAnyShouldWrapper(value).should(this.$outer.equal(expectedValue), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), (AnyValue)Values.NO_VALUE, -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetNode(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slots with null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetLong(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), (AnyValue)Values.NO_VALUE, -1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetRelationship(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), 42L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable node slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n1"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable node slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("n2"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for non-nullable relationship slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r1"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for nullable relationship slot should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$assertSetFails(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("r2"), (AnyValue)Values.stringValue((String)"oops"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("setter for ref slot", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SlottedPipeBuilderUtilsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Slot slot = this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots().apply("x");
                PrimitiveExecutionContext context = new PrimitiveExecutionContext(this.$outer.org$neo4j$cypher$internal$compatibility$v3_4$runtime$slotted$helpers$SlottedPipeBuilderUtilsTest$$slots());
                Function2 setter = SlottedPipeBuilderUtils$.MODULE$.makeSetValueInSlotFunctionFor(slot);
                TextValue expectedValue = Values.stringValue((String)"the value");
                setter.apply((Object)context, (Object)expectedValue);
                AnyValue value = context.getRefAt(slot.offset());
                this.$outer.convertToAnyShouldWrapper(value).should(this.$outer.equal(expectedValue), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

