/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.planDescription;

import java.util.Locale;
import org.neo4j.cypher.internal.planner.v3_5.spi.PlanningAttributes;
import org.neo4j.cypher.internal.runtime.planDescription.Argument;
import org.neo4j.cypher.internal.runtime.planDescription.Children;
import org.neo4j.cypher.internal.runtime.planDescription.CompactedLine;
import org.neo4j.cypher.internal.runtime.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.runtime.planDescription.Line;
import org.neo4j.cypher.internal.runtime.planDescription.Line$;
import org.neo4j.cypher.internal.runtime.planDescription.LogicalPlan2PlanDescription;
import org.neo4j.cypher.internal.runtime.planDescription.NoChildren$;
import org.neo4j.cypher.internal.runtime.planDescription.PlanDescriptionImpl;
import org.neo4j.cypher.internal.runtime.planDescription.RenderTreeTableTest$;
import org.neo4j.cypher.internal.runtime.planDescription.RenderTreeTableTest$$anonfun$44$;
import org.neo4j.cypher.internal.runtime.planDescription.SingleChild;
import org.neo4j.cypher.internal.runtime.planDescription.TwoChildren;
import org.neo4j.cypher.internal.runtime.planDescription.renderAsTreeTable$;
import org.neo4j.cypher.internal.v3_5.logical.plans.Argument$;
import org.neo4j.cypher.internal.v3_5.logical.plans.ExclusiveBound;
import org.neo4j.cypher.internal.v3_5.logical.plans.Expand;
import org.neo4j.cypher.internal.v3_5.logical.plans.ExpandAll$;
import org.neo4j.cypher.internal.v3_5.logical.plans.ExpansionMode;
import org.neo4j.cypher.internal.v3_5.logical.plans.InequalitySeekRange;
import org.neo4j.cypher.internal.v3_5.logical.plans.InequalitySeekRangeWrapper;
import org.neo4j.cypher.internal.v3_5.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.v3_5.logical.plans.NodeIndexSeek;
import org.neo4j.cypher.internal.v3_5.logical.plans.QueryExpression;
import org.neo4j.cypher.internal.v3_5.logical.plans.RangeBetween;
import org.neo4j.cypher.internal.v3_5.logical.plans.RangeGreaterThan;
import org.neo4j.cypher.internal.v3_5.logical.plans.RangeLessThan;
import org.neo4j.cypher.internal.v3_5.logical.plans.RangeQueryExpression;
import org.opencypher.v9_0.expressions.Equals;
import org.opencypher.v9_0.expressions.Expression;
import org.opencypher.v9_0.expressions.FunctionInvocation$;
import org.opencypher.v9_0.expressions.FunctionName;
import org.opencypher.v9_0.expressions.HasLabels;
import org.opencypher.v9_0.expressions.LabelName;
import org.opencypher.v9_0.expressions.LabelToken;
import org.opencypher.v9_0.expressions.Not;
import org.opencypher.v9_0.expressions.Property;
import org.opencypher.v9_0.expressions.PropertyKeyName;
import org.opencypher.v9_0.expressions.PropertyKeyToken;
import org.opencypher.v9_0.expressions.PropertyKeyToken$;
import org.opencypher.v9_0.expressions.SemanticDirection;
import org.opencypher.v9_0.expressions.SignedDecimalIntegerLiteral;
import org.opencypher.v9_0.expressions.Variable;
import org.opencypher.v9_0.util.Cardinality$;
import org.opencypher.v9_0.util.DummyPosition$;
import org.opencypher.v9_0.util.InputPosition;
import org.opencypher.v9_0.util.LabelId;
import org.opencypher.v9_0.util.NonEmptyList$;
import org.opencypher.v9_0.util.PropertyKeyId;
import org.opencypher.v9_0.util.attribution.Id$;
import org.opencypher.v9_0.util.attribution.IdGen;
import org.opencypher.v9_0.util.attribution.SequentialIdGen;
import org.opencypher.v9_0.util.attribution.SequentialIdGen$;
import org.opencypher.v9_0.util.test_helpers.CypherFunSuite;
import org.opencypher.v9_0.util.test_helpers.WindowsStringSafe$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u001f\t\u0019\"+\u001a8eKJ$&/Z3UC\ndW\rV3ti*\u00111\u0001B\u0001\u0010a2\fg\u000eR3tGJL\u0007\u000f^5p]*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"\u0001\u0005j]R,'O\\1m\u0015\tI!\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u00171\tQA\\3pi)T\u0011!D\u0001\u0004_J<7\u0001A\n\u0004\u0001Aa\u0002CA\t\u001b\u001b\u0005\u0011\"BA\n\u0015\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)b#\u0001\u0003vi&d'BA\f\u0019\u0003\u00111\u0018h\u0018\u0019\u000b\u0005ea\u0011AC8qK:\u001c\u0017\u0010\u001d5fe&\u00111D\u0005\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f!\ti\u0002%D\u0001\u001f\u0015\tyB\"A\u0005tG\u0006d\u0017\r^3ti&\u0011\u0011E\b\u0002\u0012\u0005\u00164wN]3B]\u0012\fe\r^3s\u00032d\u0007\"B\u0012\u0001\t\u0003!\u0013A\u0002\u001fj]&$h\bF\u0001&!\t1\u0003!D\u0001\u0003\u0011\u001dA\u0003A1A\u0005\u0004%\n1b^5oI><8oU1gKV\t!F\u0004\u0002\u0012W%\u0011AFE\u0001\u0012/&tGm\\<t'R\u0014\u0018N\\4TC\u001a,\u0007B\u0002\u0018\u0001A\u0003%!&\u0001\u0007xS:$wn^:TC\u001a,\u0007\u0005C\u00041\u0001\t\u0007I1A\u0019\u0002\u000b%$w)\u001a8\u0016\u0003I\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\u000b\u0002\u0017\u0005$HO]5ckRLwN\\\u0005\u0003oQ\u0012qbU3rk\u0016tG/[1m\u0013\u0012<UM\u001c\u0005\u0007s\u0001\u0001\u000b\u0011\u0002\u001a\u0002\r%$w)\u001a8!\u0011\u001dY\u0004A1A\u0005\nq\nQ\u0002Z3gCVdG\u000fT8dC2,W#A\u001f\u0011\u0005y\u0012U\"A \u000b\u0005U\u0001%\"A!\u0002\t)\fg/Y\u0005\u0003\u0007~\u0012a\u0001T8dC2,\u0007BB#\u0001A\u0003%Q(\u0001\beK\u001a\fW\u000f\u001c;M_\u000e\fG.\u001a\u0011\t\u000b\u001d\u0003A\u0011\t%\u0002\u0013\t,gm\u001c:f\u00032dG#A%\u0011\u0005)kU\"A&\u000b\u00031\u000bQa]2bY\u0006L!AT&\u0003\tUs\u0017\u000e\u001e\u0005\u0006!\u0002!\t\u0005S\u0001\tC\u001a$XM]!mY\"9!\u000b\u0001b\u0001\n\u0013\u0019\u0016a\u00019pgV\tA\u000b\u0005\u0002V-6\tA#\u0003\u0002X)\ti\u0011J\u001c9viB{7/\u001b;j_:Da!\u0017\u0001!\u0002\u0013!\u0016\u0001\u00029pg\u0002Bqa\u0017\u0001C\u0002\u0013%A,\u0001\u0002jIV\tQ\f\u0005\u00024=&\u0011q\f\u000e\u0002\u0003\u0013\u0012Da!\u0019\u0001!\u0002\u0013i\u0016aA5eA!91\r\u0001b\u0001\n\u0013!\u0017\u0001C1sOVlWM\u001c;\u0016\u0003\u0015\u0004\"AZ7\u000e\u0003\u001dT!\u0001[5\u0002\u000bAd\u0017M\\:\u000b\u0005)\\\u0017a\u00027pO&\u001c\u0017\r\u001c\u0006\u0003Y\u001a\tAA^\u001a`k%\u0011an\u001a\u0002\t\u0003J<W/\\3oi\"1\u0001\u000f\u0001Q\u0001\n\u0015\f\u0011\"\u0019:hk6,g\u000e\u001e\u0011")
public class RenderTreeTableTest
extends CypherFunSuite
implements BeforeAndAfterAll {
    private final WindowsStringSafe$ windowsSafe;
    private final SequentialIdGen idGen;
    private final Locale defaultLocale;
    private final InputPosition org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos;
    private final int org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id;
    private final org.neo4j.cypher.internal.v3_5.logical.plans.Argument org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$argument;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public WindowsStringSafe$ windowsSafe() {
        return this.windowsSafe;
    }

    public SequentialIdGen idGen() {
        return this.idGen;
    }

    private Locale defaultLocale() {
        return this.defaultLocale;
    }

    public void beforeAll() {
        Locale.setDefault(Locale.US);
    }

    public void afterAll() {
        Locale.setDefault(this.defaultLocale());
    }

    public InputPosition org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos() {
        return this.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos;
    }

    public int org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id() {
        return this.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id;
    }

    public org.neo4j.cypher.internal.v3_5.logical.plans.Argument org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$argument() {
        return this.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$argument;
    }

    public RenderTreeTableTest() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        this.windowsSafe = WindowsStringSafe$.MODULE$;
        this.idGen = new SequentialIdGen(SequentialIdGen$.MODULE$.$lessinit$greater$default$1());
        this.defaultLocale = Locale.getDefault();
        this.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos = DummyPosition$.MODULE$.apply(0);
        this.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id = Id$.MODULE$.INVALID_ID();
        this.test("node feeding from other node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "ROOT", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+\n        || Operator |\n        |+----------+\n        || +ROOT    |\n        || |        +\n        || +LEAF    |\n        |+----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("node feeding from two nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+\n        || Operator |\n        |+----------+\n        || +ROOT    |\n        || |\\       +\n        || | +LEAF2 |\n        || |        +\n        || +LEAF1   |\n        |+----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("node feeding of node that is feeding of node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "INTERMEDIATE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "ROOT", (Children)new SingleChild((InternalPlanDescription)intermediate), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+---------------+\n        || Operator      |\n        |+---------------+\n        || +ROOT         |\n        || |             +\n        || +INTERMEDIATE |\n        || |             +\n        || +LEAF         |\n        |+---------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("root with two leafs, one of which is deep", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF3", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf3, (InternalPlanDescription)intermediate), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+\n        || Operator        |\n        |+-----------------+\n        || +ROOT           |\n        || |\\              +\n        || | +INTERMEDIATE |\n        || | |\\            +\n        || | | +LEAF2      |\n        || | |             +\n        || | +LEAF1        |\n        || |               +\n        || +LEAF3          |\n        |+-----------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("root with two intermediate nodes coming from four leaf nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})));
                PlanDescriptionImpl leaf4 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
                PlanDescriptionImpl intermediate1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf3, (InternalPlanDescription)leaf4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)intermediate1, (InternalPlanDescription)intermediate2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+-----------+\n        || Operator        | Variables |\n        |+-----------------+-----------+\n        || +ROOT           |           |\n        || |\\              +-----------+\n        || | +INTERMEDIATE |           |\n        || | |\\            +-----------+\n        || | | +LEAF       | d         |\n        || | |             +-----------+\n        || | +LEAF         | c         |\n        || |               +-----------+\n        || +INTERMEDIATE   |           |\n        || |\\              +-----------+\n        || | +LEAF         | b         |\n        || |               +-----------+\n        || +LEAF           | a         |\n        |+-----------------+-----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("complex tree", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.PageCacheHits(1L), new InternalPlanDescription.Arguments$.PageCacheMisses(2L), new InternalPlanDescription.Arguments$.PageCacheHitRatio(0.3333333333333333), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(9L), new InternalPlanDescription.Arguments$.DbHits(2L), new InternalPlanDescription.Arguments$.PageCacheHits(2L), new InternalPlanDescription.Arguments$.PageCacheMisses(3L), new InternalPlanDescription.Arguments$.PageCacheHitRatio(0.4), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF3", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(9L), new InternalPlanDescription.Arguments$.DbHits(2L), new InternalPlanDescription.Arguments$.PageCacheHits(3L), new InternalPlanDescription.Arguments$.PageCacheMisses(4L), new InternalPlanDescription.Arguments$.PageCacheHitRatio(0.42857142857142855), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl pass = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "PASS", (Children)new SingleChild((InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(4L), new InternalPlanDescription.Arguments$.DbHits(0L), new InternalPlanDescription.Arguments$.PageCacheHits(4L), new InternalPlanDescription.Arguments$.PageCacheMisses(1L), new InternalPlanDescription.Arguments$.PageCacheHitRatio(0.8), new InternalPlanDescription.Arguments$.EstimatedRows(4.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl inner = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "INNER", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)pass), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(7L), new InternalPlanDescription.Arguments$.DbHits(42L), new InternalPlanDescription.Arguments$.PageCacheHits(5L), new InternalPlanDescription.Arguments$.PageCacheMisses(2L), new InternalPlanDescription.Arguments$.PageCacheHitRatio(0.7142857142857143), new InternalPlanDescription.Arguments$.EstimatedRows(6.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf3, (InternalPlanDescription)inner), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(3L), new InternalPlanDescription.Arguments$.DbHits(0L), new InternalPlanDescription.Arguments$.PageCacheHits(7L), new InternalPlanDescription.Arguments$.PageCacheMisses(10L), new InternalPlanDescription.Arguments$.PageCacheHitRatio(0.4117647058823529), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl parent = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "PARENT", (Children)new SingleChild((InternalPlanDescription)plan), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)parent)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------+----------------+------+---------+-----------------+-------------------+----------------------+\n        || Operator   | Estimated Rows | Rows | DB Hits | Page Cache Hits | Page Cache Misses | Page Cache Hit Ratio |\n        |+------------+----------------+------+---------+-----------------+-------------------+----------------------+\n        || +PARENT    |                |      |         |                 |                   |                      |\n        || |          +----------------+------+---------+-----------------+-------------------+----------------------+\n        || +ROOT      |              1 |    3 |       0 |               7 |                10 |               0.4118 |\n        || |\\         +----------------+------+---------+-----------------+-------------------+----------------------+\n        || | +INNER   |              6 |    7 |      42 |               5 |                 2 |               0.7143 |\n        || | |\\       +----------------+------+---------+-----------------+-------------------+----------------------+\n        || | | +PASS  |              4 |    4 |       0 |               4 |                 1 |               0.8000 |\n        || | | |      +----------------+------+---------+-----------------+-------------------+----------------------+\n        || | | +LEAF2 |              1 |    9 |       2 |               2 |                 3 |               0.4000 |\n        || | |        +----------------+------+---------+-----------------+-------------------+----------------------+\n        || | +LEAF1   |              1 |   42 |      33 |               1 |                 2 |               0.3333 |\n        || |          +----------------+------+---------+-----------------+-------------------+----------------------+\n        || +LEAF3     |              1 |    9 |       2 |               3 |                 4 |               0.4286 |\n        |+------------+----------------+------+---------+-----------------+-------------------+----------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$argument = new org.neo4j.cypher.internal.v3_5.logical.plans.Argument(Argument$.MODULE$.apply$default$1(), (IdGen)this.idGen());
        this.test("single node is represented nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables |\n        |+----------+----------------+------+---------+-----------+\n        || +NAME    |              1 |   42 |      33 | n         |\n        |+----------+----------------+------+---------+-----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("extra variables are not a problem", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables |\n        |+----------+----------------+------+---------+-----------+\n        || +NAME    |              1 |   42 |      33 | a, b, c   |\n        |+----------+----------------+------+---------+-----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("super many variables stretches the column", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d", "e", "f"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables        |\n        |+----------+----------------+------+---------+------------------+\n        || +NAME    |              1 |   42 |      33 | a, b, c, d, e, f |\n        |+----------+----------------+------+---------+------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("execution plan without profiler stats are not shown", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.EstimatedRows[]{new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+-----------+\n        || Operator | Estimated Rows | Variables |\n        |+----------+----------------+-----------+\n        || +NAME    |              1 | n         |\n        |+----------+----------------+-----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("plan information is rendered on the corresponding row to the tree", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq args1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                Seq args2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(2L), new InternalPlanDescription.Arguments$.DbHits(633L), new InternalPlanDescription.Arguments$.Index("Label", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prop"}))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, args1, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl plan2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)new SingleChild((InternalPlanDescription)plan1), args2, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan2)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+--------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other        |\n        |+----------+----------------+------+---------+-----------+--------------+\n        || +NAME    |              1 |    2 |     633 | b         | :Label(prop) |\n        || |        +----------------+------+---------+-----------+--------------+\n        || +NAME    |              1 |   42 |      33 | a         |              |\n        |+----------+----------------+------+---------+-----------+--------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("composite index rendered correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq args1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                Seq args2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(2L), new InternalPlanDescription.Arguments$.DbHits(633L), new InternalPlanDescription.Arguments$.Index("Label", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"propA", "propB"}))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, args1, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl plan2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)new SingleChild((InternalPlanDescription)plan1), args2, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan2)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+---------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other               |\n        |+----------+----------------+------+---------+-----------+---------------------+\n        || +NAME    |              1 |    2 |     633 | b         | :Label(propA,propB) |\n        || |        +----------------+------+---------+-----------+---------------------+\n        || +NAME    |              1 |   42 |      33 | a         |                     |\n        |+----------+----------------+------+---------+-----------+---------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Expand contains information about its relations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Expand expandPlan = new Expand((LogicalPlan)this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$argument(), "from", (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, (Seq)Seq$.MODULE$.empty(), "to", "rel", (ExpansionMode)ExpandAll$.MODULE$, (IdGen)this.$outer.idGen());
                PlanningAttributes.Cardinalities cardinalities = new PlanningAttributes.Cardinalities();
                cardinalities.set(expandPlan.id(), (Object)Cardinality$.MODULE$.lift(1.0));
                cardinalities.set(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$argument().id(), (Object)Cardinality$.MODULE$.lift(1.0));
                LogicalPlan2PlanDescription description = new LogicalPlan2PlanDescription(true, cardinalities);
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)description.create((LogicalPlan)expandPlan))).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+----------------+-----------+---------------------+\n        || Operator     | Estimated Rows | Variables | Other               |\n        |+--------------+----------------+-----------+---------------------+\n        || +Expand(All) |              1 | rel, to   | (from)<-[rel:]-(to) |\n        |+--------------+----------------+-----------+---------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Label scan should be just as pretty as you would expect", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.LabelName("Foo"), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl pipe = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NodeByLabelScan", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)pipe)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------------+----------------+-----------+-------+\n        || Operator         | Estimated Rows | Variables | Other |\n        |+------------------+----------------+-----------+-------+\n        || +NodeByLabelScan |              1 | n         | :Foo  |\n        |+------------------+----------------+-----------+-------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Var length expand contains information about its relations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalPlanDescription.Arguments$.ExpandExpression expandDescr = new InternalPlanDescription.Arguments$.ExpandExpression("from", "rel", (Seq)Seq$.MODULE$.empty(), "to", (SemanticDirection)SemanticDirection.INCOMING$.MODULE$, 0, (Option)None$.MODULE$);
                InternalPlanDescription.Arguments$.EstimatedRows estimatedRows = new InternalPlanDescription.Arguments$.EstimatedRows(1.0);
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{estimatedRows, expandDescr}));
                Set variables = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rel", "to"}));
                PlanDescriptionImpl planDescription = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "VarLengthExpand(All)", (Children)NoChildren$.MODULE$, arguments, variables);
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)planDescription)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------------+----------------+-----------+-------------------------+\n        || Operator              | Estimated Rows | Variables | Other                   |\n        |+-----------------------+----------------+-----------+-------------------------+\n        || +VarLengthExpand(All) |              1 | rel, to   | (from)<-[rel:*0..]-(to) |\n        |+-----------------------+----------------+-----------+-------------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("do not show unnamed variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.ExpandExpression("  UNNAMED123", "R", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHOOP"})), "  UNNAMED24", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                Set variables = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n", "  UNNAMED123", "  FRESHID12", "  AGGREGATION255"}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, variables);
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------------------------------+------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables                         | Other            |\n        |+----------+----------------+------+---------+-----------------------------------+------------------+\n        || +NAME    |              1 |   42 |      33 | anon[255], anon[12], anon[123], n | ()-[R:WHOOP]->() |\n        |+----------+----------------+------+---------+-----------------------------------+------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show multiple relationship types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.ExpandExpression("source", "through", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SOME", "OTHER", "THING"})), "target", (SemanticDirection)SemanticDirection.OUTGOING$.MODULE$, 1, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1))), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-------------------------------------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other                                           |\n        |+----------+----------------+------+---------+-----------+-------------------------------------------------+\n        || +NAME    |              1 |   42 |      33 | n         | (source)-[through:SOME|:OTHER|:THING]->(target) |\n        |+----------+----------------+------+---------+-----------+-------------------------------------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show nicer output instead of unnamed variables in equals expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.Expression((Expression)new Not((Expression)new Equals((Expression)new Variable("  UNNAMED123", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), (Expression)new Variable("  UNNAMED321", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-------------------------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other                         |\n        |+----------+----------------+------+---------+-----------+-------------------------------+\n        || +NAME    |              1 |   42 |      33 | n         | not `anon[123]` = `anon[321]` |\n        |+----------+----------------+------+---------+-----------+-------------------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show hasLabels nicely without token id", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.Expression((Expression)new HasLabels((Expression)new Variable("x", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LabelName[]{new LabelName("Artist", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())})), this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other    |\n        |+----------+----------------+------+---------+-----------+----------+\n        || +NAME    |              1 |   42 |      33 | n         | x:Artist |\n        |+----------+----------------+------+---------+-----------+----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("format length properly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.Expression((Expression)FunctionInvocation$.MODULE$.apply(new FunctionName("length", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), (Expression)new Variable("n", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other     |\n        |+----------+----------------+------+---------+-----------+-----------+\n        || +NAME    |              1 |   42 |      33 | n         | length(n) |\n        |+----------+----------------+------+---------+-----------+-----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("format index range seek properly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RangeQueryExpression rangeQuery = new RangeQueryExpression((Object)new InequalitySeekRangeWrapper((InequalitySeekRange)new RangeLessThan(NonEmptyList$.MODULE$.apply((Object)new ExclusiveBound((Object)new SignedDecimalIntegerLiteral("12", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExclusiveBound[0]))), this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()));
                NodeIndexSeek seekPlan = new NodeIndexSeek("a", new LabelToken("Person", new LabelId(0)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyKeyToken[]{PropertyKeyToken$.MODULE$.apply(new PropertyKeyName("age", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), new PropertyKeyId(0))})), (QueryExpression)rangeQuery, Predef$.MODULE$.Set().empty(), (IdGen)this.$outer.idGen());
                PlanningAttributes.Cardinalities cardinalities = new PlanningAttributes.Cardinalities();
                cardinalities.set(seekPlan.id(), (Object)Cardinality$.MODULE$.lift(1.0));
                cardinalities.set(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$argument().id(), (Object)Cardinality$.MODULE$.lift(1.0));
                LogicalPlan2PlanDescription description = new LogicalPlan2PlanDescription(true, cardinalities);
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)description.create((LogicalPlan)seekPlan))).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------------+----------------+-----------+-------------------+\n        || Operator              | Estimated Rows | Variables | Other             |\n        |+-----------------------+----------------+-----------+-------------------+\n        || +NodeIndexSeekByRange |              1 | a         | :Person(age) < 12 |\n        |+-----------------------+----------------+-----------+-------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("format index range seek by bounds", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RangeGreaterThan greaterThan = new RangeGreaterThan(NonEmptyList$.MODULE$.apply((Object)new ExclusiveBound((Object)new SignedDecimalIntegerLiteral("12", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExclusiveBound[0])));
                RangeLessThan lessThan = new RangeLessThan(NonEmptyList$.MODULE$.apply((Object)new ExclusiveBound((Object)new SignedDecimalIntegerLiteral("21", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExclusiveBound[0])));
                RangeBetween between = new RangeBetween(greaterThan, lessThan);
                RangeQueryExpression rangeQuery = new RangeQueryExpression((Object)new InequalitySeekRangeWrapper((InequalitySeekRange)between, this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()));
                NodeIndexSeek seekPlan = new NodeIndexSeek("a", new LabelToken("Person", new LabelId(0)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyKeyToken[]{PropertyKeyToken$.MODULE$.apply(new PropertyKeyName("age", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), new PropertyKeyId(0))})), (QueryExpression)rangeQuery, Predef$.MODULE$.Set().empty(), (IdGen)this.$outer.idGen());
                PlanningAttributes.Cardinalities cardinalities = new PlanningAttributes.Cardinalities();
                cardinalities.set(seekPlan.id(), (Object)Cardinality$.MODULE$.lift(1.0));
                cardinalities.set(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$argument().id(), (Object)Cardinality$.MODULE$.lift(1.0));
                LogicalPlan2PlanDescription description = new LogicalPlan2PlanDescription(true, cardinalities);
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)description.create((LogicalPlan)seekPlan))).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------------+----------------+-----------+-----------------------------------------+\n        || Operator              | Estimated Rows | Variables | Other                                   |\n        |+-----------------------+----------------+-----------+-----------------------------------------+\n        || +NodeIndexSeekByRange |              1 | a         | :Person(age) > 12 AND :Person(age) < 21 |\n        |+-----------------------+----------------+-----------+-----------------------------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't leak deduped names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.Expression((Expression)new Variable("  id@23", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  n@76"})));
                String details = renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan);
                this.$outer.convertToStringShouldWrapper(details).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other |\n        |+----------+----------------+------+---------+-----------+-------+\n        || +NAME    |              1 |   42 |      33 | n         | `id`  |\n        |+----------+----------------+------+---------+-----------+-------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't render planner in Other", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.Planner("COST"), new InternalPlanDescription.Arguments$.Expression((Expression)new Variable("  id@23", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+-------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other |\n        |+----------+----------------+------+---------+-----------+-------+\n        || +NAME    |              1 |   42 |      33 | n         | `id`  |\n        |+----------+----------------+------+---------+-----------+-------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("round estimated rows to int", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl planDescr1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NodeByLabelScan", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.LabelName("Foo"), new InternalPlanDescription.Arguments$.EstimatedRows(0.00123456789)})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                PlanDescriptionImpl planDescr2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NodeByLabelScan", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.LabelName("Foo"), new InternalPlanDescription.Arguments$.EstimatedRows(1.23456789)})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)planDescr1)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------------+----------------+-----------+-------+\n        || Operator         | Estimated Rows | Variables | Other |\n        |+------------------+----------------+-----------+-------+\n        || +NodeByLabelScan |              0 | n         | :Foo  |\n        |+------------------+----------------+-----------+-------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)planDescr2)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+------------------+----------------+-----------+-------+\n        || Operator         | Estimated Rows | Variables | Other |\n        |+------------------+----------------+-----------+-------+\n        || +NodeByLabelScan |              1 | n         | :Foo  |\n        |+------------------+----------------+-----------+-------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("properly show Property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.Expression((Expression)new Property((Expression)new Variable("x", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), new PropertyKeyName("Artist", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+----------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other    |\n        |+----------+----------------+------+---------+-----------+----------+\n        || +NAME    |              1 |   42 |      33 | n         | x.Artist |\n        |+----------+----------------+------+---------+-----------+----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("show exists with variable and property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.Expression((Expression)FunctionInvocation$.MODULE$.apply(new FunctionName("exists", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), (Expression)new Property((Expression)new Variable("x", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), new PropertyKeyName("prop", this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos()), this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$pos())), new InternalPlanDescription.Arguments$.EstimatedRows(1.0)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+----------------+------+---------+-----------+----------------+\n        || Operator | Estimated Rows | Rows | DB Hits | Variables | Other          |\n        |+----------+----------------+------+---------+-----------+----------------+\n        || +NAME    |              1 |   42 |      33 | n         | exists(x.prop) |\n        |+----------+----------------+------+---------+-----------+----------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't show unnamed variables in key names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl sr1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "EmptyRow", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.EstimatedRows[]{new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), Predef$.MODULE$.Set().empty());
                PlanDescriptionImpl sr2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "EmptyRow", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.EstimatedRows[]{new InternalPlanDescription.Arguments$.EstimatedRows(1.0)})), Predef$.MODULE$.Set().empty());
                PlanDescriptionImpl description = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NodeHashJoin", (Children)new TwoChildren((InternalPlanDescription)sr1, (InternalPlanDescription)sr2), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.EstimatedRows[]{new InternalPlanDescription.Arguments$.EstimatedRows(42.0)})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "  UNNAMED45", "  FRESHID77"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)description)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+---------------+----------------+-----------------------+\n        || Operator      | Estimated Rows | Variables             |\n        |+---------------+----------------+-----------------------+\n        || +NodeHashJoin |             42 | anon[77], anon[45], a |\n        || |\\            +----------------+-----------------------+\n        || | +EmptyRow   |              1 |                       |\n        || |             +----------------+-----------------------+\n        || +EmptyRow     |              1 |                       |\n        |+---------------+----------------+-----------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two identical nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+\n        || Operator |\n        |+----------+\n        || +NODE(2) |\n        |+----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two similar nodes with variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+-----------+\n        || Operator | Variables |\n        |+----------+-----------+\n        || +NODE(2) | a, b      |\n        |+----------+-----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two pairs of similar nodes with variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl p1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl p2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p1), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})));
                PlanDescriptionImpl p3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)p3)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+-----------+\n        || Operator     | Variables |\n        |+--------------+-----------+\n        || +OPERATOR(2) | c, d      |\n        || |            +-----------+\n        || +NODE(2)     | a, b      |\n        |+--------------+-----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two pairs of similar nodes with same variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl p1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl p2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p1), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl p3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)p3)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+-----------+\n        || Operator     | Variables |\n        |+--------------+-----------+\n        || +OPERATOR(2) | a, b      |\n        || |            +-----------+\n        || +NODE(2)     | a, b      |\n        |+--------------+-----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two pairs of similar nodes with one new variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl p1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl p2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p1), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl p3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "c"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)p3)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+-----------+\n        || Operator     | Variables |\n        |+--------------+-----------+\n        || +OPERATOR(2) | c -- a, b |\n        || |            +-----------+\n        || +NODE(2)     | a, b      |\n        |+--------------+-----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact two pairs of similar nodes with many repeating variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set repeating = (Set)new RichChar(Predef$.MODULE$.charWrapper('b')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl p1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), repeating);
                PlanDescriptionImpl p2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p1), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl p3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p2), (Seq)Seq$.MODULE$.empty(), (Set)repeating.$plus((Object)"var_A").$plus((Object)"var_B"));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)p3)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+--------------------------------------------------------------------------------------------------+\n        || Operator     | Variables                                                                                        |\n        |+--------------+--------------------------------------------------------------------------------------------------+\n        || +OPERATOR(2) | var_A, var_B -- var_a, var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, ... |\n        || |            +--------------------------------------------------------------------------------------------------+\n        || +NODE(2)     | var_a, var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, var_l, var_m, ...   |\n        |+--------------+--------------------------------------------------------------------------------------------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact only the sufficiently similar pair of two simular pairs of nodes with many repeating variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set repeating = (Set)new RichChar(Predef$.MODULE$.charWrapper('b')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.LabelName[]{new InternalPlanDescription.Arguments$.LabelName("123")})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl p1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), repeating);
                PlanDescriptionImpl p2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p1), (Seq)Seq$.MODULE$.empty(), (Set)repeating.$plus((Object)"var_A").$plus((Object)"var_B"));
                PlanDescriptionImpl p3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)p3)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+--------------------------------------------------------------------------------------------------+-------+\n        || Operator     | Variables                                                                                        | Other |\n        |+--------------+--------------------------------------------------------------------------------------------------+-------+\n        || +OPERATOR(2) | var_A, var_B, var_a -- var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, ... |       |\n        || |            +--------------------------------------------------------------------------------------------------+-------+\n        || +NODE        | var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, var_l, var_m, var_n, ...   |       |\n        || |            +--------------------------------------------------------------------------------------------------+-------+\n        || +NODE        | var_a                                                                                            | :123  |\n        |+--------------+--------------------------------------------------------------------------------------------------+-------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compact only the sufficiently similar pair of two simular pairs of nodes with many repeating variables and many columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set repeating = (Set)new RichChar(Predef$.MODULE$.charWrapper('b')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                InternalPlanDescription.Arguments$.LabelName l = new InternalPlanDescription.Arguments$.LabelName("123");
                InternalPlanDescription.Arguments$.Time t = new InternalPlanDescription.Arguments$.Time(12345678L);
                InternalPlanDescription.Arguments$.Rows r = new InternalPlanDescription.Arguments$.Rows(2L);
                InternalPlanDescription.Arguments$.DbHits d = new InternalPlanDescription.Arguments$.DbHits(2L);
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{l, t, r, d})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl p1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{t, r, d})), repeating);
                PlanDescriptionImpl p2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p1), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{t, r, d})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl p3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p2), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{t, r, d})), (Set)repeating.$plus((Object)"var_A").$plus((Object)"var_B"));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)p3)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+------+---------+-----------+--------------------------------------------------------------------------------------------------+-------+\n        || Operator     | Rows | DB Hits | Time (ms) | Variables                                                                                        | Other |\n        |+--------------+------+---------+-----------+--------------------------------------------------------------------------------------------------+-------+\n        || +OPERATOR(2) |    2 |       4 |    24.691 | var_A, var_B, var_a -- var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, ... |       |\n        || |            +------+---------+-----------+--------------------------------------------------------------------------------------------------+-------+\n        || +NODE        |    2 |       2 |    12.346 | var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, var_l, var_m, var_n, ...   |       |\n        || |            +------+---------+-----------+--------------------------------------------------------------------------------------------------+-------+\n        || +NODE        |    2 |       2 |    12.346 | var_a                                                                                            | :123  |\n        |+--------------+------+---------+-----------+--------------------------------------------------------------------------------------------------+-------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("do not compact two similar pairs of nodes with non-empty other column and many repeating variables and many columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set repeating = (Set)new RichChar(Predef$.MODULE$.charWrapper('b')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                InternalPlanDescription.Arguments$.LabelName l = new InternalPlanDescription.Arguments$.LabelName("123");
                InternalPlanDescription.Arguments$.Time t = new InternalPlanDescription.Arguments$.Time(12345678L);
                InternalPlanDescription.Arguments$.Rows r = new InternalPlanDescription.Arguments$.Rows(2L);
                InternalPlanDescription.Arguments$.DbHits d = new InternalPlanDescription.Arguments$.DbHits(2L);
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{l, t, r, d})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl p1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{l, t, r, d})), repeating);
                PlanDescriptionImpl p2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p1), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{l, t, r, d})), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_a"})));
                PlanDescriptionImpl p3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "OPERATOR", (Children)new SingleChild((InternalPlanDescription)p2), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{l, t, r, d})), (Set)repeating.$plus((Object)"var_A").$plus((Object)"var_B"));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)p3)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------+------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        || Operator  | Rows | DB Hits | Time (ms) | Variables                                                                                      | Other |\n        |+-----------+------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        || +OPERATOR |    2 |       2 |    12.346 | var_A, var_B, var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, var_l, ... | :123  |\n        || |         +------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        || +OPERATOR |    2 |       2 |    12.346 | var_a                                                                                          | :123  |\n        || |         +------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        || +NODE     |    2 |       2 |    12.346 | var_b, var_c, var_d, var_e, var_f, var_g, var_h, var_i, var_j, var_k, var_l, var_m, var_n, ... | :123  |\n        || |         +------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        || +NODE     |    2 |       2 |    12.346 | var_a                                                                                          | :123  |\n        |+-----------+------+---------+-----------+------------------------------------------------------------------------------------------------+-------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("no compaction on complex plan with no repeated names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})));
                PlanDescriptionImpl leaf4 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
                PlanDescriptionImpl branch1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "BRANCH", (Children)new SingleChild((InternalPlanDescription)leaf1), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl branch2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "BRANCH", (Children)new SingleChild((InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl branch3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "BRANCH", (Children)new SingleChild((InternalPlanDescription)leaf3), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})));
                PlanDescriptionImpl branch4 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "BRANCH", (Children)new SingleChild((InternalPlanDescription)leaf4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
                PlanDescriptionImpl intermediate1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)branch1, (InternalPlanDescription)branch2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)branch3, (InternalPlanDescription)branch4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)intermediate1, (InternalPlanDescription)intermediate2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+-----------+\n        || Operator        | Variables |\n        |+-----------------+-----------+\n        || +ROOT           |           |\n        || |\\              +-----------+\n        || | +INTERMEDIATE |           |\n        || | |\\            +-----------+\n        || | | +BRANCH     | d         |\n        || | | |           +-----------+\n        || | | +LEAF       | d         |\n        || | |             +-----------+\n        || | +BRANCH       | c         |\n        || | |             +-----------+\n        || | +LEAF         | c         |\n        || |               +-----------+\n        || +INTERMEDIATE   |           |\n        || |\\              +-----------+\n        || | +BRANCH       | b         |\n        || | |             +-----------+\n        || | +LEAF         | b         |\n        || |               +-----------+\n        || +BRANCH         | a         |\n        || |               +-----------+\n        || +LEAF           | a         |\n        |+-----------------+-----------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("compaction on complex plan with repeated names", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf4 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl branch1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf1), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl branch2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl branch3 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf3), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl branch4 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new SingleChild((InternalPlanDescription)leaf4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate1 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new TwoChildren((InternalPlanDescription)branch1, (InternalPlanDescription)branch2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate2 = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new TwoChildren((InternalPlanDescription)branch3, (InternalPlanDescription)branch4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$id(), "NODE", (Children)new TwoChildren((InternalPlanDescription)intermediate1, (InternalPlanDescription)intermediate2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTreeTable$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+\n        || Operator     |\n        |+--------------+\n        || +NODE        |\n        || |\\           +\n        || | +NODE      |\n        || | |\\         +\n        || | | +NODE(2) |\n        || | |          +\n        || | +NODE(2)   |\n        || |            +\n        || +NODE        |\n        || |\\           +\n        || | +NODE(2)   |\n        || |            +\n        || +NODE(2)     |\n        |+--------------+\n        |")).stripMargin()), (Object)this.$outer.windowsSafe());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Variable line compaction with no variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Line line = new Line("NODE", (Map)Predef$.MODULE$.Map().empty(), Predef$.MODULE$.Set().empty(), Line$.MODULE$.apply$default$4());
                CompactedLine compacted = new CompactedLine(line, Predef$.MODULE$.Set().empty());
                this.$outer.convertToStringShouldWrapper(compacted.formattedVariables()).should(this.$outer.be().apply((Object)""));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Variable line compaction with only new variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Line line = new Line("NODE", (Map)Predef$.MODULE$.Map().empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), Line$.MODULE$.apply$default$4());
                CompactedLine compacted = new CompactedLine(line, Predef$.MODULE$.Set().empty());
                this.$outer.convertToStringShouldWrapper(compacted.formattedVariables()).should(this.$outer.be().apply((Object)"a, b"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Variable line compaction with only old variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Line line = new Line("NODE", (Map)Predef$.MODULE$.Map().empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), Line$.MODULE$.apply$default$4());
                CompactedLine compacted = new CompactedLine(line, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
                this.$outer.convertToStringShouldWrapper(compacted.formattedVariables()).should(this.$outer.be().apply((Object)"a, b"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Variable line compaction with old and new variables", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Line line = new Line("NODE", (Map)Predef$.MODULE$.Map().empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d"})), Line$.MODULE$.apply$default$4());
                CompactedLine compacted = new CompactedLine(line, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})));
                this.$outer.convertToStringShouldWrapper(compacted.formattedVariables()).should(this.$outer.be().apply((Object)"c, d -- a, b"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Variable line compaction with many old and new variables and all compaction lengths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderTreeTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Set newvars = (Set)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'e')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                Set repeating = (Set)new RichChar(Predef$.MODULE$.charWrapper('f')).to((Object)BoxesRunTime.boxToCharacter((char)'z')).toSet().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(char c) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"var_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)}));
                    }
                }, Set$.MODULE$.canBuildFrom());
                Line line = new Line("NODE", (Map)Predef$.MODULE$.Map().empty(), (Set)repeating.$plus$plus((GenTraversableOnce)newvars), (Option)None$.MODULE$);
                CompactedLine compacted = new CompactedLine(line, repeating);
                int maxlen = compacted.formatVariables(1000).length();
                String mintext = "var_a, ...";
                package$.MODULE$.Range().apply(maxlen, 1, -1).foreach$mVc$sp((Function1)new Serializable(this, compacted, maxlen, mintext){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$44 $outer;
                    private final CompactedLine compacted$1;
                    private final int maxlen$1;
                    private final String mintext$1;

                    public final void apply(int length) {
                        this.apply$mcVI$sp(length);
                    }

                    public void apply$mcVI$sp(int length) {
                        String formatted = this.compacted$1.formatVariables(length);
                        if (formatted.length() < this.maxlen$1) {
                            this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$$outer().convertToStringShouldWrapper(formatted).should(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$$outer().endWith().apply("..."));
                        } else {
                            this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$$outer().convertToStringShouldWrapper(formatted).should(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$$outer().endWith().apply("var_z"));
                        }
                        if (length < this.mintext$1.length()) {
                            this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$$outer().convertToStringShouldWrapper(formatted).should(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$$outer().be().apply((Object)this.mintext$1));
                        } else {
                            this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$$outer().withClue(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected formatted length to be no greater than ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)length)})), (Function0)new Serializable(this, formatted, length){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$44$$anonfun$apply$mcV$sp$1 $outer;
                                private final String formatted$1;
                                private final int length$1;

                                public final void apply() {
                                    this.apply$mcV$sp();
                                }

                                public void apply$mcV$sp() {
                                    this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$anonfun$$$outer().org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$$outer().convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)this.formatted$1.length())).should(this.$outer.org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$anonfun$$$outer().org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$$outer().be().$less$eq((Object)BoxesRunTime.boxToInteger((int)this.length$1), (Ordering)Ordering.Int$.MODULE$));
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.formatted$1 = formatted$1;
                                    this.length$1 = length$1;
                                }
                            });
                        }
                    }

                    public /* synthetic */ $anonfun$44 org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.compacted$1 = compacted$1;
                        this.maxlen$1 = maxlen$1;
                        this.mintext$1 = mintext$1;
                    }
                });
            }

            public /* synthetic */ RenderTreeTableTest org$neo4j$cypher$internal$runtime$planDescription$RenderTreeTableTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

