/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.planDescription;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.runtime.planDescription.Argument;
import org.neo4j.cypher.internal.runtime.planDescription.CompactedPlanDescription;
import org.neo4j.cypher.internal.runtime.planDescription.InternalPlanDescription;
import org.opencypher.v9_0.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%2A!\u0001\u0002\u0001\u001f\ta2i\\7qC\u000e$X\r\u001a)mC:$Um]2sSB$\u0018n\u001c8UKN$(BA\u0002\u0005\u0003=\u0001H.\u00198EKN\u001c'/\u001b9uS>t'BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u0011%tG/\u001a:oC2T!!\u0003\u0006\u0002\r\rL\b\u000f[3s\u0015\tYA\"A\u0003oK>$$NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\r\u0001\u0001\u0003\b\t\u0003#ii\u0011A\u0005\u0006\u0003'Q\tA\u0002^3ti~CW\r\u001c9feNT!!\u0006\f\u0002\tU$\u0018\u000e\u001c\u0006\u0003/a\tAA^\u001d`a)\u0011\u0011\u0004D\u0001\u000b_B,gnY=qQ\u0016\u0014\u0018BA\u000e\u0013\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\u0004\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\t5|7m\u001b\u0006\u0003C1\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005\rr\"\u0001D'pG.LGo\\*vO\u0006\u0014\b\"B\u0013\u0001\t\u00031\u0013A\u0002\u001fj]&$h\bF\u0001(!\tA\u0003!D\u0001\u0003\u0001")
public class CompactedPlanDescriptionTest
extends CypherFunSuite {
    public CompactedPlanDescriptionTest() {
        this.test("empty in empty out", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactedPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalPlanDescription planA = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                InternalPlanDescription planB = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                Mockito.when((Object)planA.arguments()).thenReturn((Object)Seq$.MODULE$.empty());
                Mockito.when((Object)planB.arguments()).thenReturn((Object)Seq$.MODULE$.empty());
                CompactedPlanDescription compactPlan = new CompactedPlanDescription((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription[]{planA, planB})));
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(compactPlan).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(CompactedPlanDescription.class)));
                this.$outer.convertToAnyShouldWrapper(compactPlan.arguments()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("dbHits accumulate", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactedPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalPlanDescription planA = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                InternalPlanDescription planB = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                InternalPlanDescription planC = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                Mockito.when((Object)planA.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.DbHits[]{new InternalPlanDescription.Arguments$.DbHits(1L)})));
                Mockito.when((Object)planB.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.DbHits[]{new InternalPlanDescription.Arguments$.DbHits(1L)})));
                Mockito.when((Object)planC.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.DbHits[]{new InternalPlanDescription.Arguments$.DbHits(2L)})));
                CompactedPlanDescription compactPlan = new CompactedPlanDescription((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription[]{planA, planB, planC})));
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(compactPlan).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(CompactedPlanDescription.class)));
                this.$outer.convertToAnyShouldWrapper(compactPlan.arguments()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.DbHits[]{new InternalPlanDescription.Arguments$.DbHits(4L)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("time (sadly) accumulates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactedPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalPlanDescription planA = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                InternalPlanDescription planB = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                InternalPlanDescription planC = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                Mockito.when((Object)planA.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.Time[]{new InternalPlanDescription.Arguments$.Time(1L)})));
                Mockito.when((Object)planB.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.Time[]{new InternalPlanDescription.Arguments$.Time(1L)})));
                Mockito.when((Object)planC.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.Time[]{new InternalPlanDescription.Arguments$.Time(0L)})));
                CompactedPlanDescription compactPlan = new CompactedPlanDescription((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription[]{planA, planB})));
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(compactPlan).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(CompactedPlanDescription.class)));
                this.$outer.convertToAnyShouldWrapper(compactPlan.arguments()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.Time[]{new InternalPlanDescription.Arguments$.Time(2L)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("rows should just show the max numbers of rows. in most situations, these should be the same number", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactedPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalPlanDescription planA = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                InternalPlanDescription planB = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                InternalPlanDescription planC = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                Mockito.when((Object)planA.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.Rows[]{new InternalPlanDescription.Arguments$.Rows(10L)})));
                Mockito.when((Object)planB.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.Rows[]{new InternalPlanDescription.Arguments$.Rows(30L)})));
                Mockito.when((Object)planC.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.Rows[]{new InternalPlanDescription.Arguments$.Rows(20L)})));
                CompactedPlanDescription compactPlan = new CompactedPlanDescription((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription[]{planA, planB, planC})));
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(compactPlan).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(CompactedPlanDescription.class)));
                this.$outer.convertToAnyShouldWrapper(compactPlan.arguments()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription.Arguments$.Rows[]{new InternalPlanDescription.Arguments$.Rows(30L)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("do it all together", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CompactedPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalPlanDescription planA = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                InternalPlanDescription planB = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                InternalPlanDescription planC = (InternalPlanDescription)this.$outer.mock(ManifestFactory$.MODULE$.classType(InternalPlanDescription.class));
                Mockito.when((Object)planA.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(10L), new InternalPlanDescription.Arguments$.DbHits(1L), new InternalPlanDescription.Arguments$.Time(1L)})));
                Mockito.when((Object)planB.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(30L), new InternalPlanDescription.Arguments$.DbHits(1L), new InternalPlanDescription.Arguments$.Time(2L)})));
                Mockito.when((Object)planC.arguments()).thenReturn((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(20L), new InternalPlanDescription.Arguments$.DbHits(2L), new InternalPlanDescription.Arguments$.Time(0L)})));
                CompactedPlanDescription compactPlan = new CompactedPlanDescription((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalPlanDescription[]{planA, planB, planC})));
                TypeMatcherHelper$.MODULE$.checkAType(this.$outer.convertToAnyShouldWrapper(compactPlan).leftSideValue(), this.$outer.a(ManifestFactory$.MODULE$.classType(CompactedPlanDescription.class)));
                this.$outer.convertToAnyShouldWrapper(compactPlan.arguments().toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(30L), new InternalPlanDescription.Arguments$.DbHits(4L), new InternalPlanDescription.Arguments$.Time(3L)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

