/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.cypher.internal.runtime.ArrayBackedMap;
import org.neo4j.cypher.internal.runtime.ArrayBackedMap$;
import org.opencypher.v9_0.util.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}1A!\u0001\u0002\u0001\u001b\t\u0011\u0012I\u001d:bs\n\u000b7m[3e\u001b\u0006\u0004H+Z:u\u0015\t\u0019A!A\u0004sk:$\u0018.\\3\u000b\u0005\u00151\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u001dA\u0011AB2za\",'O\u0003\u0002\n\u0015\u0005)a.Z85U*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\u0002G\u0007\u0002!)\u0011\u0011CE\u0001\ri\u0016\u001cHo\u00185fYB,'o\u001d\u0006\u0003'Q\tA!\u001e;jY*\u0011QCF\u0001\u0005mfz\u0006G\u0003\u0002\u0018\u0015\u0005Qq\u000e]3oGf\u0004\b.\u001a:\n\u0005e\u0001\"AD\"za\",'OR;o'VLG/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\t\u0001")
public class ArrayBackedMapTest
extends CypherFunSuite {
    public ArrayBackedMapTest() {
        this.test("updating and getting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"other")).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("+ operator with existing key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                Map updatedMap = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"oen"));
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"name")).should(this.$outer.equal(new Some((Object)"oen")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("+ operator with non-existing key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                Map updatedMap = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"age"), (Object)"35"));
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"age")).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"age")).should(this.$outer.equal(new Some((Object)"35")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("- operator on existing key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                Map updatedMap = map.$minus((Object)"name");
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"name")).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("iterating over map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                this.$outer.convertToAnyShouldWrapper(map.iterator().toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"name", (Object)"neo"), new Tuple2((Object)"id", (Object)"123")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("support one null key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", null}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get(null)).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("support for null values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{null, "123", null});
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"a")).should(this.$outer.equal(new Some(null)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"b")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"c")).should(this.$outer.equal(new Some(null)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("support one null key mapped to null value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", null}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", null});
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get(null)).should(this.$outer.equal(new Some(null)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("having multiple nulls means that the last null is mapped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{null, null, null}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"v1", "v2", "v3"});
                this.$outer.convertToAnyShouldWrapper(map.get(null)).should(this.$outer.equal(new Some((Object)"v3")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

