/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import org.neo4j.cypher.ExecutionEngineFunSuite;
import org.neo4j.cypher.internal.runtime.InternalExecutionResult;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import org.scalatest.enablers.Size$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a1A!\u0001\u0002\u0001\u001b\tARK\\5rk\u0016tWm]:BG\u000e,\u0007\u000f^1oG\u0016$Vm\u001d;\u000b\u0005\r!\u0011AC1dG\u0016\u0004H/\u00198dK*\u0011QAB\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005\u001dA\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005%Q\u0011!\u00028f_RR'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0012\u001b\u0005\u0001\"BA\u0003\t\u0013\t\u0011\u0002CA\fFq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f\rVt7+^5uK\")A\u0003\u0001C\u0001+\u00051A(\u001b8jiz\"\u0012A\u0006\t\u0003/\u0001i\u0011A\u0001")
public class UniquenessAcceptanceTest
extends ExecutionEngineFunSuite {
    public UniquenessAcceptanceTest() {
        this.test("should not reuse the relationship that has just been traversed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UniquenessAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.relate(this.$outer.createNode("Me"), this.$outer.createNode("Bob"));
                InternalExecutionResult result = this.$outer.execute("MATCH (a)-->()-->(b) WHERE a.name = 'Me' RETURN b.name", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not reuse a relationship that was used earlier", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UniquenessAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node n1 = this.$outer.createNode("start");
                Node n2 = this.$outer.createNode();
                this.$outer.relate(n1, n2);
                this.$outer.relate(n2, n2);
                InternalExecutionResult result = this.$outer.execute("match (a)--(b)-->(c)--(d) where a.name = 'start' return d", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should reuse relationships that were used in a different clause", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UniquenessAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node leaf1 = this.$outer.createNode("leaf1");
                Node leaf2 = this.$outer.createNode("leaf2");
                Node parent = this.$outer.createNode("parent");
                this.$outer.relate(leaf1, parent);
                this.$outer.relate(leaf2, parent);
                InternalExecutionResult result = this.$outer.execute("MATCH (x)-->(parent) WHERE x.name = 'leaf1' WITH parent MATCH (leaf)-->(parent) RETURN leaf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.have()).size(2L, Size$.MODULE$.sizeOfAnyRefWithParameterlessSizeMethodForInt());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should reuse relationships even though they are in context but not used in a pattern", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UniquenessAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node leaf1 = this.$outer.createNode("leaf1");
                Node leaf2 = this.$outer.createNode("leaf2");
                Node parent = this.$outer.createNode("parent");
                this.$outer.relate(leaf1, parent);
                this.$outer.relate(leaf2, parent);
                InternalExecutionResult result = this.$outer.execute("MATCH (x)-[r]->(parent) WHERE x.name = 'leaf1' WITH r, parent MATCH (leaf)-->(parent) RETURN r, leaf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.have()).size(2L, Size$.MODULE$.sizeOfAnyRefWithParameterlessSizeMethodForInt());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider uniqueness when combining simple and variable length pattern in a match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UniquenessAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node leaf1 = this.$outer.createNode("leaf1");
                Node leaf2 = this.$outer.createNode("leaf2");
                this.$outer.relate(leaf1, leaf2);
                this.$outer.relate(leaf2, leaf1);
                Number result = (Number)this.$outer.executeScalar(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH (a)-->()-[*0..4]-(c) WHERE id(a) = ", " RETURN count(*)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)leaf1.getId())})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider uniqueness when combining variable and simple length pattern in a match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UniquenessAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node leaf1 = this.$outer.createNode("leaf1");
                Node leaf2 = this.$outer.createNode("leaf2");
                this.$outer.relate(leaf1, leaf2);
                this.$outer.relate(leaf2, leaf1);
                Number result = (Number)this.$outer.executeScalar(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH (a)-[*0..4]-()<--(c) WHERE id(a) = ", " RETURN count(*)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)leaf1.getId())})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider uniqueness when combining two variable length patterns in a match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UniquenessAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node leaf1 = this.$outer.createNode("leaf1");
                Node leaf2 = this.$outer.createNode("leaf2");
                this.$outer.relate(leaf1, leaf2);
                this.$outer.relate(leaf2, leaf1);
                Number result = (Number)this.$outer.executeScalar(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH (a)-[*1..4]->()-[*0..5]-(c) WHERE id(a) = ", " RETURN count(*)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)leaf1.getId())})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)3)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider uniqueness when doing cartesian products", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ UniquenessAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship r1 = this.$outer.relate(this.$outer.createNode(), this.$outer.createNode());
                Relationship r2 = this.$outer.relate(this.$outer.createNode(), this.$outer.createNode());
                InternalExecutionResult result = this.$outer.execute("MATCH p=()-->(), q=()-->() RETURN p, q", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                List rels = (List)result.toList().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Relationship apply(Map<String, Object> row) {
                        return ((Path)row.apply((Object)"p")).lastRelationship();
                    }
                }, List$.MODULE$.canBuildFrom());
                this.$outer.convertToAnyShouldWrapper(rels).should(this.$outer.have()).size(2L, Size$.MODULE$.sizeOfGenTraversable());
                this.$outer.convertToAnyShouldWrapper(rels.toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{r1, r2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

