/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class TestProcedure {
    @Context
    public GraphDatabaseService db;

    @Procedure(value="org.neo4j.movieTraversal")
    @Description(value="org.neo4j.movieTraversal")
    public Stream<PathResult> movieTraversal(@Name(value="start") Node start) throws Exception {
        TraversalDescription td = this.db.traversalDescription().breadthFirst().relationships(RelationshipType.withName((String)"ACTED_IN"), Direction.BOTH).relationships(RelationshipType.withName((String)"PRODUCED"), Direction.BOTH).relationships(RelationshipType.withName((String)"DIRECTED"), Direction.BOTH).evaluator(Evaluators.fromDepth((int)3)).evaluator((Evaluator)new LabelEvaluator("Western", 1L, 3)).uniqueness((UniquenessFactory)Uniqueness.NODE_GLOBAL);
        return td.traverse(start).stream().map(PathResult::new);
    }

    public static class LabelEvaluator
    implements Evaluator {
        private Set<String> endNodeLabels;
        private long limit = -1L;
        private long minLevel = -1L;
        private long resultCount;

        LabelEvaluator(String endNodeLabel, long limit, int minLevel) {
            this.limit = limit;
            this.minLevel = minLevel;
            this.endNodeLabels = Collections.singleton(endNodeLabel);
        }

        public Evaluation evaluate(Path path) {
            int depth = path.length();
            Node check = path.endNode();
            if ((long)depth < this.minLevel) {
                return Evaluation.EXCLUDE_AND_CONTINUE;
            }
            if (this.limit != -1L && this.resultCount >= this.limit) {
                return Evaluation.EXCLUDE_AND_PRUNE;
            }
            return this.labelExists(check, this.endNodeLabels) ? this.countIncludeAndContinue() : Evaluation.EXCLUDE_AND_CONTINUE;
        }

        private boolean labelExists(Node node, Set<String> labels) {
            if (labels.isEmpty()) {
                return false;
            }
            for (Label lab : node.getLabels()) {
                if (!labels.contains(lab.name())) continue;
                return true;
            }
            return false;
        }

        private Evaluation countIncludeAndContinue() {
            ++this.resultCount;
            return Evaluation.INCLUDE_AND_CONTINUE;
        }
    }

    public static class PathResult {
        public Path path;

        PathResult(Path path) {
            this.path = path;
        }
    }
}

