/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import org.neo4j.cypher.CypherException;
import org.neo4j.cypher.ExecutionEngineFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001e2A!\u0001\u0002\u0001\u001b\ti2+\u001f8uCb,\u0005pY3qi&|g.Q2dKB$\u0018M\\2f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Q\u0011mY2faR\fgnY3\u000b\u0005\u00151\u0011AB2za\",'O\u0003\u0002\b\u0011\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\n\u0015\u0005)a.Z85U*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001\u001dA\u0011q\"E\u0007\u0002!)\u0011Q\u0001C\u0005\u0003%A\u0011q#\u0012=fGV$\u0018n\u001c8F]\u001eLg.\u001a$v]N+\u0018\u000e^3\t\u000bQ\u0001A\u0011A\u000b\u0002\rqJg.\u001b;?)\u00051\u0002CA\f\u0001\u001b\u0005\u0011\u0001\"B\r\u0001\t\u0003Q\u0012\u0001\u0002;fgR$2aG\u0011+!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0011)f.\u001b;\t\u000b\tB\u0002\u0019A\u0012\u0002\u000bE,XM]=\u0011\u0005\u0011:cB\u0001\u000f&\u0013\t1S$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q%\u0012aa\u0015;sS:<'B\u0001\u0014\u001e\u0011\u0015Y\u0003\u00041\u0001$\u0003\u001diWm]:bO\u0016DQ!\u0007\u0001\u0005\u00025\"2a\u0007\u00180\u0011\u0015\u0011C\u00061\u0001$\u0011\u0015\u0001D\u00061\u00012\u00031iWm]:bO\u0016\u0014VmZ3y!\t\u0011t'D\u00014\u0015\t!T'\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\t1T$\u0001\u0003vi&d\u0017B\u0001\u001d4\u0005\u0015\u0011VmZ3y\u0001")
public class SyntaxExceptionAcceptanceTest
extends ExecutionEngineFunSuite {
    public void test(String query, String message) {
        try {
            this.execute(query, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get the expected syntax error, expected: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})));
        }
        catch (CypherException cypherException) {
            String actual = ((String)new StringOps(Predef$.MODULE$.augmentString(cypherException.getMessage())).lines().next()).trim();
            this.convertToStringShouldWrapper(actual).should(this.startWith().apply((String)new StringOps(Predef$.MODULE$.augmentString(message)).init()));
            return;
        }
    }

    public void test(String query, Regex messageRegex) {
        try {
            this.execute(query, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get the expected syntax error, expected matching: '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{messageRegex})));
        }
        catch (CypherException cypherException) {
            String actual = ((String)new StringOps(Predef$.MODULE$.augmentString(cypherException.getMessage())).lines().next()).trim();
            Option option = messageRegex.findFirstIn((CharSequence)actual);
            if (None$.MODULE$.equals(option)) {
                throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected matching '", "', but was '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{messageRegex, actual})));
            }
            if (option instanceof Some) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            throw new MatchError((Object)option);
        }
    }

    public SyntaxExceptionAcceptanceTest() {
        this.test("should raise error when missing index value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start s = node:index(key=) return s", "Invalid input ')': expected whitespace, \"...string...\" or a parameter (line 1, column 26)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should give nice error when missing equals sign", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start n=node:customer(id : {id}) return n", "Invalid input ':': expected whitespace, comment or '=' (line 1, column 26)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should raise error when missing index key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start s = node:index(=\"value\") return s", "Invalid input '=': expected whitespace, an identifier, \"...string...\" or a parameter (line 1, column 22)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("start without node or rel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start s return s", "Invalid input 'r': expected whitespace, comment or '=' (line 1, column 9)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should complain about a string being expected", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start s=node:index(key = value) return s", "Invalid input 'v': expected whitespace, comment, \"...string...\" or a parameter (line 1, column 26)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shortest path can not have minimum depth different from zero or one", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("match (a), (b) where id(a) = 0 and id(b) = 1 match p=shortestPath(a-[*2..3]->b) return p", "shortestPath(...) does not support a minimal length different from 0 or 1 (line 1, column 54)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shortest path can not have multiple links in it", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("match (a), (b) where id(a) = 0 and id(b) = 1 match p=shortestPath(a-->()-->b) return p", "shortestPath(...) requires a pattern containing a single relationship (line 1, column 54)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("old node syntax gives helpful error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start a=(0) return a", "Invalid input '(': expected whitespace, NODE or RELATIONSHIP (line 1, column 9)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("weird spelling", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start a=ndoe(0) return a", "Invalid input 'd': expected 'o/O' (line 1, column 10)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("unclosed parenthesis", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start a=node(0 return a", "Invalid input 'r': expected whitespace, comment, ',' or ')' (line 1, column 16)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("trailing comma", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start a=node(0,1,) return a", "Invalid input ')': expected whitespace or an unsigned integer (line 1, column 18)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("unclosed curly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start a=node({0) return a", "Invalid input ')': expected whitespace or '}' (line 1, column 16)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("two equal signs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start a==node(0) return a", "Invalid input '=' (line 1, column 9)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("handles multiline queries", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start\n         a=node(0),\n         b=node(0),\n         c=node(0),\n         d=node(0),\n         e=node(0),\n         f=node(0),\n         g=node(0),\n         s=node:index(key = value) return s", "Invalid input 'v': expected whitespace, comment, \"...string...\" or a parameter (line 9, column 29)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("create node without", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("start\n         a=node(0),\n         b=node(0),\n         c=node(0),\n         d=node(0),\n         e=node(0),\n         f=node(0),\n         g=node(0),\n         s=node:index(key = value) return s", "Invalid input 'v': expected whitespace, comment, \"...string...\" or a parameter (line 9, column 29)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should raise error when missing return columns", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("match (s) return", "Unexpected end of input: expected whitespace, DISTINCT, GRAPHS, SOURCE GRAPH [AS <name>], TARGET GRAPH [AS <name>], GRAPH AT <graph-url> [AS <name>], GRAPH OF <pattern> [AS <name>], GRAPH, GRAPH <graph-ref> [AS <name>], >>, '*' or an expression (line 1, column 17)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should raise error when missing return", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("match (s) where s.id = 0", "Query cannot conclude with MATCH (must be RETURN or an update clause) (line 1, column 1)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("forget by in order by", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test("match (a) where id(a) = 0 return a order a.name", "Invalid input 'a': expected whitespace, comment or BY (line 1, column 42)");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle empty string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.test(" ", "Unexpected end of input: expected whitespace, comment, CYPHER options, EXPLAIN, PROFILE or Query (line 1, column 2 (offset: 1))");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle newline", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyntaxExceptionAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String sep = System.lineSeparator();
                this.$outer.test(sep, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected end of input: expected whitespace, comment, CYPHER options, EXPLAIN, PROFILE or Query (line 2, column 1 (offset: ", "))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)sep.length())})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

