/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import java.util.HashMap;
import java.util.Iterator;
import org.neo4j.cypher.ExecutionEngineFunSuite;
import org.neo4j.cypher.internal.frontend.v3_4.helpers.StringHelper;
import org.neo4j.cypher.internal.frontend.v3_4.helpers.StringHelper$;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.cypher.acceptance.SemanticErrorAcceptanceTest$;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001\u001b\tY2+Z7b]RL7-\u0012:s_J\f5mY3qi\u0006t7-\u001a+fgRT!a\u0001\u0003\u0002\u0015\u0005\u001c7-\u001a9uC:\u001cWM\u0003\u0002\u0006\r\u000511-\u001f9iKJT!a\u0002\u0005\u0002\u0011%tG/\u001a:oC2T!!\u0003\u0006\u0002\u000b9,w\u000e\u000e6\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\tR\"\u0001\t\u000b\u0005\u0015A\u0011B\u0001\n\u0011\u0005])\u00050Z2vi&|g.\u00128hS:,g)\u001e8Tk&$X\rC\u0003\u0015\u0001\u0011\u0005Q#\u0001\u0004=S:LGO\u0010\u000b\u0002-A\u0011q\u0003A\u0007\u0002\u0005!)\u0011\u0004\u0001C\u00055\u0005)R\r_3dkR,\u0017I\u001c3F]N,(/Z#se>\u0014H\u0003B\u000e\"U1\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011A!\u00168ji\")!\u0005\u0007a\u0001G\u0005)\u0011/^3ssB\u0011Ae\n\b\u00039\u0015J!AJ\u000f\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003MuAQa\u000b\rA\u0002\r\n\u0001\"\u001a=qK\u000e$X\r\u001a\u0005\u0006[a\u0001\rAL\u0001\u0007a\u0006\u0014\u0018-\\:\u0011\u0007qy\u0013'\u0003\u00021;\tQAH]3qK\u0006$X\r\u001a \u0011\tq\u00114\u0005N\u0005\u0003gu\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u000f6\u0013\t1TDA\u0002B]f\u0004")
public class SemanticErrorAcceptanceTest
extends ExecutionEngineFunSuite {
    public void org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError(String query, String expected, Seq<Tuple2<String, Object>> params) {
        try {
            HashMap jParams = new HashMap();
            params.foreach((Function1)new Serializable(this, jParams){
                public static final long serialVersionUID = 0L;
                private final HashMap jParams$1;

                public final Object apply(Tuple2<String, Object> kv) {
                    return this.jParams$1.put(kv._1(), kv._2());
                }
                {
                    this.jParams$1 = jParams$1;
                }
            });
            ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter((Iterator)this.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.graph()).execute(StringHelper.RichString$.MODULE$.fixNewLines$extension(StringHelper$.MODULE$.RichString(query)), jParams)).asScala()).size();
            throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get the expected syntax error, expected: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{expected})));
        }
        catch (QueryExecutionException queryExecutionException) {
            String actual = ((String)new StringOps(Predef$.MODULE$.augmentString(queryExecutionException.getMessage())).lines().next()).trim();
            this.convertToStringShouldWrapper(actual).should(this.equal(expected), (Object)Equality$.MODULE$.default());
            return;
        }
    }

    public SemanticErrorAcceptanceTest() {
        this.test("FROM should generate error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("FROM GRAPH foo AT 'graph://url' RETURN 1", "Projecting and returning graphs is not available in this implementation of Cypher due to lack of support for multiple graphs. (line 1, column 6 (offset: 5))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("INTO should generate error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("INTO GRAPH foo AT 'graph://url' RETURN 1", "Projecting and returning graphs is not available in this implementation of Cypher due to lack of support for multiple graphs. (line 1, column 6 (offset: 5))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("projecting graphs should generate error", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("WITH GRAPH AT 'url' AS foo MATCH (a) RETURN a.name", "Projecting and returning graphs is not available in this implementation of Cypher due to lack of support for multiple graphs. (line 1, column 6 (offset: 5))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("return node that's not there", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (n) where id(n) = 0 return bar", "Variable `bar` not defined (line 1, column 34 (offset: 33))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't allow a string after IN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) where id(n) IN '' return 1", "Type mismatch: expected List<T> but was String (line 1, column 26 (offset: 25))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't allow a integer after IN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) WHERE id(n) IN 1 RETURN 1", "Type mismatch: expected List<T> but was Integer (line 1, column 26 (offset: 25))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't allow a float after IN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) WHERE id(n) IN 1.0 RETURN 1", "Type mismatch: expected List<T> but was Float (line 1, column 26 (offset: 25))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("don't allow a boolean after IN", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) WHERE id(n) IN true RETURN 1", "Type mismatch: expected List<T> but was Boolean (line 1, column 26 (offset: 25))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("define node and treat it as a relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (r) where id(r) = 0 match (a)-[r]-(b) return r", "Type mismatch: r already defined with conflicting type Node (expected Relationship) (line 1, column 38 (offset: 37))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("redefine symbol in match", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a)-[r]-(r) return r", "Type mismatch: r already defined with conflicting type Relationship (expected Node) (line 1, column 16 (offset: 15))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cant use type() on nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (r) RETURN type(r)", "Type mismatch: expected Relationship but was Node (line 1, column 23 (offset: 22))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cant use labels() on relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH ()-[r]-() RETURN labels(r)", "Type mismatch: expected Node but was Relationship (line 1, column 31 (offset: 30))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cant use toInt() on booleans", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("RETURN toInt(true)", "Type mismatch: expected Float, Integer, Number or String but was Boolean (line 1, column 14 (offset: 13))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cant use toFloat() on booleans", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("RETURN toFloat(false)", "Type mismatch: expected Float, Integer, Number or String but was Boolean (line 1, column 16 (offset: 15))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cant use toString() on nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) RETURN toString(n)", "Type mismatch: expected Boolean, Float, Integer or String but was Node (line 1, column 27 (offset: 26))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cant use LENGTH on nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (n) where id(n) = 0 return length(n)", "Type mismatch: expected Path, String or List<T> but was Node (line 1, column 41 (offset: 40))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should know not to compare strings and numbers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a) where a.age =~ 13 return a", "Type mismatch: expected String but was Integer (line 1, column 26 (offset: 25))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should complain if shortest path has no relationship", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match p=shortestPath(n) return p", "shortestPath(...) requires a pattern containing a single relationship (line 1, column 9 (offset: 8))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match p=allShortestPaths(n) return p", "allShortestPaths(...) requires a pattern containing a single relationship (line 1, column 9 (offset: 8))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should complain if shortest path has multiple relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match p=shortestPath(a--()--b) where id(a) = 0 and id(b) = 1 return p", "shortestPath(...) requires a pattern containing a single relationship (line 1, column 9 (offset: 8))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match p=allShortestPaths(a--()--b) where id(a) = 0 and id(b) = 1 return p", "allShortestPaths(...) requires a pattern containing a single relationship (line 1, column 9 (offset: 8))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should complain if shortest path has a minimal length different from 0 or 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match p=shortestPath(a-[*2..3]->b) where id(a) = 0 and id(b) = 1 return p", "shortestPath(...) does not support a minimal length different from 0 or 1 (line 1, column 9 (offset: 8))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match p=allShortestPaths(a-[*2..3]->b) where id(a) = 0 and id(b) = 1 return p", "allShortestPaths(...) does not support a minimal length different from 0 or 1 (line 1, column 9 (offset: 8))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be semantically incorrect to refer to unknown variable in create constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("create constraint on (foo:Foo) assert bar.name is unique", "Variable `bar` not defined (line 1, column 39 (offset: 38))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be semantically incorrect to refer to nexted property in create constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("create constraint on (foo:Foo) assert foo.bar.name is unique", "Cannot index nested properties (line 1, column 47 (offset: 46))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be semantically incorrect to refer to unknown variable in drop constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("drop constraint on (foo:Foo) assert bar.name is unique", "Variable `bar` not defined (line 1, column 37 (offset: 36))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be semantically incorrect to refer to nested property in drop constraint", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("drop constraint on (foo:Foo) assert foo.bar.name is unique", "Cannot index nested properties (line 1, column 45 (offset: 44))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail when trying to create shortest paths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a), (b) create shortestPath((a)-[:T]->(b))", "shortestPath(...) cannot be used to CREATE (line 1, column 23 (offset: 22))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a), (b) create allShortestPaths((a)-[:T]->(b))", "allShortestPaths(...) cannot be used to CREATE (line 1, column 23 (offset: 22))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail when trying to merge shortest paths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a), (b) MERGE shortestPath((a)-[:T]->(b))", "shortestPath(...) cannot be used to MERGE (line 1, column 22 (offset: 21))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a), (b) MERGE allShortestPaths((a)-[:T]->(b))", "allShortestPaths(...) cannot be used to MERGE (line 1, column 22 (offset: 21))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail when trying to uniquely create shortest paths", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a), (b) MERGE shortestPath((a)-[:T]->(b))", "shortestPath(...) cannot be used to MERGE (line 1, column 22 (offset: 21))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a), (b) create allShortestPaths((a)-[:T]->(b))", "allShortestPaths(...) cannot be used to CREATE (line 1, column 23 (offset: 22))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail when reduce used with wrong separator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError(new StringOps(Predef$.MODULE$.augmentString("MATCH topRoute = (s)<-[:CONNECTED_TO*1..3]-(e)\n                            |WHERE id(s) = 1 AND id(e) = 2\n                            |RETURN reduce(weight=0, r in relationships(topRoute) : weight+r.cost) AS score\n                            |ORDER BY score ASC LIMIT 1\n                          ")).stripMargin(), "reduce(...) requires '| expression' (an accumulation expression) (line 3, column 8 (offset: 84))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail if old iterable separator", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a) where id(a) = 0 return filter(x in a.list : x.prop = 1)", "filter(...) requires a WHERE predicate (line 1, column 34 (offset: 33))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a) where id(a) = 0 return extract(x in a.list : x.prop)", "extract(...) requires '| expression' (an extract expression) (line 1, column 34 (offset: 33))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a) where id(a) = 0 return reduce(i = 0, x in a.List : i + x.prop)", "reduce(...) requires '| expression' (an accumulation expression) (line 1, column 34 (offset: 33))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a) where id(a) = 0 return any(x in a.list : x.prop = 1)", "any(...) requires a WHERE predicate (line 1, column 34 (offset: 33))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a) where id(a) = 0 return all(x in a.list : x.prop = 1)", "all(...) requires a WHERE predicate (line 1, column 34 (offset: 33))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a) where id(a) = 0 return single(x in a.list : x.prop = 1)", "single(...) requires a WHERE predicate (line 1, column 34 (offset: 33))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (a) where id(a) = 0 return none(x in a.list : x.prop = 1)", "none(...) requires a WHERE predicate (line 1, column 34 (offset: 33))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail if using a hint with an unknown variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match (n:Person)-->() using index m:Person(name) where n.name = \"kabam\" return n", "Variable `m` not defined (line 1, column 35 (offset: 34))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail if using a hint on a node with no label", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) USING INDEX n:Person(name) where n.name = \"Johan\" return n", "Cannot use index hint in this context. Must use label on node that hint is referring to. (line 1, column 11 (offset: 10))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail if using a hint on a node and not using the property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n:Person) USING INDEX n:Person(name) where n.lastname = \"Teleman\" return n", "Cannot use index hint in this context. Index hints are only supported for the following predicates in WHERE (either directly or as part of a top-level AND or OR): equality comparison, inequality (range) comparison, STARTS WITH, IN condition or checking property existence. The comparison cannot be performed between two property values. Note that the label and property comparison must be specified on a non-optional node (line 1, column 18 (offset: 17))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail if no parens around node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match n:Person return n", "Parentheses are required to identify nodes in patterns, i.e. (n) (line 1, column 7 (offset: 6))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("match n {foo: 'bar'} return n", "Parentheses are required to identify nodes in patterns, i.e. (n) (line 1, column 7 (offset: 6))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail if using non update clause inside foreach", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("FOREACH (n in [1] | WITH foo RETURN bar)", "Invalid use of WITH inside FOREACH (line 1, column 21 (offset: 20))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return custom type error for reduce", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("RETURN reduce(x = 0, y IN [1,2,3] | x + y^2)", "Type mismatch: accumulator is Integer but expression has type Float (line 1, column 39 (offset: 38))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should reject properties on shortest path relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (a), (b), shortestPath( (a)-[r* {x: 1}]->(b) ) RETURN *", "shortestPath(...) contains properties MapExpression(List((PropertyKeyName(x),SignedDecimalIntegerLiteral(1)))). This is currently not supported. (line 1, column 17 (offset: 16))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should reject properties on all shortest paths relationships", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (a), (b), allShortestPaths( (a)-[r* {x: 1}]->(b) ) RETURN *", "allShortestPaths(...) contains properties MapExpression(List((PropertyKeyName(x),SignedDecimalIntegerLiteral(1)))). This is currently not supported. (line 1, column 17 (offset: 16))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("aggregation inside looping queries is not allowed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String mess = "Can't use aggregating expressions inside of expressions executing over lists";
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) RETURN ALL(x in [1,2,3,4,5] WHERE count(*) = 0)", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (line 1, column 45 (offset: 44))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mess})), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) RETURN ANY(x in [1,2,3,4,5] WHERE count(*) = 0)", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (line 1, column 45 (offset: 44))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mess})), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) RETURN NONE(x in [1,2,3,4,5] WHERE count(*) = 0)", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (line 1, column 46 (offset: 45))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mess})), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) RETURN SINGLE(x in [1,2,3,4,5] WHERE count(*) = 0)", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (line 1, column 48 (offset: 47))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mess})), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) RETURN EXTRACT(x in [1,2,3,4,5] | count(*) = 0)", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (line 1, column 45 (offset: 44))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mess})), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) RETURN FILTER(x in [1,2,3,4,5] WHERE count(*) = 0)", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (line 1, column 48 (offset: 47))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mess})), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (n) RETURN REDUCE(acc = 0, x in [1,2,3,4,5] | acc + count(*))", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (line 1, column 59 (offset: 58))"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mess})), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("error message should contain full query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String query = "EXPLAIN MATCH (m), (n) RETURN m, n, o LIMIT 25";
                QueryExecutionException error = (QueryExecutionException)((Object)this.$outer.intercept((Function0)new Serializable(this, query){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$39 $outer;
                    private final String query$1;

                    public final Result apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$anonfun$$$outer().RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$anonfun$$$outer().graph()).execute(this.query$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.query$1 = query$1;
                    }
                }, ManifestFactory$.MODULE$.classType(QueryExecutionException.class)));
                List list = new StringOps(Predef$.MODULE$.augmentString(error.getMessage())).lines().toList();
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    String first = (String)colon2.head();
                    List list2 = colon2.tl$1();
                    if (list2 instanceof .colon.colon) {
                        .colon.colon colon3 = (.colon.colon)list2;
                        String second = (String)colon3.head();
                        List list3 = colon3.tl$1();
                        if (list3 instanceof .colon.colon) {
                            .colon.colon colon4 = (.colon.colon)list3;
                            String third = (String)colon4.head();
                            List list4 = colon4.tl$1();
                            if (Nil$.MODULE$.equals(list4)) {
                                Tuple3 tuple3;
                                Tuple3 tuple32 = tuple3 = new Tuple3((Object)first, (Object)second, (Object)third);
                                String first2 = (String)tuple32._1();
                                String second2 = (String)tuple32._2();
                                String third2 = (String)tuple32._3();
                                this.$outer.convertToStringShouldWrapper(first2).should(this.$outer.equal("Variable `o` not defined (line 1, column 37 (offset: 36))"), (Object)Equality$.MODULE$.default());
                                this.$outer.convertToStringShouldWrapper(second2).should(this.$outer.equal(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query}))), (Object)Equality$.MODULE$.default());
                                this.$outer.convertToStringShouldWrapper(third2).should(this.$outer.startWith().apply(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString(" ")).$times(37)).append((Object)"^").toString()));
                                return;
                            }
                        }
                    }
                }
                throw new MatchError((Object)list);
            }

            public /* synthetic */ SemanticErrorAcceptanceTest org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("positions should not be cached", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("EXPLAIN MATCH (m), (n) RETURN m, n, o LIMIT 25", "Variable `o` not defined (line 1, column 37 (offset: 36))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("MATCH (m), (n) RETURN m, n, o LIMIT 25", "Variable `o` not defined (line 1, column 29 (offset: 28))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("give a nice error message when using unknown arguments in point", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("RETURN point({xxx: 2.3, yyy: 4.5}) as point", "A map with keys 'xxx', 'yyy' is not describing a valid point, a point is described either by using cartesian coordinates e.g. {x: 2.3, y: 4.5, crs: 'cartesian'} or using geographic coordinates e.g. {latitude: 12.78, longitude: 56.7, crs: 'WGS-84'}. (line 1, column 14 (offset: 13))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should warn on over sized integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("RETURN 1766384027365849394756747201203756", "integer is too large (line 1, column 8 (offset: 7))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should warn when addition overflows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN ", " + 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE)})), "result of 9223372036854775807 + 1 cannot be represented as an integer (line 1, column 28 (offset: 27))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail nicely when addition overflows in runtime", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {t1} + {t2}"})).s((Seq)Nil$.MODULE$), "result of 9223372036854775807 + 1 cannot be represented as an integer", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t1"), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t2"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should warn when subtraction underflows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN ", " - 1"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MIN_VALUE)})), "result of -9223372036854775808 - 1 cannot be represented as an integer (line 1, column 29 (offset: 28))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail nicely when subtraction underflows in runtime", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {t1} - {t2}"})).s((Seq)Nil$.MODULE$), "result of -9223372036854775808 - 1 cannot be represented as an integer", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t1"), (Object)BoxesRunTime.boxToLong((long)Long.MIN_VALUE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t2"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should warn when multiplication overflows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN ", " * 10"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)Long.MAX_VALUE)})), "result of 9223372036854775807 * 10 cannot be represented as an integer (line 1, column 28 (offset: 27))", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail nicely when multiplication overflows in runtime", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {t1} + {t2}"})).s((Seq)Nil$.MODULE$), "result of 9223372036854775807 + 1 cannot be represented as an integer", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t1"), (Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"t2"), (Object)BoxesRunTime.boxToInteger((int)1))}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("fail when parsing larger than 64 bit integers", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticErrorAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$internal$cypher$acceptance$SemanticErrorAcceptanceTest$$executeAndEnsureError("RETURN toInt('10508455564958384115')", "integer, 10508455564958384115, is too large", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

