/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import org.neo4j.cypher.ExecutionEngineFunSuite;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a1A!\u0001\u0002\u0001\u001b\t\u0019\u0013+^3ss\u0016sw-\u001b8f!J|7-\u001a3ve\u0016\u001c\u0018iY2faR\fgnY3UKN$(BA\u0002\u0005\u0003)\t7mY3qi\u0006t7-\u001a\u0006\u0003\u000b\u0019\taaY=qQ\u0016\u0014(BA\u0004\t\u0003!Ig\u000e^3s]\u0006d'BA\u0005\u000b\u0003\u0015qWm\u001c\u001bk\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty\u0011#D\u0001\u0011\u0015\t)\u0001\"\u0003\u0002\u0013!\t9R\t_3dkRLwN\\#oO&tWMR;o'VLG/\u001a\u0005\u0006)\u0001!\t!F\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Y\u0001\"a\u0006\u0001\u000e\u0003\t\u0001")
public class QueryEngineProceduresAcceptanceTest
extends ExecutionEngineFunSuite {
    public QueryEngineProceduresAcceptanceTest() {
        this.test("Clearing the query caches should work with empty caches", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryEngineProceduresAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String query = "CALL dbms.clearQueryCaches()";
                Result result = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute(query);
                this.$outer.convertToStringShouldWrapper(result.next().toString()).should(this.$outer.equal("{value=Query cache already empty.}"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result.hasNext())).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Clearing the query caches should work properly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryEngineProceduresAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String q1 = "MATCH (n) RETURN n.prop";
                String q2 = "MATCH (n) WHERE n.prop = 3 RETURN n";
                String q3 = "MATCH (n) WHERE n.prop = 4 RETURN n";
                this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute(q1);
                this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute(q2);
                this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute(q3);
                this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute(q1);
                String query = "CALL dbms.clearQueryCaches()";
                Result result = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute(query);
                this.$outer.convertToStringShouldWrapper(result.next().toString()).should(this.$outer.equal("{value=Query caches successfully cleared of 3 queries.}"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result.hasNext())).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("Multiple calls to clearing the cache should work", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryEngineProceduresAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String q1 = "MATCH (n) RETURN n.prop";
                this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute(q1);
                String query = "CALL dbms.clearQueryCaches()";
                Result result = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute(query);
                this.$outer.convertToStringShouldWrapper(result.next().toString()).should(this.$outer.equal("{value=Query caches successfully cleared of 1 queries.}"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result.hasNext())).should(this.$outer.be().apply(false));
                Result result2 = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute(query);
                this.$outer.convertToStringShouldWrapper(result2.next().toString()).should(this.$outer.equal("{value=Query cache already empty.}"), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)result2.hasNext())).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

