/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import org.neo4j.cypher.ExecutionEngineFunSuite;
import org.neo4j.cypher.ExecutionEngineTestSupport;
import org.neo4j.cypher.InvalidArgumentException;
import org.neo4j.cypher.NewPlannerMonitor;
import org.neo4j.cypher.NewPlannerTestSupport;
import org.neo4j.cypher.NewRuntimeMonitor;
import org.neo4j.cypher.SyntaxException;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.CRS$;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.CartesianPoint;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.GeographicPoint;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.executionplan.InternalExecutionResult;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.cypher.acceptance.SpatialFunctionsAcceptanceTest$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.Matcher;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001m1A!\u0001\u0002\u0001\u001b\tq2\u000b]1uS\u0006dg)\u001e8di&|gn]!dG\u0016\u0004H/\u00198dKR+7\u000f\u001e\u0006\u0003\u0007\u0011\t!\"Y2dKB$\u0018M\\2f\u0015\t)a!\u0001\u0004dsBDWM\u001d\u0006\u0003\u000f!\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u0013)\tQA\\3pi)T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019\u0019\u0002CA\b\u0012\u001b\u0005\u0001\"BA\u0003\t\u0013\t\u0011\u0002CA\fFq\u0016\u001cW\u000f^5p]\u0016sw-\u001b8f\rVt7+^5uKB\u0011q\u0002F\u0005\u0003+A\u0011QCT3x!2\fgN\\3s)\u0016\u001cHoU;qa>\u0014H\u000fC\u0003\u0018\u0001\u0011\u0005\u0001$\u0001\u0004=S:LGO\u0010\u000b\u00023A\u0011!\u0004A\u0007\u0002\u0005\u0001")
public class SpatialFunctionsAcceptanceTest
extends ExecutionEngineFunSuite
implements NewPlannerTestSupport {
    private final String org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion;
    private final String org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion;
    private final String org$neo4j$cypher$NewPlannerTestSupport$$currentVersion;
    private final NewRuntimeMonitor newRuntimeMonitor;

    public String org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion() {
        return this.org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion;
    }

    public String org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion() {
        return this.org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion;
    }

    public String org$neo4j$cypher$NewPlannerTestSupport$$currentVersion() {
        return this.org$neo4j$cypher$NewPlannerTestSupport$$currentVersion;
    }

    public NewRuntimeMonitor newRuntimeMonitor() {
        return this.newRuntimeMonitor;
    }

    public /* synthetic */ void org$neo4j$cypher$NewPlannerTestSupport$$super$initTest() {
        ExecutionEngineTestSupport.class.initTest((CypherFunSuite)this);
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion_$eq(String x$1) {
        this.org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion = x$1;
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion_$eq(String x$1) {
        this.org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion = x$1;
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$org$neo4j$cypher$NewPlannerTestSupport$$currentVersion_$eq(String x$1) {
        this.org$neo4j$cypher$NewPlannerTestSupport$$currentVersion = x$1;
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$newRuntimeMonitor_$eq(NewRuntimeMonitor x$1) {
        this.newRuntimeMonitor = x$1;
    }

    public scala.collection.immutable.Map<Setting<?>, String> databaseConfig() {
        return NewPlannerTestSupport.class.databaseConfig((ExecutionEngineFunSuite)this);
    }

    public void initTest() {
        NewPlannerTestSupport.class.initTest((ExecutionEngineFunSuite)this);
    }

    public <T> T executeScalarWithAllPlanners(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlanners((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T executeScalarWithAllPlannersAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlannersAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T executeScalarWithAllPlannersAndRuntimes(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlannersAndRuntimes((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T executeScalarWithAllPlannersAndRuntimesAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlannersAndRuntimesAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlanners(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlanners((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithBothPlannersAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithBothPlannersAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithBothPlanners(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithBothPlanners((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithCostPlannerOnly(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithCostPlannerOnly((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndCompatibilityModeReplaceNaNs(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndCompatibilityModeReplaceNaNs((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithCostPlannerAndInterpretedRuntimeOnly(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithCostPlannerAndInterpretedRuntimeOnly((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithCostPlannerAndCompiledRuntimeOnly(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithCostPlannerAndCompiledRuntimeOnly((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndRuntimesAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndRuntimesAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndRuntimes(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndRuntimes((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithCompatibilityAndAssertSimilarPlans(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithCompatibilityAndAssertSimilarPlans((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithCompatibilityAndAssertSimilarPlans(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithCompatibilityAndAssertSimilarPlans((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public void assertPlansAreSimilar(String otherVersion, InternalExecutionResult other, InternalExecutionResult current, String queryText, String errorMsg, boolean replaceNaNs) {
        NewPlannerTestSupport.class.assertPlansAreSimilar((ExecutionEngineFunSuite)this, (String)otherVersion, (InternalExecutionResult)other, (InternalExecutionResult)current, (String)queryText, (String)errorMsg, (boolean)replaceNaNs);
    }

    public void assertResultsAreSame(InternalExecutionResult result1, InternalExecutionResult result2, String queryText, String errorMsg, boolean replaceNaNs) {
        NewPlannerTestSupport.class.assertResultsAreSame((ExecutionEngineFunSuite)this, (InternalExecutionResult)result1, (InternalExecutionResult)result2, (String)queryText, (String)errorMsg, (boolean)replaceNaNs);
    }

    public InternalExecutionResult innerExecute(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.innerExecute((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public Nothing$ execute(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.execute((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T monitoringNewPlanner(Function0<T> action, Function1<List<NewPlannerMonitor.NewPlannerMonitorCall>, BoxedUnit> testPlanner, Function1<List<NewRuntimeMonitor.NewRuntimeMonitorCall>, BoxedUnit> testRuntime) {
        return (T)NewPlannerTestSupport.class.monitoringNewPlanner((ExecutionEngineFunSuite)this, action, testPlanner, testRuntime);
    }

    public NewPlannerTestSupport.RichInternalExecutionResults RichInternalExecutionResults(InternalExecutionResult res) {
        return NewPlannerTestSupport.class.RichInternalExecutionResults((ExecutionEngineFunSuite)this, (InternalExecutionResult)res);
    }

    public NewPlannerTestSupport.RichMapSeq RichMapSeq(Seq<scala.collection.immutable.Map<String, Object>> res) {
        return NewPlannerTestSupport.class.RichMapSeq((ExecutionEngineFunSuite)this, res);
    }

    public Matcher<InternalExecutionResult> evaluateTo(Seq<scala.collection.immutable.Map<String, Object>> expected) {
        return NewPlannerTestSupport.class.evaluateTo((ExecutionEngineFunSuite)this, expected);
    }

    public boolean assertResultsAreSame$default$5() {
        return NewPlannerTestSupport.class.assertResultsAreSame$default$5((ExecutionEngineFunSuite)this);
    }

    public boolean assertPlansAreSimilar$default$6() {
        return NewPlannerTestSupport.class.assertPlansAreSimilar$default$6((ExecutionEngineFunSuite)this);
    }

    public SpatialFunctionsAcceptanceTest() {
        NewPlannerTestSupport.class.$init$((ExecutionEngineFunSuite)this);
        this.test("point function should work with literal map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("RETURN point({latitude: 12.78, longitude: 56.7}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new GeographicPoint(56.7, 12.78, CRS$.MODULE$.WGS84()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should work with literal map and cartesian coordinates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("RETURN point({x: 2.3, y: 4.5, crs: 'cartesian'}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new CartesianPoint(2.3, 4.5, CRS$.MODULE$.Cartesian()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should work with literal map and geographic coordinates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("RETURN point({longitude: 2.3, latitude: 4.5, crs: 'WGS-84'}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new GeographicPoint(2.3, 4.5, CRS$.MODULE$.WGS84()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should not work with literal map and incorrect cartesian CRS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.an(ManifestFactory$.MODULE$.classType(InvalidArgumentException.class)).shouldBe(this.$outer.thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$4 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer().executeWithAllPlanners("RETURN point({x: 2.3, y: 4.5, crs: 'cart'}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }

            public /* synthetic */ SpatialFunctionsAcceptanceTest org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should not work with literal map and incorrect geographic CRS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.an(ManifestFactory$.MODULE$.classType(InvalidArgumentException.class)).shouldBe(this.$outer.thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$5 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer().executeWithAllPlanners("RETURN point({x: 2.3, y: 4.5, crs: 'WGS84'}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }

            public /* synthetic */ SpatialFunctionsAcceptanceTest org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should work with integer arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("RETURN point({x: 2, y: 4}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new CartesianPoint(2.0, 4.0, CRS$.MODULE$.Cartesian()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail properly if missing cartesian coordinates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.an(ManifestFactory$.MODULE$.classType(InvalidArgumentException.class)).shouldBe(this.$outer.thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer().executeWithAllPlanners("RETURN point({params}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"params"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"y"), (Object)BoxesRunTime.boxToDouble((double)1.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"crs"), (Object)"cartesian")})))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }

            public /* synthetic */ SpatialFunctionsAcceptanceTest org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail properly if missing geographic longitude", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.an(ManifestFactory$.MODULE$.classType(InvalidArgumentException.class)).shouldBe(this.$outer.thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer().executeWithAllPlanners("RETURN point({params}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"params"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latitude"), (Object)BoxesRunTime.boxToDouble((double)1.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"crs"), (Object)"WGS-84")})))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }

            public /* synthetic */ SpatialFunctionsAcceptanceTest org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail properly if missing geographic latitude", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.an(ManifestFactory$.MODULE$.classType(InvalidArgumentException.class)).shouldBe(this.$outer.thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer().executeWithAllPlanners("RETURN point({params}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"params"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"longitude"), (Object)BoxesRunTime.boxToDouble((double)1.0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"crs"), (Object)"WGS-84")})))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }

            public /* synthetic */ SpatialFunctionsAcceptanceTest org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail properly if unknown coordinate system", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.an(ManifestFactory$.MODULE$.classType(InvalidArgumentException.class)).shouldBe(this.$outer.thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer().executeWithAllPlanners("RETURN point({params}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"params"), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"y"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"crs"), (Object)"WGS-1337")})))}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }

            public /* synthetic */ SpatialFunctionsAcceptanceTest org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should default to Cartesian if missing cartesian CRS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("RETURN point({x: 2.3, y: 4.5}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new CartesianPoint(2.3, 4.5, CRS$.MODULE$.Cartesian()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should default to WGS84 if missing geographic CRS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("RETURN point({longitude: 2.3, latitude: 4.5}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new GeographicPoint(2.3, 4.5, CRS$.MODULE$.WGS84()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should allow Geographic CRS with x/y coordinates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("RETURN point({x: 2.3, y: 4.5, crs: 'WGS-84'}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new GeographicPoint(2.3, 4.5, CRS$.MODULE$.WGS84()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not allow Cartesian CRS with latitude/longitude coordinates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.an(ManifestFactory$.MODULE$.classType(InvalidArgumentException.class)).shouldBe(this.$outer.thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$14 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer().executeWithAllPlanners("RETURN point({longitude: 2.3, latitude: 4.5, crs: 'cartesian'}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
            }

            public /* synthetic */ SpatialFunctionsAcceptanceTest org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should work with previous map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("WITH {latitude: 12.78, longitude: 56.7} as data RETURN point(data) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new GeographicPoint(56.7, 12.78, CRS$.MODULE$.WGS84()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should work on co-located points", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("WITH point({latitude: 12.78, longitude: 56.7}) as point RETURN distance(point,point) as dist", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point", "distance"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dist"), (Object)BoxesRunTime.boxToDouble((double)0.0))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should work on nearby cartesian points", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH point({x: 2.3, y: 4.5, crs: 'cartesian'}) as p1, point({x: 1.1, y: 5.4, crs: 'cartesian'}) as p2\n        |RETURN distance(p1,p2) as dist\n      ")).stripMargin(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point", "distance"})));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)result.columnAs("dist").next()))).should(this.$outer.equal(BoxesRunTime.boxToDouble((double)1.5)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should work on nearby points", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH point({longitude: 12.78, latitude: 56.7}) as p1, point({latitude: 56.71, longitude: 12.79}) as p2\n        |RETURN distance(p1,p2) as dist\n      ")).stripMargin(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point", "distance"})));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)Math.round(BoxesRunTime.unboxToDouble((Object)result.columnAs("dist").next())))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1270)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should work on distant points", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH point({latitude: 56.7, longitude: 12.78}) as p1, point({longitude: -51.9, latitude: -16.7}) as p2\n        |RETURN distance(p1,p2) as dist\n      ")).stripMargin(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point", "distance"})));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)Math.round(BoxesRunTime.unboxToDouble((Object)result.columnAs("dist").next())))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)10116214)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should fail if provided with points from different CRS", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                IllegalArgumentException error = (IllegalArgumentException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$20 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer().executeWithAllPlanners(new StringOps(Predef$.MODULE$.augmentString("WITH point({x: 2.3, y: 4.5, crs: 'cartesian'}) as p1, point({longitude: 1.1, latitude: 5.4, crs: 'WGS-84'}) as p2\n        |RETURN distance(p1,p2) as dist")).stripMargin(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalArgumentException.class));
                String $org_scalatest_assert_macro_left = error.getMessage();
                String $org_scalatest_assert_macro_right = "Invalid points passed to distance(p1, p2)";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ SpatialFunctionsAcceptanceTest org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should measure distance from Copenhagen train station to Neo4j in Malm\u00f6", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH point({latitude: 55.672874, longitude: 12.564590}) as p1, point({latitude: 55.611784, longitude: 12.994341}) as p2\n        |RETURN distance(p1,p2) as dist\n      ")).stripMargin(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point", "distance"})));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)Math.round(BoxesRunTime.unboxToDouble((Object)result.columnAs("dist").next())))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)27842)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should work with two null inputs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("RETURN distance(null, null) as dist", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dist"), null)}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should return null with lhs null input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners(new StringOps(Predef$.MODULE$.augmentString("WITH point({latitude: 55.672874, longitude: 12.564590}) as p1\n                                          |RETURN distance(null, p1) as dist")).stripMargin(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dist"), null)}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should return null with rhs null input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners(new StringOps(Predef$.MODULE$.augmentString("WITH point({latitude: 55.672874, longitude: 12.564590}) as p1\n                                          |RETURN distance(p1, null) as dist")).stripMargin(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dist"), null)}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should return null if a point is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithCostPlannerAndInterpretedRuntimeOnly("RETURN distance(point({latitude:3,longitude:7}),point({latitude:null, longitude:3})) as dist;", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dist"), null)}))}))), (Object)Equality$.MODULE$.default());
                result = this.$outer.executeWithCostPlannerAndInterpretedRuntimeOnly("RETURN distance(point({latitude:3,longitude:null}),point({latitude:7, longitude:3})) as dist;", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dist"), null)}))}))), (Object)Equality$.MODULE$.default());
                result = this.$outer.executeWithCostPlannerAndInterpretedRuntimeOnly("RETURN distance(point({x:3,y:7}),point({x:null, y:3})) as dist;", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dist"), null)}))}))), (Object)Equality$.MODULE$.default());
                result = this.$outer.executeWithCostPlannerAndInterpretedRuntimeOnly("RETURN distance(point({x:3,y:null}),point({x:7, y:3})) as dist;", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dist"), null)}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("distance function should fail on wrong type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SyntaxException error = (SyntaxException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$26 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer().executeWithAllPlanners("RETURN distance(1, 2) as dist", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(SyntaxException.class));
                String $org_scalatest_assert_macro_left = error.getMessage();
                String $org_scalatest_assert_macro_right = "Type mismatch: expected Point or Geometry but was Integer";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ SpatialFunctionsAcceptanceTest org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should work with node properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latitude"), (Object)BoxesRunTime.boxToDouble((double)12.78)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"longitude"), (Object)BoxesRunTime.boxToDouble((double)56.7))})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Place"}));
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("MATCH (p:Place) RETURN point({latitude: p.latitude, longitude: p.longitude}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new GeographicPoint(56.7, 12.78, CRS$.MODULE$.WGS84()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should work with relationship properties", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship r = this.$outer.relate(this.$outer.createNode(), this.$outer.createNode(), "PASS_THROUGH", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latitude"), (Object)BoxesRunTime.boxToDouble((double)12.78)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"longitude"), (Object)BoxesRunTime.boxToDouble((double)56.7))})));
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("MATCH ()-[r:PASS_THROUGH]->() RETURN point({latitude: r.latitude, longitude: r.longitude}) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new GeographicPoint(56.7, 12.78, CRS$.MODULE$.WGS84()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should work with node as map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"latitude"), (Object)BoxesRunTime.boxToDouble((double)12.78)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"longitude"), (Object)BoxesRunTime.boxToDouble((double)56.7))})), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Place"}));
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("MATCH (p:Place) RETURN point(p) as point", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new GeographicPoint(56.7, 12.78, CRS$.MODULE$.WGS84()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should work with null input", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("RETURN point(null) as p", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p"), null)}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should return null if the map that backs it up contains a null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                InternalExecutionResult result = this.$outer.executeWithCostPlannerAndInterpretedRuntimeOnly("RETURN point({latitude:null, longitude:3}) as pt;", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pt"), null)}))}))), (Object)Equality$.MODULE$.default());
                result = this.$outer.executeWithCostPlannerAndInterpretedRuntimeOnly("RETURN point({latitude:3, longitude:null}) as pt;", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pt"), null)}))}))), (Object)Equality$.MODULE$.default());
                result = this.$outer.executeWithCostPlannerAndInterpretedRuntimeOnly("RETURN point({x:null, y:3}) as pt;", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pt"), null)}))}))), (Object)Equality$.MODULE$.default());
                result = this.$outer.executeWithCostPlannerAndInterpretedRuntimeOnly("RETURN point({x:3, y:null}) as pt;", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pt"), null)}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("point function should fail on wrong type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SyntaxException error = (SyntaxException)this.$outer.intercept((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$32 $outer;

                    public final InternalExecutionResult apply() {
                        return this.$outer.org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer().executeWithAllPlanners("RETURN point(1) as dist", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ManifestFactory$.MODULE$.classType(SyntaxException.class));
                String $org_scalatest_assert_macro_left = error.getMessage();
                String $org_scalatest_assert_macro_right = "Type mismatch: expected Map, Node or Relationship but was Integer";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            public /* synthetic */ SpatialFunctionsAcceptanceTest org$neo4j$internal$cypher$acceptance$SpatialFunctionsAcceptanceTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.ignore("point function should be assignable to node property", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SpatialFunctionsAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.createLabeledNode((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Place"}));
                InternalExecutionResult result = this.$outer.executeWithAllPlanners("MATCH (p:Place) SET p.location = point({latitude: 56.7, longitude: 12.78}) RETURN p.location", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.useProjectionWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"point"})));
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"point"), (Object)new GeographicPoint(56.7, 12.78, CRS$.MODULE$.WGS84()))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

