/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import org.neo4j.cypher.ExecutionEngineFunSuite;
import org.neo4j.cypher.ExecutionEngineTestSupport;
import org.neo4j.cypher.NewPlannerMonitor;
import org.neo4j.cypher.NewPlannerTestSupport;
import org.neo4j.cypher.NewRuntimeMonitor;
import org.neo4j.cypher.internal.compatibility.v3_3.runtime.executionplan.InternalExecutionResult;
import org.neo4j.cypher.internal.frontend.v3_3.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.config.Setting;
import org.scalatest.Tag;
import org.scalatest.matchers.Matcher;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u00112A!\u0001\u0002\u0001\u001b\tQ\u0012+^3ssBc\u0017M\\\"p[B\fG/\u001b2jY&$\u0018\u0010V3ti*\u00111\u0001B\u0001\u000bC\u000e\u001cW\r\u001d;b]\u000e,'BA\u0003\u0007\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0001C\u0001\tS:$XM\u001d8bY*\u0011\u0011BC\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001AD\n\u0011\u0005=\tR\"\u0001\t\u000b\u0005\u0015A\u0011B\u0001\n\u0011\u0005])\u00050Z2vi&|g.\u00128hS:,g)\u001e8Tk&$X\r\u0005\u0002\u0010)%\u0011Q\u0003\u0005\u0002\u0016\u001d\u0016<\b\u000b\\1o]\u0016\u0014H+Z:u'V\u0004\bo\u001c:u\u0011\u00159\u0002\u0001\"\u0001\u0019\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t!\u0001C\u0003\u001d\u0001\u0011%Q$\u0001\u0005nC.,G)\u0019;b)\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSR\u0004")
public class QueryPlanCompatibilityTest
extends ExecutionEngineFunSuite
implements NewPlannerTestSupport {
    private final String org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion;
    private final String org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion;
    private final String org$neo4j$cypher$NewPlannerTestSupport$$currentVersion;
    private final NewRuntimeMonitor newRuntimeMonitor;

    public String org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion() {
        return this.org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion;
    }

    public String org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion() {
        return this.org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion;
    }

    public String org$neo4j$cypher$NewPlannerTestSupport$$currentVersion() {
        return this.org$neo4j$cypher$NewPlannerTestSupport$$currentVersion;
    }

    public NewRuntimeMonitor newRuntimeMonitor() {
        return this.newRuntimeMonitor;
    }

    public /* synthetic */ void org$neo4j$cypher$NewPlannerTestSupport$$super$initTest() {
        ExecutionEngineTestSupport.class.initTest((CypherFunSuite)this);
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion_$eq(String x$1) {
        this.org$neo4j$cypher$NewPlannerTestSupport$$otherReadVersion = x$1;
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion_$eq(String x$1) {
        this.org$neo4j$cypher$NewPlannerTestSupport$$otherWriteVersion = x$1;
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$org$neo4j$cypher$NewPlannerTestSupport$$currentVersion_$eq(String x$1) {
        this.org$neo4j$cypher$NewPlannerTestSupport$$currentVersion = x$1;
    }

    public void org$neo4j$cypher$NewPlannerTestSupport$_setter_$newRuntimeMonitor_$eq(NewRuntimeMonitor x$1) {
        this.newRuntimeMonitor = x$1;
    }

    public Map<Setting<?>, String> databaseConfig() {
        return NewPlannerTestSupport.class.databaseConfig((ExecutionEngineFunSuite)this);
    }

    public void initTest() {
        NewPlannerTestSupport.class.initTest((ExecutionEngineFunSuite)this);
    }

    public <T> T executeScalarWithAllPlanners(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlanners((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T executeScalarWithAllPlannersAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlannersAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T executeScalarWithAllPlannersAndRuntimes(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlannersAndRuntimes((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T executeScalarWithAllPlannersAndRuntimesAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return (T)NewPlannerTestSupport.class.executeScalarWithAllPlannersAndRuntimesAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlanners(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlanners((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithBothPlannersAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithBothPlannersAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithBothPlanners(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithBothPlanners((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithCostPlannerOnly(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithCostPlannerOnly((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndCompatibilityModeReplaceNaNs(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndCompatibilityModeReplaceNaNs((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithCostPlannerAndInterpretedRuntimeOnly(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithCostPlannerAndInterpretedRuntimeOnly((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithCostPlannerAndCompiledRuntimeOnly(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithCostPlannerAndCompiledRuntimeOnly((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndRuntimesAndCompatibilityMode(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndRuntimesAndCompatibilityMode((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithAllPlannersAndRuntimes(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithAllPlannersAndRuntimes((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult updateWithCompatibilityAndAssertSimilarPlans(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.updateWithCompatibilityAndAssertSimilarPlans((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public InternalExecutionResult executeWithCompatibilityAndAssertSimilarPlans(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.executeWithCompatibilityAndAssertSimilarPlans((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public void assertPlansAreSimilar(String otherVersion, InternalExecutionResult other, InternalExecutionResult current, String queryText, String errorMsg, boolean replaceNaNs) {
        NewPlannerTestSupport.class.assertPlansAreSimilar((ExecutionEngineFunSuite)this, (String)otherVersion, (InternalExecutionResult)other, (InternalExecutionResult)current, (String)queryText, (String)errorMsg, (boolean)replaceNaNs);
    }

    public void assertResultsAreSame(InternalExecutionResult result1, InternalExecutionResult result2, String queryText, String errorMsg, boolean replaceNaNs) {
        NewPlannerTestSupport.class.assertResultsAreSame((ExecutionEngineFunSuite)this, (InternalExecutionResult)result1, (InternalExecutionResult)result2, (String)queryText, (String)errorMsg, (boolean)replaceNaNs);
    }

    public InternalExecutionResult innerExecute(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.innerExecute((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public Nothing$ execute(String queryText, Seq<Tuple2<String, Object>> params) {
        return NewPlannerTestSupport.class.execute((ExecutionEngineFunSuite)this, (String)queryText, params);
    }

    public <T> T monitoringNewPlanner(Function0<T> action, Function1<List<NewPlannerMonitor.NewPlannerMonitorCall>, BoxedUnit> testPlanner, Function1<List<NewRuntimeMonitor.NewRuntimeMonitorCall>, BoxedUnit> testRuntime) {
        return (T)NewPlannerTestSupport.class.monitoringNewPlanner((ExecutionEngineFunSuite)this, action, testPlanner, testRuntime);
    }

    public NewPlannerTestSupport.RichInternalExecutionResults RichInternalExecutionResults(InternalExecutionResult res) {
        return NewPlannerTestSupport.class.RichInternalExecutionResults((ExecutionEngineFunSuite)this, (InternalExecutionResult)res);
    }

    public NewPlannerTestSupport.RichMapSeq RichMapSeq(Seq<Map<String, Object>> res) {
        return NewPlannerTestSupport.class.RichMapSeq((ExecutionEngineFunSuite)this, res);
    }

    public Matcher<InternalExecutionResult> evaluateTo(Seq<Map<String, Object>> expected) {
        return NewPlannerTestSupport.class.evaluateTo((ExecutionEngineFunSuite)this, expected);
    }

    public boolean assertResultsAreSame$default$5() {
        return NewPlannerTestSupport.class.assertResultsAreSame$default$5((ExecutionEngineFunSuite)this);
    }

    public boolean assertPlansAreSimilar$default$6() {
        return NewPlannerTestSupport.class.assertPlansAreSimilar$default$6((ExecutionEngineFunSuite)this);
    }

    private void makeData() {
        ObjectRef prev = ObjectRef.create(null);
        package$.MODULE$.Range().apply(0, 1000).foreach$mVc$sp((Function1)new Serializable(this, prev){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryPlanCompatibilityTest $outer;
            private final ObjectRef prev$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Node node = this.$outer.graph().createNode(new Label[]{Label.label((String)"Person")});
                node.setProperty("name", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Joe_", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})));
                node.setProperty("age", (Object)BoxesRunTime.boxToInteger((int)(1 + i)));
                if ((Node)this.prev$1.elem != null) {
                    Relationship r = ((Node)this.prev$1.elem).createRelationshipTo(node, RelationshipType.withName((String)"KNOWS"));
                    r.setProperty("since", (Object)BoxesRunTime.boxToInteger((int)(1970 + i)));
                }
                this.prev$1.elem = node;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.prev$1 = prev$1;
            }
        });
    }

    public QueryPlanCompatibilityTest() {
        NewPlannerTestSupport.class.$init$((ExecutionEngineFunSuite)this);
        this.test("should produce compatible plans for simple MATCH node query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryPlanCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.executeWithCompatibilityAndAssertSimilarPlans("MATCH (n:Person) RETURN n", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should produce compatible plans for simple MATCH relationship query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryPlanCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.executeWithCompatibilityAndAssertSimilarPlans("MATCH (n:Person)-[r:KNOWS]->(m) RETURN r", (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should produce compatible plans with predicates", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryPlanCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.executeWithCompatibilityAndAssertSimilarPlans(new StringOps(Predef$.MODULE$.augmentString("\n        |MATCH (n:Person) WHERE n.name STARTS WITH 'Joe' AND n.age >= 42\n        |RETURN count(n)\n      ")).stripMargin(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should produce compatible plans with unwind", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryPlanCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.executeWithCompatibilityAndAssertSimilarPlans(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH 'Joe' as name\n        |UNWIND [42,43,44] as age\n        |MATCH (n:Person) WHERE n.name STARTS WITH name AND n.age >= age\n        |RETURN count(n)\n      ")).stripMargin(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.ignore("should produce compatible plans for complex query", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ QueryPlanCompatibilityTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.executeWithCompatibilityAndAssertSimilarPlans(new StringOps(Predef$.MODULE$.augmentString("\n        |WITH 'Joe' as name\n        |UNWIND [42,43,44] as age\n        |MATCH (n:Person) WHERE n.name STARTS WITH name AND n.age >= age\n        |OPTIONAL MATCH (n)-[r:KNOWS]->(m) WHERE exists(r.since)\n        |RETURN count(r)\n      ")).stripMargin(), (Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

