/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.cypher.acceptance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.internal.cypher.acceptance.ProcedureCallAcceptanceTest;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.proc.Neo4jTypes;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.TypeMatcherHelper$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y1A!\u0001\u0002\u0001\u001b\t\tc)\u001e8di&|gnQ1mYN+\b\u000f]8si\u0006\u001b7-\u001a9uC:\u001cW\rV3ti*\u00111\u0001B\u0001\u000bC\u000e\u001cW\r\u001d;b]\u000e,'BA\u0003\u0007\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0001C\u0001\tS:$XM\u001d8bY*\u0011\u0011BC\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u00111\u0004\u0015:pG\u0016$WO]3DC2d\u0017iY2faR\fgnY3UKN$\b\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\ty\u0001\u0001")
public class FunctionCallSupportAcceptanceTest
extends ProcedureCallAcceptanceTest {
    public FunctionCallSupportAcceptanceTest() {
        this.test("should return correctly typed map result (even if converting to and from scala representation internally)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashMap<String, Object> value = new HashMap<String, Object>();
                value.put("name", "Cypher");
                value.put("level", BoxesRunTime.boxToInteger((int)9001));
                this.$outer.registerUserFunction(value, this.$outer.registerUserFunction$default$2());
                this.$outer.convertToAnyShouldWrapper(Predef$.MODULE$.refArrayOps(this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("RETURN my.first.value()").stream().toArray()).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{Collections.singletonMap("my.first.value()", value)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return correctly typed list result (even if converting to and from scala representation internally)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<String> value = new ArrayList<String>();
                value.add("Norris");
                value.add("Strange");
                this.$outer.registerUserFunction(value, this.$outer.registerUserFunction$default$2());
                this.$outer.convertToAnyShouldWrapper(Predef$.MODULE$.refArrayOps(this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("RETURN my.first.value() AS out").stream().toArray()).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{Collections.singletonMap("out", value)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return correctly typed stream result (even if converting to and from scala representation internally)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<String> value = new ArrayList<String>();
                value.add("Norris");
                value.add("Strange");
                Stream<E> stream = value.stream();
                this.$outer.registerUserFunction(stream, this.$outer.registerUserFunction$default$2());
                this.$outer.convertToAnyShouldWrapper(Predef$.MODULE$.refArrayOps(this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("RETURN my.first.value() AS out").stream().toArray()).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Map[]{Collections.singletonMap("out", stream)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not copy lists unnecessarily", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<String> value = new ArrayList<String>();
                value.add("Norris");
                value.add("Strange");
                this.$outer.registerUserFunction(value, this.$outer.registerUserFunction$default$2());
                V returned = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("RETURN my.first.value() AS out").next().get("out");
                TypeMatcherHelper$.MODULE$.checkAnType(this.$outer.convertToAnyShouldWrapper(returned).leftSideValue(), this.$outer.an(ManifestFactory$.MODULE$.classType(ArrayList.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
                this.$outer.convertToAnyShouldWrapper(returned).shouldBe(value);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not copy unnecessarily with nested types", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<Object> value = new ArrayList<Object>();
                ArrayList<E> inner = new ArrayList<E>();
                value.add("Norris");
                value.add(inner);
                this.$outer.registerUserFunction(value, this.$outer.registerUserFunction$default$2());
                V returned = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("RETURN my.first.value() AS out").next().get("out");
                TypeMatcherHelper$.MODULE$.checkAnType(this.$outer.convertToAnyShouldWrapper(returned).leftSideValue(), this.$outer.an(ManifestFactory$.MODULE$.classType(ArrayList.class, ManifestFactory$.MODULE$.wildcardType(ManifestFactory$.MODULE$.Nothing(), ManifestFactory$.MODULE$.Any()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
                this.$outer.convertToAnyShouldWrapper(returned).shouldBe(value);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle interacting with list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ FunctionCallSupportAcceptanceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayList<Integer> value = new ArrayList<Integer>();
                value.add(Predef$.MODULE$.int2Integer(1));
                value.add(Predef$.MODULE$.int2Integer(3));
                this.$outer.registerUserFunction(value, (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTInteger));
                V returned = this.$outer.RichGraphDatabaseQueryService((GraphDatabaseQueryService)this.$outer.graph()).execute("WITH my.first.value() AS list RETURN list[0] + list[1] AS out").next().get("out");
                this.$outer.convertToAnyShouldWrapper(returned).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)4)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

